/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.ValidatingDialog;
import workbench.interfaces.ValidatingComponent;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.StringUtil;
import workbench.util.WbThread;

public class WbFontChooser
extends JPanel
implements ValidatingComponent {
    private boolean updateing;
    private WbThread fontFiller;
    private final boolean monospacedOnly;
    private Font toSelect;
    public JCheckBox boldCheckBox;
    public JList fontNameList;
    public JComboBox fontSizeComboBox;
    public JCheckBox italicCheckBox;
    public JScrollPane jScrollPane1;
    public JLabel sampleLabel;

    public WbFontChooser(boolean bl) {
        this.initComponents();
        this.monospacedOnly = bl;
    }

    @Override
    public boolean validateInput() {
        Font font = this.getSelectedFont();
        if (font == null) {
            return false;
        }
        if (this.monospacedOnly && !this.isMonospace(font)) {
            WbSwingUtilities.showErrorMessageKey(this, "ErrOnlyMonoFont");
            return false;
        }
        Object object = this.fontSizeComboBox.getSelectedItem();
        if (object == null) {
            object = this.fontSizeComboBox.getEditor().getItem();
        }
        if (StringUtil.isNumber(object.toString())) {
            return true;
        }
        String string = ResourceMgr.getFormattedString("ErrInvalidNumber", object);
        WbSwingUtilities.showErrorMessage(string);
        return false;
    }

    @Override
    public void componentDisplayed() {
        this.fillFontList();
    }

    @Override
    public void componentWillBeClosed() {
        if (this.fontFiller != null) {
            this.fontFiller.interrupt();
        }
    }

    public void setSelectedFont(Font font) {
        if (this.fontNameList.getModel().getSize() <= 0) {
            this.toSelect = font;
            return;
        }
        this.updateing = true;
        try {
            if (font != null) {
                String string = font.getFamily();
                String string2 = Integer.toString(font.getSize());
                int n = font.getStyle();
                this.fontNameList.setSelectedValue(string, true);
                this.fontSizeComboBox.setSelectedItem(string2);
                this.boldCheckBox.setSelected((n & 1) == 1);
                this.italicCheckBox.setSelected((n & 2) == 2);
            } else {
                this.fontNameList.clearSelection();
                this.boldCheckBox.setSelected(false);
                this.italicCheckBox.setSelected(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateing = false;
        this.updateFontDisplay();
    }

    public Font getSelectedFont() {
        String string = (String)this.fontNameList.getSelectedValue();
        if (string == null) {
            return null;
        }
        int n = StringUtil.getIntValue((String)this.fontSizeComboBox.getSelectedItem());
        int n2 = 0;
        if (this.italicCheckBox.isSelected()) {
            n2 |= 2;
        }
        if (this.boldCheckBox.isSelected()) {
            n2 |= 1;
        }
        Font font = new Font(string, n2, n);
        return font;
    }

    public static Font chooseFont(JComponent jComponent, Font font, boolean bl) {
        boolean bl2;
        WbFontChooser wbFontChooser = new WbFontChooser(bl);
        if (font != null) {
            wbFontChooser.setSelectedFont(font);
        }
        Dimension dimension = new Dimension(320, 240);
        wbFontChooser.setSize(dimension);
        wbFontChooser.setPreferredSize(dimension);
        Font font2 = null;
        JDialog jDialog = null;
        Window window = SwingUtilities.getWindowAncestor(jComponent);
        if (window instanceof JDialog) {
            jDialog = (JDialog)window;
        }
        if (bl2 = ValidatingDialog.showOKCancelDialog(jDialog, wbFontChooser, ResourceMgr.getString("TxtWindowTitleChooseFont"))) {
            font2 = wbFontChooser.getSelectedFont();
        }
        return font2;
    }

    private void fillFontList() {
        this.fontFiller = new WbThread("Fill Fontlist"){

            @Override
            public void run() {
                try {
                    WbSwingUtilities.showWaitCursor(WbFontChooser.this);
                    ListModel listModel = WbFontChooser.this.getFontList();
                    WbSwingUtilities.invoke(() -> {
                        WbFontChooser.this.fontNameList.setModel(listModel);
                        if (WbFontChooser.this.toSelect != null) {
                            WbFontChooser.this.setSelectedFont(WbFontChooser.this.toSelect);
                            WbFontChooser.this.toSelect = null;
                        }
                    });
                    WbFontChooser.this.fontFiller = null;
                }
                finally {
                    WbSwingUtilities.showDefaultCursor(WbFontChooser.this);
                }
            }
        };
        this.fontFiller.start();
    }

    private ListModel getFontList() {
        CallerInfo callerInfo = new CallerInfo(){};
        long l = System.currentTimeMillis();
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logInfo(callerInfo, "Retrieving " + stringArray.length + " font names took: " + l2 + "ms");
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        boolean bl = this.monospacedOnly;
        long l6 = Settings.getInstance().getIntProperty("workbench.gui.font.filter.maxduration", 2500);
        ArrayList<String> arrayList = new ArrayList<String>();
        l = System.currentTimeMillis();
        for (String string : stringArray) {
            if (bl) {
                Font font = new Font(string, 0, 12);
                long l7 = System.currentTimeMillis();
                boolean bl2 = font.canDisplay('A');
                l5 += System.currentTimeMillis() - l7;
                if (!bl2) {
                    arrayList.add(string);
                    continue;
                }
                l7 = System.currentTimeMillis();
                FontMetrics fontMetrics = this.getFontMetrics(font);
                l4 += System.currentTimeMillis() - l7;
                l7 = System.currentTimeMillis();
                int n = fontMetrics.charWidth('M');
                int n2 = fontMetrics.charWidth('i');
                l3 += System.currentTimeMillis() - l7;
                if (n2 != n) continue;
                if (System.currentTimeMillis() - l >= l6) {
                    LogMgr.logWarning(callerInfo, "Filtering monospaced fonts took too more than " + l6 + "ms. Aborting test for monspaced fonts");
                    bl = false;
                }
            }
            defaultListModel.addElement(string);
        }
        l2 = System.currentTimeMillis() - l;
        if (this.monospacedOnly) {
            LogMgr.logInfo(callerInfo, "Filtering monospaced fonts took: " + l2 + "ms");
            if (l2 >= 500L || this.monospacedOnly != bl) {
                LogMgr.logInfo(callerInfo, "getFontMetrics() took: " + l4 + "ms, charWidth() took: " + l3 + "ms, canDisplay() took: " + l5 + "ms");
            }
            if (!arrayList.isEmpty()) {
                LogMgr.logDebug(callerInfo, "The following " + arrayList.size() + " fonts were ignored because they can't display plain characters: " + StringUtil.listToString(arrayList, ',', true));
            }
        }
        return defaultListModel;
    }

    private boolean isMonospace(Font font) {
        try {
            FontMetrics fontMetrics = this.sampleLabel.getFontMetrics(font);
            if (!font.canDisplay('A')) {
                return false;
            }
            int n = fontMetrics.charWidth('M');
            int n2 = fontMetrics.charWidth('i');
            return n2 == n;
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFontDisplay() {
        if (!this.updateing) {
            WbFontChooser wbFontChooser = this;
            synchronized (wbFontChooser) {
                this.updateing = true;
                try {
                    Font font = this.getSelectedFont();
                    if (font != null) {
                        this.sampleLabel.setFont(font);
                        this.sampleLabel.setText((String)this.fontNameList.getSelectedValue());
                    } else {
                        this.sampleLabel.setText("");
                    }
                }
                finally {
                    this.updateing = false;
                }
            }
        }
    }

    private void initComponents() {
        this.fontSizeComboBox = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.fontNameList = new JList();
        this.boldCheckBox = new JCheckBox();
        this.italicCheckBox = new JCheckBox();
        this.sampleLabel = new JLabel();
        this.setMinimumSize(new Dimension(320, 240));
        this.setPreferredSize(new Dimension(320, 240));
        this.setLayout(new GridBagLayout());
        this.fontSizeComboBox.setEditable(true);
        this.fontSizeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "36"}));
        this.fontSizeComboBox.setSelectedIndex(4);
        this.fontSizeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                WbFontChooser.this.fontSizeComboBoxupdateFontDisplay(itemEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 0, 1);
        this.add((Component)this.fontSizeComboBox, gridBagConstraints);
        this.fontNameList.setSelectionMode(0);
        this.fontNameList.setVisibleRowCount(12);
        this.fontNameList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                WbFontChooser.this.fontNameListValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.fontNameList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.boldCheckBox.setText(ResourceMgr.getString("LblBold"));
        this.boldCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                WbFontChooser.this.boldCheckBoxupdateFontDisplay(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.boldCheckBox, gridBagConstraints);
        this.italicCheckBox.setText(ResourceMgr.getString("LblItalic"));
        this.italicCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                WbFontChooser.this.italicCheckBoxupdateFontDisplay(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.italicCheckBox, gridBagConstraints);
        this.sampleLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Preview"), BorderFactory.createEmptyBorder(1, 1, 5, 1)));
        this.sampleLabel.setMaximumSize(new Dimension(43, 100));
        this.sampleLabel.setMinimumSize(new Dimension(48, 60));
        this.sampleLabel.setPreferredSize(new Dimension(48, 60));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 25;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.add((Component)this.sampleLabel, gridBagConstraints);
    }

    private void fontNameListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateFontDisplay();
    }

    private void italicCheckBoxupdateFontDisplay(ItemEvent itemEvent) {
        this.updateFontDisplay();
    }

    private void boldCheckBoxupdateFontDisplay(ItemEvent itemEvent) {
        this.updateFontDisplay();
    }

    private void fontSizeComboBoxupdateFontDisplay(ItemEvent itemEvent) {
        this.updateFontDisplay();
    }
}

