/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Color;
import java.awt.Font;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicTextFieldUI;
import workbench.gui.actions.WbAction;
import workbench.gui.components.TextComponentMouseListener;

public class WbLabelField
extends JTextField {
    private TextComponentMouseListener mouseListener;

    public WbLabelField() {
        this.init();
    }

    public WbLabelField(String string) {
        super(string);
        this.init();
    }

    private void init() {
        Color color;
        Color color2;
        this.setUI(new BasicTextFieldUI());
        this.setEditable(false);
        this.setOpaque(false);
        this.mouseListener = new TextComponentMouseListener();
        this.addMouseListener(this.mouseListener);
        this.setBorder(new EmptyBorder(2, 5, 2, 2));
        Font font = UIManager.getFont("Label.font");
        if (font != null) {
            this.setFont(font);
        }
        if ((color2 = UIManager.getColor("Label.background")) != null) {
            this.setBackground(color2);
        }
        if ((color = UIManager.getColor("Label.foreground")) != null) {
            this.setForeground(color);
        }
    }

    @Override
    public void setText(String string) {
        if (this.getFont() == null) {
            return;
        }
        if (this.getFontMetrics(this.getFont()) == null) {
            return;
        }
        super.setText(string);
        this.setCaretPosition(0);
    }

    public void useBoldFont() {
        Font font = this.getFont();
        if (font == null) {
            return;
        }
        Font font2 = font.deriveFont(1);
        this.setFont(font2);
    }

    public void addPopupAction(WbAction wbAction) {
        this.mouseListener.addAction(wbAction);
    }

    public void dispose() {
        if (this.mouseListener != null) {
            this.mouseListener.dispose();
        }
    }
}

