/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.GenericRowMonitor;
import workbench.interfaces.StatusBar;
import workbench.resource.IconMgr;
import workbench.storage.RowActionMonitor;

public class WbStatusLabel
extends JLabel
implements StatusBar {
    private static final Border DEFAULT_BORDER = new EmptyBorder(1, 1, 0, 1);

    public WbStatusLabel(String string) {
        super(string);
        this.setBorder(DEFAULT_BORDER);
        this.initSize();
    }

    public WbStatusLabel() {
        this(DEFAULT_BORDER);
    }

    public WbStatusLabel(Border border) {
        this.setBorder(border);
        this.initSize();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.initSize();
    }

    private void initSize() {
        int n;
        int n2;
        Font font = this.getFont();
        FontMetrics fontMetrics = null;
        if (font != null) {
            fontMetrics = this.getFontMetrics(font);
        }
        int n3 = 6;
        if (fontMetrics != null) {
            n2 = (int)((double)fontMetrics.getHeight() * 1.2) + n3;
            n = fontMetrics.charWidth('W');
            n2 = Math.max(22, n2);
            n *= 10;
        } else {
            int n4;
            n = n4 = (int)((double)IconMgr.getInstance().getSizeForLabel() * 1.2) + n3;
            n2 = n4;
        }
        Dimension dimension = new Dimension(n, n2);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
    }

    public RowActionMonitor getMonitor() {
        return new GenericRowMonitor(this);
    }

    @Override
    public void setStatusMessage(String string, int n) {
        this.setStatusMessage(string);
    }

    @Override
    public void doRepaint() {
        this.repaint();
    }

    @Override
    public void setStatusMessage(String string) {
        WbSwingUtilities.invoke(() -> this.setText(string));
    }

    @Override
    public void clearStatusMessage() {
        WbSwingUtilities.invoke(() -> this.setText(""));
    }
}

