/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import workbench.gui.actions.WbAction;
import workbench.gui.components.DividerBorder;
import workbench.gui.components.WbToolbarButton;
import workbench.gui.components.WbToolbarSeparator;
import workbench.gui.lnf.LnFHelper;

public class WbToolbar
extends JToolBar {
    public WbToolbar() {
        this.setFloatable(false);
        this.setRollover(true);
        this.putClientProperty("Synthetica.opaque", Boolean.FALSE);
    }

    @Override
    public JButton add(Action action) {
        JButton jButton = action instanceof WbAction ? ((WbAction)action).getToolbarButton() : new WbToolbarButton(action);
        this.add(jButton);
        jButton.setRolloverEnabled(true);
        return jButton;
    }

    public JButton add(WbAction wbAction) {
        return this.add(wbAction, -1);
    }

    public JButton add(WbAction wbAction, int n) {
        JButton jButton = wbAction.getToolbarButton();
        jButton.setRolloverEnabled(true);
        this.add((Component)jButton, n);
        return jButton;
    }

    @Override
    public void addSeparator() {
        this.addSeparator(-1);
    }

    public void addSeparator(int n) {
        this.add((Component)this.createSeparator(), n);
    }

    private JComponent createSeparator() {
        if (LnFHelper.isWebLaf()) {
            try {
                Class<?> clazz = Class.forName("com.alee.laf.toolbar.WebToolBarSeparator");
                return (JComponent)clazz.newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new WbToolbarSeparator();
    }

    public void addDefaultBorder() {
        CompoundBorder compoundBorder = new CompoundBorder(new EmptyBorder(1, 0, 1, 0), BorderFactory.createEtchedBorder());
        this.setBorder(compoundBorder);
        this.setBorderPainted(true);
        this.setRollover(true);
    }

    public void addSimpleBorder() {
        this.setBorder(new DividerBorder(12, true));
        this.setBorderPainted(true);
        this.setRollover(true);
    }

    public void removeAction(WbAction wbAction) {
        if (wbAction == null) {
            return;
        }
        int n = -1;
        int n2 = this.getComponentCount();
        for (int i = 0; i < n2; ++i) {
            Action action;
            Component component = this.getComponentAtIndex(i);
            if (!(component instanceof AbstractButton) || (action = ((AbstractButton)component).getAction()) != wbAction) continue;
            n = i;
            break;
        }
        this.invalidate();
        this.remove(n);
        this.revalidate();
    }
}

