/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.ArrayList;
import java.util.List;

public class WbTraversalPolicy
extends FocusTraversalPolicy {
    private final List<Component> components = new ArrayList<Component>();
    private Component defaultComponent = null;

    public void setDefaultComponent(Component component) {
        this.defaultComponent = component;
    }

    public void addComponent(Component component) {
        if (!this.components.contains(component)) {
            this.components.add(component);
        }
    }

    private boolean checkAvailable() {
        for (Component component : this.components) {
            if (!component.isEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Component getComponentAfter(Container container, Component component) {
        if (!this.checkAvailable()) {
            return null;
        }
        Component component2 = null;
        int n = this.components.indexOf(component);
        component2 = n < 0 || n == this.components.size() - 1 ? this.components.get(0) : this.components.get(n + 1);
        if (component2.isEnabled()) {
            return component2;
        }
        return this.getComponentAfter(container, component2);
    }

    @Override
    public Component getComponentBefore(Container container, Component component) {
        if (!this.checkAvailable()) {
            return null;
        }
        Component component2 = null;
        int n = this.components.indexOf(component);
        component2 = n <= 0 ? this.components.get(this.components.size() - 1) : this.components.get(n - 1);
        if (component2.isEnabled()) {
            return component2;
        }
        return this.getComponentBefore(container, component2);
    }

    @Override
    public Component getDefaultComponent(Container container) {
        if (this.defaultComponent != null) {
            return this.defaultComponent;
        }
        if (this.components.size() > 0) {
            return this.components.get(0);
        }
        return null;
    }

    @Override
    public Component getFirstComponent(Container container) {
        if (this.components.size() > 0) {
            return this.components.get(0);
        }
        return null;
    }

    @Override
    public Component getLastComponent(Container container) {
        if (this.components.size() > 0) {
            return this.components.get(this.components.size() - 1);
        }
        return null;
    }
}

