/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JPopupMenu;
import javax.swing.table.TableModel;
import workbench.db.ColumnIdentifier;
import workbench.gui.actions.CheckBoxAction;
import workbench.gui.actions.ResetColOrderAction;
import workbench.gui.components.ColumnOrderMgr;
import workbench.gui.components.WbTable;
import workbench.gui.renderer.RendererSetup;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;

public class DbObjectTable
extends WbTable {
    private boolean rememberColumnOrder;
    private List<String> columnOrder;
    private List<String> originalColumnOrder;
    private List<String> pendingOrder;
    private String saveSortProperty;

    public DbObjectTable() {
        this((String)null);
    }

    public DbObjectTable(String string) {
        super(true, false, false);
        this.setAutoResizeMode(0);
        this.setCellSelectionEnabled(false);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.getSelectionModel().setSelectionMode(0);
        this.setRendererSetup(RendererSetup.getBaseSetup());
        this.saveSortProperty = string;
    }

    public void setRememberColumnOrder(boolean bl) {
        this.rememberColumnOrder = bl;
    }

    public boolean getRememberColumnOrder() {
        return this.rememberColumnOrder;
    }

    @Override
    protected JPopupMenu getHeaderPopup() {
        JPopupMenu jPopupMenu = super.getHeaderPopup();
        if (this.saveSortProperty != null) {
            int n = jPopupMenu.getComponentCount();
            CheckBoxAction checkBoxAction = new CheckBoxAction("MnuTxtRememberSort", this.saveSortProperty);
            jPopupMenu.insert(checkBoxAction.getMenuItem(), n - 1);
        }
        if (this.isColumnOrderChanged() && this.originalColumnOrder != null) {
            ResetColOrderAction resetColOrderAction = new ResetColOrderAction(null){

                @Override
                public void executeAction(ActionEvent actionEvent) {
                    ColumnOrderMgr.getInstance().applyColumnOrder(DbObjectTable.this, DbObjectTable.this.originalColumnOrder, false);
                }

                @Override
                public boolean isEnabled() {
                    return true;
                }
            };
            jPopupMenu.addSeparator();
            jPopupMenu.add(resetColOrderAction);
        }
        return jPopupMenu;
    }

    public void setOriginalOrder(DataStore dataStore) {
        ColumnIdentifier[] columnIdentifierArray = dataStore.getColumns();
        this.originalColumnOrder = new ArrayList<String>(columnIdentifierArray.length);
        for (ColumnIdentifier columnIdentifier : columnIdentifierArray) {
            this.originalColumnOrder.add(columnIdentifier.getColumnName());
        }
    }

    public void setNewColumnOrder(List<String> list) {
        this.pendingOrder = CollectionUtil.isEmpty(list) ? null : new ArrayList<String>(list);
    }

    public List<String> saveColumnOrder() {
        if (this.rememberColumnOrder) {
            this.columnOrder = ColumnOrderMgr.getInstance().getColumnOrder(this);
            return new ArrayList<String>(this.columnOrder);
        }
        return null;
    }

    public void restoreSavedColumnOrder() {
        if (this.pendingOrder != null) {
            if (this.canApplyColumnOrder(this.pendingOrder)) {
                ColumnOrderMgr.getInstance().applyColumnOrder(this, this.pendingOrder, true);
            }
            this.pendingOrder = null;
        } else if (this.canApplyColumnOrder(this.columnOrder)) {
            ColumnOrderMgr.getInstance().applyColumnOrder(this, this.columnOrder, true);
        }
    }

    private boolean canApplyColumnOrder(List<String> list) {
        if (CollectionUtil.isEmpty(list)) {
            return false;
        }
        if (this.getColumnCount() == 0) {
            return false;
        }
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            set.add(this.getColumnName(i));
        }
        Set<String> set2 = CollectionUtil.caseInsensitiveSet();
        set2.addAll(list);
        return set.containsAll(set2);
    }

    @Override
    public void setModel(TableModel tableModel, boolean bl) {
        super.setModel(tableModel, bl);
        this.restoreSavedColumnOrder();
    }
}

