/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import workbench.db.DependencyNode;
import workbench.db.TableDependency;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.DropForeignKeyAction;
import workbench.gui.actions.ReloadAction;
import workbench.gui.actions.StopAction;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.WbScrollPane;
import workbench.gui.components.WbSplitPane;
import workbench.gui.components.WbTable;
import workbench.gui.components.WbToolbar;
import workbench.gui.dbobjects.TableDependencyTreeDisplay;
import workbench.gui.dbobjects.TableLister;
import workbench.gui.renderer.RendererSetup;
import workbench.interfaces.Interruptable;
import workbench.interfaces.Reloadable;
import workbench.interfaces.Resettable;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.DbExplorerSettings;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.storage.DataStore;
import workbench.util.WbThread;

public class FkDisplayPanel
extends JPanel
implements Resettable,
Reloadable,
Interruptable,
ActionListener,
ListSelectionListener {
    protected WbTable keys = new WbTable();
    private final TableDependencyTreeDisplay dependencyTree;
    private final WbSplitPane splitPanel;
    private final ReloadAction reloadTree;
    private final StopAction cancelAction;
    private final JCheckBox retrieveAll;
    private final boolean showImportedKeys;
    private WbConnection dbConnection;
    private boolean isRetrieving;
    private boolean isTreeRetrieving;
    private TableIdentifier currentTable;
    private final JMenuItem selectTableItem;
    private DropForeignKeyAction dropFK;
    private final TableLister tables;

    public FkDisplayPanel(TableLister tableLister, boolean bl) {
        super(new BorderLayout());
        this.keys.setAdjustToColumnLabel(false);
        this.keys.setRendererSetup(RendererSetup.getBaseSetup());
        this.keys.getSelectionModel().addListSelectionListener(this);
        WbScrollPane wbScrollPane = new WbScrollPane(this.keys);
        this.splitPanel = new WbSplitPane(0);
        this.splitPanel.setDividerLocation(100);
        this.splitPanel.setDividerSize(IconMgr.getInstance().getSizeForLabel() / 2);
        this.splitPanel.setDividerBorder(WbSwingUtilities.EMPTY_BORDER);
        this.splitPanel.setTopComponent(wbScrollPane);
        this.tables = tableLister;
        this.dependencyTree = new TableDependencyTreeDisplay(tableLister);
        this.dependencyTree.reset();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.dependencyTree, "Center");
        WbToolbar wbToolbar = new WbToolbar();
        wbToolbar.setBorder(new EtchedBorder(1));
        this.reloadTree = new ReloadAction(this);
        this.cancelAction = new StopAction(this);
        this.cancelAction.setEnabled(false);
        wbToolbar.add(this.reloadTree);
        wbToolbar.add(this.cancelAction);
        wbToolbar.addSeparator();
        jPanel.add((Component)wbToolbar, "North");
        this.splitPanel.setBottomComponent(jPanel);
        this.add((Component)this.splitPanel, "Center");
        this.showImportedKeys = bl;
        this.retrieveAll = new JCheckBox(ResourceMgr.getString("LblRefAllLevel"));
        this.retrieveAll.setToolTipText(ResourceMgr.getDescription("LblRefAllLevel"));
        this.retrieveAll.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.retrieveAll.setSelected(true);
        wbToolbar.add(this.retrieveAll);
        this.selectTableItem = new JMenuItem(ResourceMgr.getString("MnuTextSelectInList"));
        this.selectTableItem.addActionListener(this);
        this.selectTableItem.setEnabled(false);
        this.dropFK = new DropForeignKeyAction(this);
        this.dropFK.setEnabled(false);
        this.keys.addPopupAction(this.dropFK, true);
        this.keys.addPopupMenu(this.selectTableItem, false);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl = this.keys.getSelectedRowCount() > 0;
        this.dropFK.setEnabled(bl);
        this.selectTableItem.setEnabled(bl);
    }

    public boolean getRetrieveAll() {
        return this.retrieveAll.isSelected();
    }

    public void setRetrieveAll(boolean bl) {
        this.retrieveAll.setSelected(bl);
    }

    public void setConnection(WbConnection wbConnection) {
        this.dbConnection = wbConnection;
        this.dependencyTree.setConnection(wbConnection);
    }

    public int getDividerLocation() {
        return this.splitPanel.getDividerLocation();
    }

    public void setDividerLocation(int n) {
        this.splitPanel.setDividerLocation(n);
    }

    public TableDependencyTreeDisplay getTree() {
        return this.dependencyTree;
    }

    public WbTable getKeyDisplay() {
        return this.keys;
    }

    public TableIdentifier getCurrentTable() {
        return this.currentTable;
    }

    public WbConnection getConnection() {
        return this.dbConnection;
    }

    public Map<TableIdentifier, String> getSelectedForeignKeys() {
        int[] nArray = this.keys.getSelectedRows();
        DataStore dataStore = this.keys.getDataStore();
        HashMap<TableIdentifier, String> hashMap = new HashMap<TableIdentifier, String>();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            DependencyNode dependencyNode = (DependencyNode)dataStore.getRow(n).getUserObject();
            String string = dependencyNode.getFkName();
            TableIdentifier tableIdentifier = null;
            tableIdentifier = this.showImportedKeys ? this.currentTable : dependencyNode.getTable();
            if (tableIdentifier == null) continue;
            hashMap.put(tableIdentifier, string);
        }
        return hashMap;
    }

    @Override
    public void reset() {
        this.keys.reset();
        this.dependencyTree.reset();
    }

    public boolean isRetrieving() {
        return this.isRetrieving || this.isTreeRetrieving;
    }

    public void cancel() {
        this.dependencyTree.cancelRetrieve();
    }

    public void reloadTable() {
        try {
            this.reset();
            this.retrieve(this.currentTable);
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not reload constraints", sQLException);
        }
    }

    protected void retrieve(TableIdentifier tableIdentifier) throws SQLException {
        try {
            this.currentTable = tableIdentifier;
            this.isRetrieving = true;
            DataStoreTableModel dataStoreTableModel = new DataStoreTableModel(this.getFKDataStore(tableIdentifier));
            WbSwingUtilities.invoke(() -> {
                this.keys.setModel(dataStoreTableModel, true);
                this.keys.adjustRowsAndColumns();
                this.dependencyTree.reset();
            });
            if (DbExplorerSettings.getAutoRetrieveFKTree()) {
                this.reload();
            }
        }
        finally {
            this.isRetrieving = false;
        }
    }

    private DataStore getFKDataStore(TableIdentifier tableIdentifier) {
        TableDependency tableDependency = new TableDependency(this.dbConnection, tableIdentifier);
        return tableDependency.getDisplayDataStore(this.showImportedKeys);
    }

    protected void retrieveTree(TableIdentifier tableIdentifier) {
        this.dependencyTree.setRetrieveAll(this.retrieveAll.isSelected());
        if (this.showImportedKeys) {
            this.dependencyTree.readReferencedTables(tableIdentifier);
        } else {
            this.dependencyTree.readReferencingTables(tableIdentifier);
        }
    }

    @Override
    public void reload() {
        WbThread wbThread = new WbThread("DependencyTreeRetriever"){

            @Override
            public void run() {
                try {
                    FkDisplayPanel.this.isTreeRetrieving = true;
                    FkDisplayPanel.this.retrieveTree(FkDisplayPanel.this.currentTable);
                }
                finally {
                    FkDisplayPanel.this.isTreeRetrieving = false;
                    FkDisplayPanel.this.reloadTree.setEnabled(true);
                    FkDisplayPanel.this.cancelAction.setEnabled(false);
                    WbSwingUtilities.showDefaultCursor(FkDisplayPanel.this);
                }
            }
        };
        this.reloadTree.setEnabled(false);
        this.cancelAction.setEnabled(true);
        WbSwingUtilities.showWaitCursor(this);
        wbThread.start();
    }

    @Override
    public void cancelExecution() {
        if (this.isTreeRetrieving) {
            this.dependencyTree.cancelRetrieve();
            this.cancelAction.setEnabled(false);
        }
    }

    @Override
    public boolean confirmCancel() {
        return true;
    }

    private TableIdentifier getReferencedTable(int n) {
        if (n < 0) {
            return null;
        }
        DataStore dataStore = this.keys.getDataStore();
        DependencyNode dependencyNode = (DependencyNode)dataStore.getRow(n).getUserObject();
        return dependencyNode.getTable();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.tables == null) {
            return;
        }
        if (actionEvent.getSource() != this.selectTableItem) {
            return;
        }
        int n = this.keys.getSelectedRow();
        if (n < 0) {
            return;
        }
        TableIdentifier tableIdentifier = this.getReferencedTable(n);
        if (tableIdentifier == null) {
            return;
        }
        LogMgr.logDebug(new CallerInfo(){}, "Trying to select table: " + tableIdentifier.getTableName());
        WbSwingUtilities.invokeLater(() -> this.tables.selectTable(tableIdentifier));
    }
}

