/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import workbench.WbManager;
import workbench.db.ColumnIdentifier;
import workbench.db.DbSettings;
import workbench.db.JdbcUtils;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.TableSelectBuilder;
import workbench.db.WbConnection;
import workbench.gui.MainWindow;
import workbench.gui.PanelReloader;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.FilterPickerAction;
import workbench.gui.actions.ReloadAction;
import workbench.gui.actions.SelectionFilterAction;
import workbench.gui.actions.StopAction;
import workbench.gui.actions.WbAction;
import workbench.gui.components.ColumnOrderMgr;
import workbench.gui.components.FlatButton;
import workbench.gui.components.WbButton;
import workbench.gui.components.WbLabelField;
import workbench.gui.components.WbTable;
import workbench.gui.components.WbToolbar;
import workbench.gui.components.WbTraversalPolicy;
import workbench.gui.dbobjects.ExplorerUtils;
import workbench.gui.dbobjects.TableDataSettings;
import workbench.gui.sql.AutomaticRefreshMgr;
import workbench.gui.sql.DwPanel;
import workbench.interfaces.DbExecutionListener;
import workbench.interfaces.DbExecutionNotifier;
import workbench.interfaces.Interruptable;
import workbench.interfaces.JobErrorHandler;
import workbench.interfaces.PropertyStorage;
import workbench.interfaces.Reloadable;
import workbench.interfaces.Resettable;
import workbench.interfaces.TableDeleteListener;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.DbExplorerSettings;
import workbench.resource.GuiSettings;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.EndReadOnlyTrans;
import workbench.storage.DataStore;
import workbench.storage.NamedSortDefinition;
import workbench.storage.ResultColumnMetaData;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.FilteredProperties;
import workbench.util.LowMemoryException;
import workbench.util.WbThread;
import workbench.util.WbWorkspace;

public class TableDataPanel
extends JPanel
implements ActionListener,
Reloadable,
Interruptable,
TableDeleteListener,
Resettable,
DbExecutionNotifier,
PanelReloader {
    private WbConnection dbConnection;
    protected DwPanel dataDisplay;
    private ReloadAction reloadAction;
    private FlatButton config;
    private WbLabelField tableNameLabel;
    private JLabel rowCountLabel;
    private WbButton rowCountButton;
    private JCheckBox autoRetrieve;
    private JPanel topPanel;
    private int warningThreshold = -1;
    private boolean retrieveRunning;
    private boolean updateRunning;
    private boolean autoloadRowCount = true;
    private TableIdentifier table;
    private TableDefinition tableDefinition;
    protected StopAction cancelRetrieve;
    private List<DbExecutionListener> execListener;
    private Savepoint currentSavepoint;
    private Statement rowCountRetrieveStmt;
    private NamedSortDefinition lastSort;
    private WbToolbar toolbar;
    private boolean initialized;
    private boolean useDataStoreSource;
    private boolean showRefreshButton;
    private WbButton enableRefreshButton;
    private FilteredProperties workspaceSettings;
    private AutomaticRefreshMgr refreshMgr = new AutomaticRefreshMgr();
    private List<JButton> additionalButtons;
    private boolean rowCountCancel = false;

    public TableDataPanel() {
        this.setName("tabledata");
    }

    private void initGui() {
        if (this.initialized) {
            return;
        }
        WbSwingUtilities.invoke(this::_initGui);
    }

    private void _initGui() {
        if (this.initialized) {
            return;
        }
        this.setBorder(WbSwingUtilities.EMPTY_BORDER);
        this.setLayout(new BorderLayout());
        this.dataDisplay = new DwPanel(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized int saveChanges(WbConnection wbConnection, JobErrorHandler jobErrorHandler) throws SQLException {
                int n = -1;
                try {
                    TableDataPanel.this.dbUpdateStart();
                    n = super.saveChanges(wbConnection, jobErrorHandler);
                }
                finally {
                    TableDataPanel.this.dbUpdateEnd();
                }
                return n;
            }
        };
        this.dataDisplay.showCreateDeleteScript();
        this.dataDisplay.setShowLoadProcess(true);
        this.dataDisplay.setDefaultStatusMessage("");
        this.createToolbar();
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        this.topPanel.add((Component)this.toolbar, gridBagConstraints);
        int n = IconMgr.getInstance().getToolbarIconSize();
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, n, 0, 0);
        JLabel jLabel = new JLabel(ResourceMgr.getString("LblTable") + ":");
        this.topPanel.add((Component)jLabel, gridBagConstraints);
        Font font = jLabel.getFont();
        Font font2 = font.deriveFont(1);
        this.tableNameLabel = new WbLabelField();
        this.tableNameLabel.setFont(font2);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 1, 0, 0);
        this.topPanel.add((Component)this.tableNameLabel, gridBagConstraints);
        this.rowCountButton = new WbButton();
        this.rowCountButton.setResourceKey("LblTableDataRowCount");
        this.rowCountButton.enableBasicRollover();
        this.rowCountButton.addActionListener(this);
        this.rowCountButton.setToolTipText(ResourceMgr.getDescription("LblTableDataRowCountButton"));
        this.rowCountButton.setFocusable(false);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, n / 2, 0, 0);
        this.topPanel.add((Component)this.rowCountButton, gridBagConstraints);
        this.rowCountLabel = new JLabel();
        this.rowCountLabel.setFont(font2);
        this.rowCountLabel.setHorizontalTextPosition(2);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, n / 4, 0, 0);
        this.topPanel.add((Component)this.rowCountLabel, gridBagConstraints);
        this.autoRetrieve = new JCheckBox(ResourceMgr.getString("LblAutoLoad"));
        this.autoRetrieve.setToolTipText(ResourceMgr.getDescription("LblAutoLoadTableData"));
        this.autoRetrieve.setHorizontalTextPosition(2);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, n, 0, 0);
        this.topPanel.add((Component)this.autoRetrieve, gridBagConstraints);
        this.config = new FlatButton(ResourceMgr.getString("LblConfigureWarningThreshold"));
        this.config.setToolTipText(ResourceMgr.getDescription("LblConfigureWarningThreshold"));
        this.config.addActionListener(this);
        this.config.setUseDefaultMargin(true);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 22;
        this.topPanel.add((Component)this.config, gridBagConstraints);
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.dataDisplay, "Center");
        WbTraversalPolicy wbTraversalPolicy = new WbTraversalPolicy();
        wbTraversalPolicy.addComponent(this.dataDisplay);
        wbTraversalPolicy.setDefaultComponent(this.dataDisplay);
        this.setFocusCycleRoot(false);
        this.setFocusTraversalPolicy(wbTraversalPolicy);
        this.dataDisplay.getTable().setColumnOrderSavingEnabled(true);
        if (DbExplorerSettings.showFocusInDbExplorer()) {
            this.dataDisplay.getTable().showFocusBorder();
        }
        this.restoreSettings();
        if (this.workspaceSettings != null) {
            this.readSettings(this.workspaceSettings.getFilterPrefix(), this.workspaceSettings);
            this.workspaceSettings = null;
        }
        this.dataDisplay.setConnection(this.dbConnection);
        this.initialized = true;
    }

    public void addButtons(JButton ... jButtonArray) {
        if (jButtonArray == null) {
            this.additionalButtons = null;
        } else {
            this.additionalButtons = new ArrayList<JButton>(jButtonArray.length);
            for (JButton jButton : jButtonArray) {
                if (jButton == null) continue;
                this.additionalButtons.add(jButton);
            }
        }
    }

    public void showRefreshButton(boolean bl) {
        this.showRefreshButton = bl;
    }

    public void refreshAutomatically(int n) {
        if (n <= 0) {
            return;
        }
        this.refreshMgr.addRefresh(this, this.dataDisplay, n);
        this.checkRefreshButton();
    }

    private void createToolbar() {
        this.toolbar = new WbToolbar();
        this.toolbar.addDefaultBorder();
        this.reloadAction = new ReloadAction(this);
        this.reloadAction.setTooltip(ResourceMgr.getDescription("TxtLoadTableData", true));
        this.reloadAction.addToInputMap(this.dataDisplay.getTable());
        this.toolbar.add(this.reloadAction);
        this.toolbar.addSeparator();
        this.cancelRetrieve = new StopAction(this);
        this.cancelRetrieve.setEnabled(false);
        this.toolbar.add(this.cancelRetrieve);
        this.toolbar.addSeparator();
        this.toolbar.add(this.dataDisplay.getUpdateDatabaseAction());
        this.toolbar.add(this.dataDisplay.getSelectKeysAction());
        this.toolbar.addSeparator();
        this.toolbar.add(this.dataDisplay.getInsertRowAction());
        this.toolbar.add(this.dataDisplay.getCopyRowAction());
        this.toolbar.add(this.dataDisplay.getDeleteRowAction());
        this.toolbar.addSeparator();
        SelectionFilterAction selectionFilterAction = new SelectionFilterAction();
        selectionFilterAction.setClient(this.dataDisplay.getTable());
        this.toolbar.add(selectionFilterAction);
        this.toolbar.addSeparator();
        this.toolbar.add(this.dataDisplay.getTable().getFilterAction());
        FilterPickerAction filterPickerAction = new FilterPickerAction(this.dataDisplay.getTable());
        this.toolbar.add(filterPickerAction);
        this.toolbar.addSeparator();
        this.toolbar.add(this.dataDisplay.getTable().getResetFilterAction());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.initTableNavigation();
    }

    public DwPanel getPanel() {
        return this.dataDisplay;
    }

    public WbTable getData() {
        return this.dataDisplay.getTable();
    }

    public boolean isModified() {
        if (this.dataDisplay == null) {
            return false;
        }
        return this.dataDisplay.isModified();
    }

    private void initTableNavigation() {
        if (this.dataDisplay == null) {
            return;
        }
        try {
            MainWindow mainWindow = (MainWindow)SwingUtilities.getWindowAncestor(this);
            this.dataDisplay.initTableNavigation(mainWindow);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ImageIcon getLoadingIndicator() {
        return IconMgr.getInstance().getLabelIcon("wait");
    }

    public void dispose() {
        if (!this.initialized) {
            return;
        }
        this.reset();
        if (this.dataDisplay != null) {
            this.dataDisplay.dispose();
        }
        WbAction.dispose(this.reloadAction, this.cancelRetrieve);
        WbSwingUtilities.removeAllListeners(this);
        CollectionUtil.clear(this.execListener);
    }

    public void detachConnection() {
        this.dbConnection = null;
        if (this.dataDisplay != null) {
            this.dataDisplay.detachConnection();
            this.dataDisplay.disableUpdateActions();
        }
        this.reloadAction.setEnabled(false);
        this.cancelRetrieve.setEnabled(false);
        CollectionUtil.clear(this.execListener);
    }

    public void disconnect() {
        this.dbConnection = null;
        this.reset();
    }

    private void storeSort() {
        this.lastSort = DbExplorerSettings.getRememberSortInDbExplorer() ? this.dataDisplay.getCurrentSort() : null;
    }

    @Override
    public void reset() {
        if (!this.initialized) {
            return;
        }
        if (this.isRetrieving()) {
            return;
        }
        this.storeSort();
        this.storeColumnOrder();
        this.refreshMgr.clear();
        WbSwingUtilities.invoke(() -> {
            if (this.dataDisplay != null) {
                this.dataDisplay.clearContent();
            }
            if (this.rowCountLabel != null) {
                this.rowCountLabel.setText(ResourceMgr.getString("LblNotAvailable"));
            }
            this.clearLoadingImage();
            this.reloadAction.setEnabled(true);
        });
    }

    public void setConnection(WbConnection wbConnection) {
        this.dbConnection = wbConnection;
        if (this.initialized) {
            try {
                this.dataDisplay.setConnection(wbConnection);
            }
            catch (Throwable throwable) {
                LogMgr.logError(new CallerInfo(){}, "Error when setting connection", throwable);
            }
        }
    }

    private void startRetrieveRowCount() {
        if (this.dbConnection == null) {
            return;
        }
        WbThread wbThread = null;
        wbThread = this.rowCountRetrieveStmt != null ? new WbThread("RowCount cancel"){

            @Override
            public void run() {
                TableDataPanel.this.cancelRowCountRetrieve();
            }
        } : new WbThread("RowCount Retrieve"){

            @Override
            public void run() {
                TableDataPanel.this.showRowCount();
            }
        };
        wbThread.start();
    }

    private void setSavepoint() {
        if (this.dbConnection == null) {
            return;
        }
        DbSettings dbSettings = this.dbConnection.getDbSettings();
        if (dbSettings == null) {
            return;
        }
        if (!ExplorerUtils.isOwnTransaction(this.dbConnection) && dbSettings.useSavePointForDML() && dbSettings.getAutoCloseReadOnlyTransactions() == EndReadOnlyTrans.never) {
            try {
                this.currentSavepoint = this.dbConnection.setSavepoint();
            }
            catch (SQLException sQLException) {
                this.currentSavepoint = null;
            }
            catch (Exception exception) {
                LogMgr.logDebug(new CallerInfo(){}, "Error setting savepoint", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long showRowCount() {
        if (this.rowCountLabel == null) {
            return -1L;
        }
        if (this.dbConnection == null) {
            return -1L;
        }
        if (this.isRetrieving()) {
            return -1L;
        }
        this.initGui();
        WbSwingUtilities.invoke(() -> {
            this.rowCountLabel.setText("");
            this.rowCountLabel.setIcon(this.getLoadingIndicator());
            this.reloadAction.setEnabled(false);
            this.dataDisplay.setStatusMessage(ResourceMgr.getFormattedString("MsgCalculatingTableRows", this.table.getTableName()));
        });
        String string = this.buildSqlForRowCount();
        if (string == null) {
            return -1L;
        }
        long l = 0L;
        ResultSet resultSet = null;
        boolean bl = false;
        try {
            this.setSavepoint();
            this.retrieveStart();
            this.rowCountButton.setToolTipText(ResourceMgr.getDescription("LblTableDataRowCountCancel"));
            this.rowCountRetrieveStmt = this.dbConnection.createStatementForQuery();
            LogMgr.logDebug(new CallerInfo(){}, "Retrieving row count using:\n" + string);
            resultSet = this.rowCountRetrieveStmt.executeQuery(string);
            if (resultSet.next()) {
                l = resultSet.getLong(1);
            }
            this.rowCountLabel.setText(Long.toString(l));
            this.rowCountLabel.setToolTipText(null);
        }
        catch (Exception exception) {
            try {
                WbSwingUtilities.showDefaultCursor(this);
                l = -1L;
                bl = true;
                String string2 = ExceptionUtil.getDisplay(exception);
                LogMgr.logError(new CallerInfo(){}, "Error retrieving rowcount for " + this.table.getTableExpression(this.dbConnection) + " using\n " + string, exception);
                if (this.rowCountCancel) {
                    WbSwingUtilities.setLabel(this.rowCountLabel, ResourceMgr.getString("LblNotAvailable"), null);
                } else {
                    WbSwingUtilities.setLabel(this.rowCountLabel, ResourceMgr.getString("TxtError"), string2);
                }
                String string3 = ResourceMgr.getString("TxtErrorRowCount");
                WbSwingUtilities.showFriendlyErrorMessage(SwingUtilities.getWindowAncestor(this), string3, string2);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, this.rowCountRetrieveStmt);
                this.rowCountCancel = false;
                WbSwingUtilities.invoke(() -> {
                    this.dataDisplay.setStatusMessage("");
                    this.clearLoadingImage();
                    this.reloadAction.setEnabled(true);
                    this.rowCountButton.setToolTipText(ResourceMgr.getDescription("LblTableDataRowCountButton"));
                });
                if (bl) {
                    this.rollbackIfNeeded();
                } else {
                    this.commitRetrieveIfNeeded();
                }
                this.retrieveEnd();
                this.rowCountRetrieveStmt = null;
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, this.rowCountRetrieveStmt);
            this.rowCountCancel = false;
            WbSwingUtilities.invoke(() -> {
                this.dataDisplay.setStatusMessage("");
                this.clearLoadingImage();
                this.reloadAction.setEnabled(true);
                this.rowCountButton.setToolTipText(ResourceMgr.getDescription("LblTableDataRowCountButton"));
            });
            if (bl) {
                this.rollbackIfNeeded();
            } else {
                this.commitRetrieveIfNeeded();
            }
            this.retrieveEnd();
            this.rowCountRetrieveStmt = null;
        }
        JdbcUtils.closeAll(resultSet, this.rowCountRetrieveStmt);
        this.rowCountCancel = false;
        WbSwingUtilities.invoke(() -> {
            this.dataDisplay.setStatusMessage("");
            this.clearLoadingImage();
            this.reloadAction.setEnabled(true);
            this.rowCountButton.setToolTipText(ResourceMgr.getDescription("LblTableDataRowCountButton"));
        });
        if (bl) {
            this.rollbackIfNeeded();
        } else {
            this.commitRetrieveIfNeeded();
        }
        this.retrieveEnd();
        this.rowCountRetrieveStmt = null;
        return l;
    }

    protected void cancelRowCountRetrieve() {
        if (this.rowCountRetrieveStmt != null) {
            try {
                this.dataDisplay.setStatusMessage(ResourceMgr.getString("MsgCancelRowCount"));
                this.rowCountCancel = true;
                this.rowCountRetrieveStmt.cancel();
            }
            catch (Throwable throwable) {
                LogMgr.logError(new CallerInfo(){}, "Error when cancelling row count retrieve", throwable);
            }
        }
    }

    public void storeColumnOrder() {
        if (!DbExplorerSettings.getRememberColumnOrder()) {
            return;
        }
        this.saveColumnOrder();
    }

    public void saveColumnOrder() {
        if (this.dataDisplay == null) {
            return;
        }
        WbTable wbTable = this.dataDisplay.getTable();
        if (wbTable == null) {
            return;
        }
        if (wbTable.isColumnOrderChanged()) {
            ColumnOrderMgr.getInstance().storeColumnOrder(wbTable);
        }
    }

    public void setTable(TableIdentifier tableIdentifier) {
        this.initGui();
        if (!this.isRetrieving()) {
            this.reset();
        }
        this.table = tableIdentifier;
        this.tableDefinition = null;
        this.lastSort = null;
        WbSwingUtilities.invoke(() -> {
            this.dataDisplay.getTable().clearLastFilter(true);
            this.dataDisplay.getTable().resetFilter();
            if (DbExplorerSettings.getDbExplorerTableDetailFullyQualified()) {
                this.tableNameLabel.setText(this.table.getFullyQualifiedName(this.dbConnection));
            } else {
                this.tableNameLabel.setText(this.table.getTableExpression(this.dbConnection));
            }
        });
    }

    private String buildSqlForRowCount() {
        if (this.table == null) {
            return null;
        }
        TableSelectBuilder tableSelectBuilder = new TableSelectBuilder(this.dbConnection, "tablerowcount", "tabledata");
        String string = tableSelectBuilder.getSelectForCount(this.table);
        return string;
    }

    private String buildSqlForTable(TableDefinition tableDefinition, boolean bl) {
        List<ColumnIdentifier> list;
        TableIdentifier tableIdentifier;
        if (tableDefinition != null) {
            tableIdentifier = tableDefinition.getTable();
            list = tableDefinition.getColumns();
        } else {
            tableIdentifier = this.table;
            list = Collections.emptyList();
        }
        TableSelectBuilder tableSelectBuilder = new TableSelectBuilder(this.dbConnection, "tabledata");
        String string = null;
        if (DbExplorerSettings.getApplySQLSortInDbExplorer() && this.lastSort != null) {
            string = this.lastSort.getSqlExpression(this.dbConnection.getMetadata());
        }
        int n = bl ? this.dataDisplay.getMaxRows() : 0;
        String string2 = tableSelectBuilder.getSelectForColumns(tableIdentifier, list, string, n);
        return string2;
    }

    private void clearLoadingImage() {
        if (this.rowCountLabel != null) {
            this.rowCountLabel.setIcon(null);
        }
    }

    @Override
    public boolean confirmCancel() {
        return true;
    }

    public void cancelRetrieve() {
        if (this.dataDisplay != null) {
            this.dataDisplay.cancelExecution();
        }
    }

    @Override
    public void cancelExecution() {
        if (!this.initialized) {
            return;
        }
        WbThread wbThread = new WbThread("Cancel thread"){

            @Override
            public void run() {
                try {
                    TableDataPanel.this.dataDisplay.cancelExecution();
                }
                finally {
                    TableDataPanel.this.cancelRetrieve.setEnabled(false);
                    WbSwingUtilities.showDefaultCursor(TableDataPanel.this.dataDisplay);
                }
            }
        };
        wbThread.start();
    }

    protected void retrieveStart() {
        this.fireDbExecStart();
        this.retrieveRunning = true;
    }

    private void retrieveEnd() {
        this.retrieveRunning = false;
        this.dataDisplay.updateStatusBar();
        this.fireDbExecEnd();
    }

    protected void dbUpdateStart() {
        this.reloadAction.setEnabled(false);
        this.fireDbExecStart();
        this.updateRunning = true;
    }

    protected void dbUpdateEnd() {
        try {
            this.reloadAction.setEnabled(true);
        }
        finally {
            this.updateRunning = false;
            this.fireDbExecEnd();
        }
    }

    public boolean isRetrieving() {
        return this.retrieveRunning || this.updateRunning;
    }

    private void rollbackIfNeeded() {
        if (this.dbConnection.getDbSettings().getAutoCloseReadOnlyTransactions() != EndReadOnlyTrans.never) {
            return;
        }
        if (ExplorerUtils.isOwnTransaction(this.dbConnection)) {
            this.dbConnection.rollbackSilently();
        } else if (this.currentSavepoint != null) {
            this.dbConnection.rollback(this.currentSavepoint);
            this.currentSavepoint = null;
        }
    }

    private void commitRetrieveIfNeeded() {
        if (this.dbConnection.getDbSettings().getAutoCloseReadOnlyTransactions() != EndReadOnlyTrans.never) {
            return;
        }
        if (ExplorerUtils.isOwnTransaction(this.dbConnection)) {
            if (this.dbConnection.selectStartsTransaction()) {
                try {
                    this.dbConnection.commit();
                }
                catch (Throwable throwable) {}
            }
        } else if (this.currentSavepoint != null) {
            this.dbConnection.releaseSavepoint(this.currentSavepoint);
            this.currentSavepoint = null;
        }
    }

    private void retrieveTableDefinition() {
        if (this.table == null) {
            this.tableDefinition = null;
            return;
        }
        if (this.tableDefinition != null && this.table.equals(this.tableDefinition.getTable())) {
            return;
        }
        try {
            this.tableDefinition = this.dbConnection.getMetadata().getTableDefinition(this.table, true);
        }
        catch (SQLException sQLException) {
            this.tableDefinition = null;
            LogMgr.logError(new CallerInfo(){}, "Could not retrieve table definition", sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRetrieve(boolean bl) {
        boolean bl2;
        block20: {
            if (this.dbConnection == null) {
                return;
            }
            if (this.isRetrieving()) {
                return;
            }
            String string = null;
            if (!this.useDataStoreSource) {
                this.retrieveTableDefinition();
                string = this.buildSqlForTable(this.tableDefinition, bl);
                if (string == null) {
                    return;
                }
            }
            this.retrieveStart();
            this.cancelRetrieve.setEnabled(true);
            this.reloadAction.setEnabled(false);
            bl2 = false;
            try {
                WbSwingUtilities.showWaitCursor(this);
                WbSwingUtilities.invoke(() -> this.dataDisplay.setStatusMessage(ResourceMgr.getString("LblLoadingProgress")));
                this.setSavepoint();
                if (this.useDataStoreSource) {
                    this.dataDisplay.runCurrentSql(bl);
                } else {
                    LogMgr.logDebug(new CallerInfo(){}, "Retrieving table data using:\n" + string);
                    boolean bl3 = bl2 = !this.dataDisplay.runQuery(string, bl);
                    if (!bl2 && GuiSettings.getRetrieveQueryComments()) {
                        ResultColumnMetaData resultColumnMetaData = new ResultColumnMetaData(this.dbConnection);
                        resultColumnMetaData.updateCommentsFromDefinition(this.dataDisplay.getDataStore(), this.tableDefinition);
                    }
                    WbSwingUtilities.invoke(() -> {
                        this.dataDisplay.defineUpdateTable(this.tableDefinition);
                        this.dataDisplay.getSelectKeysAction().setEnabled(true);
                        String string = ResourceMgr.getString("TxtTableDataPrintHeader") + " " + this.table;
                        this.dataDisplay.setPrintHeader(string);
                        this.dataDisplay.showLastExecutionDuration();
                        if (this.lastSort != null) {
                            this.dataDisplay.setSortDefinition(this.lastSort);
                        }
                        ColumnOrderMgr.getInstance().restoreColumnOrder(this.dataDisplay.getTable());
                        this.dataDisplay.checkLimitReachedDisplay();
                        this.dataDisplay.showGeneratingSQLAsTooltip();
                    });
                }
            }
            catch (LowMemoryException lowMemoryException) {
                WbSwingUtilities.showDefaultCursor(this);
                bl2 = true;
                WbManager.getInstance().showLowMemoryError();
            }
            catch (Throwable throwable) {
                WbSwingUtilities.showDefaultCursor(this);
                bl2 = true;
                if (throwable instanceof OutOfMemoryError) {
                    try {
                        this.dataDisplay.getTable().reset();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    WbManager.getInstance().showOutOfMemoryError();
                    break block20;
                }
                String string2 = ExceptionUtil.getDisplay(throwable);
                LogMgr.logError(new CallerInfo(){}, "Error retrieving table data", throwable);
                WbSwingUtilities.showFriendlyErrorMessage(this, string2);
            }
            finally {
                WbSwingUtilities.showDefaultCursor(this);
                WbSwingUtilities.invoke(() -> {
                    this.dataDisplay.clearStatusMessage();
                    this.cancelRetrieve.setEnabled(false);
                    this.reloadAction.setEnabled(true);
                });
                this.retrieveEnd();
                if (bl2) {
                    this.rollbackIfNeeded();
                } else {
                    this.commitRetrieveIfNeeded();
                }
            }
        }
        if (!bl2 && DbExplorerSettings.getSelectDataPanelAfterRetrieve()) {
            WbSwingUtilities.requestFocus(this.dataDisplay.getTable());
        }
    }

    @Override
    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        if (this.dataDisplay != null) {
            this.dataDisplay.setCursor(cursor);
        }
    }

    @Override
    public void startReloadPanel(DwPanel dwPanel) {
        if (dwPanel != this.dataDisplay) {
            return;
        }
        this.reload();
    }

    public void retrieve(final boolean bl) {
        if (this.dbConnection == null) {
            return;
        }
        if (this.isRetrieving()) {
            return;
        }
        this.initGui();
        WbThread wbThread = new WbThread("TableDataPanel retrieve thread"){

            @Override
            public void run() {
                TableDataPanel.this.doRetrieve(bl);
            }
        };
        wbThread.start();
    }

    private String getWorkspacePrefix(int n) {
        return "dbexplorer" + n + ".tabledata.";
    }

    public void saveToWorkspace(WbWorkspace wbWorkspace, int n) {
        String string = this.getWorkspacePrefix(n);
        this.saveSettings(string, wbWorkspace.getSettings());
        this.storeColumnOrder();
    }

    public void readFromWorkspace(WbWorkspace wbWorkspace, int n) {
        this.restoreSettings();
        String string = this.getWorkspacePrefix(n);
        if (!this.initialized) {
            this.workspaceSettings = new FilteredProperties(wbWorkspace.getSettings(), string);
        } else {
            this.readSettings(string, wbWorkspace.getSettings());
        }
    }

    public void saveSettings() {
        String string = TableDataPanel.class.getName();
        this.saveSettings(string, Settings.getInstance());
    }

    private void saveSettings(String string, PropertyStorage propertyStorage) {
        if (this.initialized) {
            propertyStorage.setProperty(string + "maxrows", this.dataDisplay.getMaxRows());
            propertyStorage.setProperty(string + "timeout", this.dataDisplay.getQueryTimeout());
            propertyStorage.setProperty(string + "autoretrieve", this.autoRetrieve.isSelected());
            propertyStorage.setProperty(string + "autoloadrowcount", this.autoloadRowCount);
            propertyStorage.setProperty(string + "warningthreshold", this.warningThreshold);
        } else if (this.workspaceSettings != null) {
            this.workspaceSettings.copyTo(propertyStorage, string);
        }
    }

    public void restoreSettings() {
        String string = TableDataPanel.class.getName() + ".";
        this.readSettings(string, Settings.getInstance());
    }

    private void readSettings(String string, PropertyStorage propertyStorage) {
        int n = propertyStorage.getIntProperty(string + "maxrows", 500);
        if (n != -1 && this.dataDisplay != null) {
            this.dataDisplay.setMaxRows(n);
        }
        boolean bl = propertyStorage.getBoolProperty(string + "autoretrieve", true);
        if (this.autoRetrieve != null) {
            this.autoRetrieve.setSelected(bl);
        }
        this.autoloadRowCount = propertyStorage.getBoolProperty(string + "autoloadrowcount", true);
        this.warningThreshold = propertyStorage.getIntProperty(string + "warningthreshold", 1500);
        int n2 = propertyStorage.getIntProperty(string + "timeout", 0);
        if (this.dataDisplay != null) {
            this.dataDisplay.setQueryTimeout(n2);
        }
    }

    public void showData() {
        this.initGui();
        this.showData(true);
    }

    public void removeTableDisplay() {
        this.topPanel.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        this.topPanel.add((Component)this.toolbar, gridBagConstraints);
        if (this.showRefreshButton) {
            this.enableRefreshButton = new WbButton();
            this.enableRefreshButton.addActionListener(this);
            this.checkRefreshButton();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 22;
            this.topPanel.add((Component)this.enableRefreshButton, gridBagConstraints);
        }
        if (this.additionalButtons != null) {
            int n = IconMgr.getInstance().getToolbarIconSize() / 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(0, n, 0, 0);
            gridBagConstraints.anchor = 22;
            for (int i = 0; i < this.additionalButtons.size(); ++i) {
                ++gridBagConstraints.gridx;
                this.topPanel.add((Component)this.additionalButtons.get(i), gridBagConstraints);
            }
        }
        this.config.removeActionListener(this);
        this.rowCountButton.removeActionListener(this);
        this.autoloadRowCount = false;
        this.rowCountButton = null;
        this.rowCountLabel = null;
        this.config = null;
        this.tableNameLabel = null;
    }

    private void handleRefreshButton() {
        if (this.refreshMgr.isRegistered(this.dataDisplay)) {
            this.refreshMgr.removeRefresh(this.dataDisplay);
        } else {
            String string = Settings.getInstance().getProperty("workbench.gui.result.refresh.last_interval", null);
            String string2 = WbSwingUtilities.getUserInput(this, ResourceMgr.getString("LblRefreshIntv"), string);
            if (string2 == null) {
                return;
            }
            Settings.getInstance().setProperty("workbench.gui.result.refresh.last_interval", string2);
            int n = AutomaticRefreshMgr.parseInterval(string2);
            this.refreshMgr.addRefresh(this, this.dataDisplay, n);
        }
        this.checkRefreshButton();
        WbSwingUtilities.requestFocus(this.dataDisplay.getTable());
    }

    private void checkRefreshButton() {
        if (this.refreshMgr.isRegistered(this.dataDisplay)) {
            this.enableRefreshButton.setResourceKey("MnuTxtRemoveRefresh");
            this.enableRefreshButton.setIcon(IconMgr.getInstance().getLabelIcon("auto_refresh"));
        } else {
            this.enableRefreshButton.setResourceKey("MnuTxtReloadAutomatic");
            this.enableRefreshButton.setIcon(null);
        }
    }

    public void displayData(DataStore dataStore, long l) {
        this.initGui();
        this.removeTableDisplay();
        this.useDataStoreSource = true;
        try {
            this.setConnection(dataStore.getOriginalConnection());
            this.dataDisplay.showData(dataStore, dataStore.getGeneratingSql(), l);
            WbSwingUtilities.requestFocus(this.dataDisplay.getTable());
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not display data", sQLException);
        }
    }

    public void showData(boolean bl) {
        if (this.isRetrieving()) {
            return;
        }
        this.initGui();
        this.reset();
        long l = -1L;
        if (this.autoloadRowCount && (l = this.showRowCount()) == -1L) {
            return;
        }
        if (this.autoRetrieve.isSelected() && bl) {
            int n = this.dataDisplay.getMaxRows();
            if (this.warningThreshold > 0 && l > (long)this.warningThreshold && n == 0) {
                String string = ResourceMgr.getString("MsgDataDisplayWarningThreshold");
                int n2 = JOptionPane.showConfirmDialog(this, string = string.replace("%rows%", Long.toString(l)), "SQL Workbench/J", 0);
                if (n2 != 0) {
                    return;
                }
            }
            this.doRetrieve(true);
        }
    }

    @Override
    public void reload() {
        if (GuiSettings.getConfirmDiscardResultSetChanges() && this.isModified() && !WbSwingUtilities.getProceedCancel(this, "MsgDiscardDataChanges", new Object[0])) {
            return;
        }
        this.initGui();
        long l = -1L;
        boolean bl = this.reloadAction.ctrlPressed();
        this.storeSort();
        this.storeColumnOrder();
        if (this.autoloadRowCount && (l = this.showRowCount()) == -1L) {
            return;
        }
        this.retrieve(!bl);
    }

    public Window getParentWindow() {
        return SwingUtilities.getWindowAncestor(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.config) {
            TableDataSettings tableDataSettings = new TableDataSettings();
            tableDataSettings.setThresholdValue(this.warningThreshold);
            tableDataSettings.setAutoloadData(this.autoRetrieve.isSelected());
            tableDataSettings.setAutoloadRowCount(this.autoloadRowCount);
            Window window = SwingUtilities.getWindowAncestor(this);
            int n = JOptionPane.showConfirmDialog(window, tableDataSettings, ResourceMgr.getString("LblConfigureWarningThresholdTitle"), 2, -1);
            if (n == 0) {
                this.warningThreshold = tableDataSettings.getThresholdValue();
                this.autoRetrieve.setSelected(tableDataSettings.getAutoloadData());
                this.autoloadRowCount = tableDataSettings.getAutoloadRowCount();
            }
        } else if (actionEvent.getSource() == this.rowCountButton) {
            this.startRetrieveRowCount();
        } else if (actionEvent.getSource() == this.enableRefreshButton) {
            this.handleRefreshButton();
        }
    }

    @Override
    public void tableDataDeleted(List<TableIdentifier> list) {
        if (list == null) {
            return;
        }
        if (this.table == null) {
            return;
        }
        if (list.contains(this.table)) {
            this.reset();
        }
    }

    @Override
    public synchronized void addDbExecutionListener(DbExecutionListener dbExecutionListener) {
        if (dbExecutionListener == null) {
            return;
        }
        if (this.execListener == null) {
            this.execListener = Collections.synchronizedList(new ArrayList());
        }
        this.execListener.add(dbExecutionListener);
    }

    @Override
    public synchronized void removeDbExecutionListener(DbExecutionListener dbExecutionListener) {
        if (this.execListener == null) {
            return;
        }
        this.execListener.remove(dbExecutionListener);
    }

    protected synchronized void fireDbExecStart() {
        if (this.dbConnection == null) {
            return;
        }
        this.dbConnection.executionStart(this.dbConnection, this);
        if (this.execListener == null) {
            return;
        }
        for (DbExecutionListener dbExecutionListener : this.execListener) {
            if (dbExecutionListener == null) continue;
            dbExecutionListener.executionStart(this.dbConnection, this);
        }
    }

    protected synchronized void fireDbExecEnd() {
        if (this.dbConnection == null) {
            return;
        }
        this.dbConnection.executionEnd(this.dbConnection, this);
        if (this.execListener == null) {
            return;
        }
        for (DbExecutionListener dbExecutionListener : this.execListener) {
            if (dbExecutionListener == null) continue;
            dbExecutionListener.executionEnd(this.dbConnection, this);
        }
    }
}

