/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import workbench.resource.ResourceMgr;
import workbench.util.StringUtil;

public class TableDataSettings
extends JPanel
implements ActionListener {
    private JCheckBox autoloadData;
    private JCheckBox autoloadRowCount;
    private JCheckBox checkBoxEnableWarning;
    private JPanel jPanel1;
    private JTextField textFieldThresholdValue;
    private JLabel thresholdLabel;

    public TableDataSettings() {
        this.initComponents();
        this.checkBoxEnableWarning.addActionListener(this);
    }

    private void initComponents() {
        this.checkBoxEnableWarning = new JCheckBox();
        this.autoloadRowCount = new JCheckBox();
        this.autoloadData = new JCheckBox();
        this.thresholdLabel = new JLabel();
        this.textFieldThresholdValue = new JTextField();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.checkBoxEnableWarning.setText(ResourceMgr.getString("LblEnableDataThresholdWarning"));
        this.checkBoxEnableWarning.setToolTipText(ResourceMgr.getString("d_LblEnableDataThresholdWarning"));
        this.checkBoxEnableWarning.setMargin(new Insets(0, 0, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.checkBoxEnableWarning, gridBagConstraints);
        this.autoloadRowCount.setText(ResourceMgr.getString("LblAutoLoadRowCount"));
        this.autoloadRowCount.setToolTipText(ResourceMgr.getString("d_LblAutoLoadRowCount"));
        this.autoloadRowCount.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.autoloadRowCount, gridBagConstraints);
        this.autoloadData.setText(ResourceMgr.getString("LblAutoLoadTableData"));
        this.autoloadData.setToolTipText(ResourceMgr.getDescription("LblAutoLoadTableData"));
        this.autoloadData.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.autoloadData, gridBagConstraints);
        this.thresholdLabel.setText(ResourceMgr.getString("LblThresholdLevel"));
        this.thresholdLabel.setToolTipText(ResourceMgr.getString("d_LblThresholdLevel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.thresholdLabel, gridBagConstraints);
        this.textFieldThresholdValue.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 9);
        this.add((Component)this.textFieldThresholdValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    public int getThresholdValue() {
        if (this.checkBoxEnableWarning.isSelected()) {
            return StringUtil.getIntValue(this.textFieldThresholdValue.getText(), -1);
        }
        return -1;
    }

    public void setAutoloadRowCount(boolean bl) {
        this.autoloadRowCount.setSelected(bl);
    }

    public boolean getAutoloadRowCount() {
        return this.autoloadRowCount.isSelected();
    }

    public void setAutoloadData(boolean bl) {
        this.autoloadData.setSelected(bl);
    }

    public boolean getAutoloadData() {
        return this.autoloadData.isSelected();
    }

    public void setThresholdValue(int n) {
        this.checkBoxEnableWarning.setSelected(n > 0);
        this.textFieldThresholdValue.setEnabled(n > 0);
        this.thresholdLabel.setEnabled(n > 0);
        if (n <= 0) {
            this.textFieldThresholdValue.setText("");
        } else {
            this.textFieldThresholdValue.setText(Integer.toString(n));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.checkBoxEnableWarning) {
            this.textFieldThresholdValue.setEnabled(this.checkBoxEnableWarning.isSelected());
            this.thresholdLabel.setEnabled(this.checkBoxEnableWarning.isSelected());
        }
    }
}

