/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import workbench.db.CommitType;
import workbench.db.TableDeleter;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.importer.TableDependencySorter;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.EditWindow;
import workbench.gui.components.NoSelectionModel;
import workbench.gui.components.WbButton;
import workbench.gui.components.WbStatusLabel;
import workbench.interfaces.JobErrorHandler;
import workbench.interfaces.StatusBar;
import workbench.interfaces.TableDeleteListener;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.WbThread;

public class TableDeleterUI
extends JPanel
implements WindowListener,
JobErrorHandler {
    private JDialog dialog;
    private List<TableIdentifier> objectNames;
    private boolean cancelled;
    private WbConnection connection;
    private Thread deleteThread;
    private Thread checkThread;
    private final List<TableDeleteListener> deleteListener = new ArrayList<TableDeleteListener>(1);
    private TableDeleter deleter;
    public JCheckBox addMissingTables;
    public ButtonGroup buttonGroup1;
    public JPanel buttonPanel;
    public JButton cancelButton;
    public JCheckBox cascadeTruncate;
    public JButton checkFKButton;
    public JRadioButton commitAtEnd;
    public JRadioButton commitEach;
    public JButton deleteButton;
    public JPanel jPanel2;
    public JScrollPane jScrollPane1;
    public JSeparator jSeparator1;
    public JPanel mainPanel;
    public JList objectList;
    public JPanel optionPanel;
    public JButton showScript;
    public JLabel statusLabel;
    public JCheckBox useTruncateCheckBox;

    public TableDeleterUI() {
        this.initComponents();
        this.statusLabel.setText("  ");
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonPanel = new JPanel();
        this.deleteButton = new WbButton();
        this.cancelButton = new WbButton();
        this.showScript = new JButton();
        this.mainPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.objectList = new JList();
        this.optionPanel = new JPanel();
        this.statusLabel = new WbStatusLabel();
        this.jPanel2 = new JPanel();
        this.commitEach = new JRadioButton();
        this.commitAtEnd = new JRadioButton();
        this.useTruncateCheckBox = new JCheckBox();
        this.cascadeTruncate = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.addMissingTables = new JCheckBox();
        this.checkFKButton = new JButton();
        this.setLayout(new BorderLayout(0, 5));
        this.buttonPanel.setLayout(new GridBagLayout());
        this.deleteButton.setText(ResourceMgr.getString("LblDeleteTableData"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableDeleterUI.this.deleteButtonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        this.buttonPanel.add((Component)this.deleteButton, gridBagConstraints);
        this.cancelButton.setText(ResourceMgr.getString("LblClose"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableDeleterUI.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 0, 2);
        this.buttonPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.showScript.setText(ResourceMgr.getString("LblShowScript"));
        this.showScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableDeleterUI.this.showScriptActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 1, 0, 20);
        this.buttonPanel.add((Component)this.showScript, gridBagConstraints);
        this.add((Component)this.buttonPanel, "South");
        this.mainPanel.setLayout(new BorderLayout(0, 5));
        this.objectList.setSelectionMode(0);
        this.objectList.setSelectionModel(new NoSelectionModel());
        this.jScrollPane1.setViewportView(this.objectList);
        this.mainPanel.add((Component)this.jScrollPane1, "Center");
        this.optionPanel.setLayout(new GridBagLayout());
        this.statusLabel.setText("  ");
        this.statusLabel.setBorder(BorderFactory.createEtchedBorder());
        this.statusLabel.setMinimumSize(new Dimension(150, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.optionPanel.add((Component)this.statusLabel, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.buttonGroup1.add(this.commitEach);
        this.commitEach.setSelected(true);
        this.commitEach.setText(ResourceMgr.getString("LblCommitEachTableDelete"));
        this.commitEach.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel2.add((Component)this.commitEach, gridBagConstraints);
        this.buttonGroup1.add(this.commitAtEnd);
        this.commitAtEnd.setText(ResourceMgr.getString("LblCommitTableDeleteAtEnd"));
        this.commitAtEnd.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 6, 0, 0);
        this.jPanel2.add((Component)this.commitAtEnd, gridBagConstraints);
        this.useTruncateCheckBox.setText(ResourceMgr.getString("LblUseTruncate"));
        this.useTruncateCheckBox.setBorder(null);
        this.useTruncateCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                TableDeleterUI.this.useTruncateCheckBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 25, 0, 0);
        this.jPanel2.add((Component)this.useTruncateCheckBox, gridBagConstraints);
        this.cascadeTruncate.setText(ResourceMgr.getString("LblCascadeConstraints"));
        this.cascadeTruncate.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 41, 0, 0);
        this.jPanel2.add((Component)this.cascadeTruncate, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 9);
        this.optionPanel.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 0, 12, 0);
        this.optionPanel.add((Component)this.jSeparator1, gridBagConstraints);
        this.addMissingTables.setSelected(true);
        this.addMissingTables.setText(ResourceMgr.getString("LblIncFkTables"));
        this.addMissingTables.setToolTipText(ResourceMgr.getString("d_LblIncFkTables"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 2, 0, 0);
        this.optionPanel.add((Component)this.addMissingTables, gridBagConstraints);
        this.checkFKButton.setText(ResourceMgr.getString("LblCheckFKDeps"));
        this.checkFKButton.setToolTipText(ResourceMgr.getDescription("LblCheckFKDeps"));
        this.checkFKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableDeleterUI.this.checkFKButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 6, 0, 5);
        this.optionPanel.add((Component)this.checkFKButton, gridBagConstraints);
        this.mainPanel.add((Component)this.optionPanel, "South");
        this.add((Component)this.mainPanel, "Center");
    }

    private void useTruncateCheckBoxItemStateChanged(ItemEvent itemEvent) {
        this.checkState();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        if (this.deleter != null) {
            this.deleter.cancel();
        }
        this.cancelled = true;
        this.closeWindow();
    }

    private void deleteButtonActionPerformed(ActionEvent actionEvent) {
        this.startDelete();
    }

    private void checkFKButtonActionPerformed(ActionEvent actionEvent) {
        if (this.connection.isBusy()) {
            return;
        }
        this.deleteButton.setEnabled(false);
        this.showScript.setEnabled(false);
        this.statusLabel.setText(ResourceMgr.getString("MsgFkDeps"));
        WbSwingUtilities.showWaitCursor(this.dialog);
        this.checkThread = new WbThread("FKCheck"){

            @Override
            public void run() {
                List<TableIdentifier> list = null;
                try {
                    TableDeleterUI.this.connection.setBusy(true);
                    TableDependencySorter tableDependencySorter = new TableDependencySorter(TableDeleterUI.this.connection);
                    tableDependencySorter.setValidateTables(false);
                    list = tableDependencySorter.sortForDelete(TableDeleterUI.this.objectNames, TableDeleterUI.this.addMissingTables.isSelected());
                }
                catch (Exception exception) {
                    LogMgr.logError(new CallerInfo(){}, "Error checking FK dependencies", exception);
                    WbSwingUtilities.showErrorMessage(ExceptionUtil.getDisplay(exception));
                    list = null;
                }
                finally {
                    TableDeleterUI.this.connection.setBusy(false);
                    TableDeleterUI.this.fkCheckFinished(list);
                }
            }
        };
        this.checkThread.start();
    }

    private void showScriptActionPerformed(ActionEvent actionEvent) {
        this.showScript();
    }

    protected void fkCheckFinished(List<TableIdentifier> list) {
        this.checkThread = null;
        EventQueue.invokeLater(() -> {
            this.statusLabel.setText("");
            if (list != null) {
                this.setObjects(list);
            }
            this.deleteButton.setEnabled(true);
            this.showScript.setEnabled(true);
            WbSwingUtilities.showDefaultCursor(this.dialog);
        });
    }

    @Override
    public void fatalError(String string) {
        WbSwingUtilities.showErrorMessage(this, string);
    }

    @Override
    public int getActionOnError(int n, String string, String string2, String string3) {
        int n2 = WbSwingUtilities.getYesNoIgnoreAll(this.dialog, string3);
        if (n2 == 2042) {
            return 2;
        }
        if (n2 == 0) {
            return 1;
        }
        return 3;
    }

    protected void closeWindow() {
        try {
            if (this.deleter != null) {
                this.deleter.cancel();
            }
            if (this.deleteThread != null) {
                this.deleteThread.interrupt();
                this.deleteThread = null;
            }
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "Error when trying to kill delete Thread", exception);
        }
        try {
            if (this.checkThread != null) {
                this.checkThread.interrupt();
                this.checkThread = null;
            }
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "Error when trying to kill check thread", exception);
        }
        try {
            if (this.dialog != null) {
                this.dialog.setVisible(false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.dialog = null;
    }

    public void setConnection(WbConnection wbConnection) {
        this.connection = wbConnection;
        if (this.connection != null) {
            this.useTruncateCheckBox.setEnabled(this.connection.getDbSettings().supportsTruncate());
            this.checkState();
        }
    }

    protected void checkState() {
        boolean bl;
        boolean bl2 = this.connection == null ? true : this.connection.getAutoCommit();
        boolean bl3 = bl = this.useTruncateCheckBox.isSelected() && this.useTruncateCheckBox.isEnabled();
        if (bl2) {
            this.commitAtEnd.setEnabled(false);
            this.commitEach.setEnabled(false);
        } else if (bl) {
            this.commitAtEnd.setEnabled(this.connection.getDbSettings().truncateNeedsCommit());
            this.commitEach.setEnabled(this.connection.getDbSettings().truncateNeedsCommit());
        } else {
            this.commitAtEnd.setEnabled(true);
            this.commitEach.setEnabled(true);
        }
        boolean bl4 = this.connection == null ? false : this.connection.getDbSettings().supportsCascadedTruncate();
        this.cascadeTruncate.setEnabled(bl4 && bl);
        if (!bl4) {
            this.cascadeTruncate.setSelected(false);
        }
    }

    protected void startDelete() {
        this.deleteButton.setEnabled(false);
        this.deleteThread = new WbThread("TableDeleteThread"){

            @Override
            public void run() {
                TableDeleterUI.this.doDelete();
            }
        };
        this.deleteThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete() {
        this.cancelled = false;
        boolean bl = this.commitEach.isEnabled() && this.commitEach.isSelected();
        boolean bl2 = this.useTruncateCheckBox.isSelected();
        boolean bl3 = bl2 ? this.cascadeTruncate.isSelected() : false;
        this.deleter = new TableDeleter(this.connection);
        this.deleter.setStatusBar((StatusBar)((Object)this.statusLabel));
        boolean bl4 = false;
        List<TableIdentifier> list = null;
        try {
            this.cancelButton.setText(ResourceMgr.getString("LblCancel"));
            list = this.deleter.deleteTableData(this.objectNames, bl, bl2, bl3);
        }
        catch (SQLException sQLException) {
            WbSwingUtilities.showErrorMessage(this, ExceptionUtil.getDisplay(sQLException));
        }
        finally {
            this.cancelButton.setText(ResourceMgr.getString("LblClose"));
            EventQueue.invokeLater(() -> this.deleteButton.setEnabled(true));
        }
        this.fireTableDeleted(list);
        this.statusLabel.setText("");
        this.deleter = null;
        if (!bl4) {
            this.closeWindow();
        }
    }

    protected void showScript() {
        boolean bl;
        CommitType commitType = CommitType.once;
        if (this.commitEach.isSelected()) {
            commitType = CommitType.each;
        }
        boolean bl2 = (bl = this.useTruncateCheckBox.isSelected()) && this.cascadeTruncate.isSelected();
        TableDeleter tableDeleter = new TableDeleter(this.connection);
        CharSequence charSequence = tableDeleter.generateScript(this.objectNames, commitType, bl, bl2);
        EditWindow editWindow = new EditWindow((Dialog)this.dialog, ResourceMgr.getString("TxtWindowTitleGeneratedScript"), charSequence.toString(), "workbench.tabledeleter.scriptwindow", true);
        editWindow.setVisible(true);
        editWindow.dispose();
    }

    public boolean dialogWasCancelled() {
        return this.cancelled;
    }

    public void setObjects(List<TableIdentifier> list) {
        this.objectNames = list == null ? CollectionUtil.arrayList() : new ArrayList<TableIdentifier>(list);
        int n = this.objectNames.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.objectNames.get(i).getObjectExpression(this.connection);
        }
        this.objectList.setListData(stringArray);
    }

    public void showDialog(Frame frame) {
        this.dialog = new JDialog(frame, ResourceMgr.getString("TxtDeleteTableData"), false);
        this.dialog.getContentPane().add(this);
        this.dialog.pack();
        if (this.dialog.getWidth() < 200) {
            this.dialog.setSize(200, this.dialog.getHeight());
        }
        WbSwingUtilities.center(this.dialog, frame);
        this.cancelled = true;
        this.dialog.setVisible(true);
    }

    public void addDeleteListener(TableDeleteListener tableDeleteListener) {
        if (tableDeleteListener != null) {
            this.deleteListener.add(tableDeleteListener);
        }
    }

    public void removeDeleteListener(TableDeleteListener tableDeleteListener) {
        if (tableDeleteListener != null) {
            this.deleteListener.remove(tableDeleteListener);
        }
    }

    protected void fireTableDeleted(List<TableIdentifier> list) {
        if (this.deleteListener == null || list == null) {
            return;
        }
        for (TableDeleteListener tableDeleteListener : this.deleteListener) {
            if (tableDeleteListener == null) continue;
            tableDeleteListener.tableDataDeleted(list);
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.cancelled = true;
        this.closeWindow();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }
}

