/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects.objecttree;

import java.util.Set;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.DbSettings;
import workbench.db.WbConnection;
import workbench.gui.dbobjects.objecttree.CatalogObjectNode;
import workbench.gui.dbobjects.objecttree.ObjectTreeNode;
import workbench.gui.dbobjects.objecttree.TreeLoader;
import workbench.resource.ResourceMgr;
import workbench.util.CollectionUtil;

public class CatalogObjectTypesNode
extends ObjectTreeNode {
    private final Set<String> typesToShow = CollectionUtil.caseInsensitiveSet();

    public CatalogObjectTypesNode(Set<String> set) {
        super(ResourceMgr.getString("LblGlobalObjects"), "global");
        this.setAllowsChildren(true);
        this.setTypesToShow(set);
    }

    public void setTypesToShow(Set<String> set) {
        this.typesToShow.clear();
        this.typesToShow.addAll(set);
    }

    @Override
    public boolean loadChildren(WbConnection wbConnection, TreeLoader treeLoader) {
        if (wbConnection == null) {
            return false;
        }
        DbSettings dbSettings = wbConnection.getDbSettings();
        if (dbSettings == null) {
            return false;
        }
        DbMetadata dbMetadata = wbConnection.getMetadata();
        if (dbMetadata == null) {
            return false;
        }
        Set<String> set = dbSettings.getCatalogLevelTypes();
        if (CollectionUtil.isEmpty(set)) {
            return false;
        }
        ObjectTreeNode objectTreeNode = this.getParent();
        if (objectTreeNode == null) {
            return false;
        }
        DbObject dbObject = (DbObject)objectTreeNode.getUserObject();
        if (dbObject == null) {
            return false;
        }
        String string = dbObject.getObjectName();
        for (String string2 : set) {
            if (!this.typesToShow.isEmpty() && !this.typesToShow.contains(string2)) continue;
            CatalogObjectNode catalogObjectNode = new CatalogObjectNode(string, string2);
            this.add(catalogObjectNode);
        }
        this.setChildrenLoaded(true);
        return true;
    }
}

