/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects.objecttree;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import workbench.db.DbObject;
import workbench.db.WbConnection;
import workbench.gui.MainWindow;
import workbench.gui.dbobjects.objecttree.DbTreePanel;
import workbench.gui.dbobjects.objecttree.ObjectTreeNode;
import workbench.gui.sql.PanelContentSender;
import workbench.gui.sql.PasteType;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.util.WbThread;

public class EditAction
implements ActionListener {
    private DbTreePanel dbTree;

    public EditAction(DbTreePanel dbTreePanel) {
        this.dbTree = dbTreePanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.dbTree == null) {
            return;
        }
        ObjectTreeNode objectTreeNode = this.dbTree.getSelectedNode();
        if (objectTreeNode == null) {
            return;
        }
        final DbObject dbObject = objectTreeNode.getDbObject();
        if (dbObject == null) {
            return;
        }
        String string = actionEvent.getActionCommand();
        final int n = Integer.parseInt(string.substring("panel_".length()));
        WbThread wbThread = new WbThread("DbTree source retrieval"){

            @Override
            public void run() {
                EditAction.this.retrieveAndShow(dbObject, n);
            }
        };
        wbThread.start();
    }

    private void retrieveAndShow(final DbObject dbObject, final int n) {
        final String string = this.retrieveSource(dbObject);
        if (string == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Window window = SwingUtilities.getWindowAncestor(EditAction.this.dbTree);
                if (window instanceof MainWindow) {
                    PanelContentSender panelContentSender = new PanelContentSender((MainWindow)window, dbObject.getObjectName());
                    panelContentSender.sendContent(string, n, PasteType.overwrite);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String retrieveSource(DbObject dbObject) {
        WbConnection wbConnection = this.dbTree.getConnection();
        if (wbConnection == null) {
            return null;
        }
        if (wbConnection.isBusy()) {
            return null;
        }
        if (dbObject == null) {
            return null;
        }
        try {
            this.dbTree.getStatusBar().setStatusMessage(ResourceMgr.getString("MsgRetrieving"));
            try {
                CharSequence charSequence = dbObject.getSource(this.dbTree.getConnection());
                if (charSequence == null) {
                    String string = null;
                    return string;
                }
                String string = charSequence.toString();
                return string;
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Could not retrieve object source for: " + dbObject.getObjectExpression(this.dbTree.getConnection()), exception);
                String string = null;
                return string;
            }
        }
        finally {
            this.dbTree.getStatusBar().clearStatusMessage();
        }
    }
}

