/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects.objecttree;

import java.awt.Point;
import workbench.db.ColumnIdentifier;
import workbench.db.ConnectionMgr;
import workbench.db.DbObject;
import workbench.db.ProcedureDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.gui.dbobjects.objecttree.ObjectTreeNode;
import workbench.gui.dbobjects.objecttree.ObjectTreeTransferable;
import workbench.gui.sql.EditorPanel;
import workbench.sql.formatter.FormatterUtil;
import workbench.sql.formatter.WbSqlFormatter;
import workbench.sql.parser.ParserType;
import workbench.sql.parser.ScriptParser;
import workbench.util.StringUtil;

public class EditorDropHandler {
    private EditorPanel editor;

    public EditorDropHandler(EditorPanel editorPanel) {
        this.editor = editorPanel;
    }

    public void handleDrop(ObjectTreeTransferable objectTreeTransferable, Point point) {
        DbObject dbObject;
        if (objectTreeTransferable == null) {
            return;
        }
        ObjectTreeNode[] objectTreeNodeArray = objectTreeTransferable.getSelectedNodes();
        if (objectTreeNodeArray == null || objectTreeNodeArray.length == 0) {
            return;
        }
        String string = objectTreeTransferable.getConnectionId();
        WbConnection wbConnection = ConnectionMgr.getInstance().findConnection(string);
        ScriptParser scriptParser = new ScriptParser(ParserType.getTypeFromConnection(wbConnection));
        scriptParser.setScript(this.editor.getSelectedStatement());
        int n = this.editor.xyToOffset((int)point.getX() - this.editor.getPainter().getGutterWidth(), (int)point.getY());
        int n2 = scriptParser.getCommandIndexAtCursorPos(n);
        String string2 = scriptParser.getCommand(n2, false);
        if (objectTreeNodeArray.length == 1 && StringUtil.isEmptyString(string2) && (dbObject = objectTreeNodeArray[0].getDbObject()) instanceof TableIdentifier) {
            String string3 = "select * from " + dbObject.getObjectExpression(wbConnection);
            WbSqlFormatter wbSqlFormatter = new WbSqlFormatter((CharSequence)string3, wbConnection.getDbId());
            string3 = wbSqlFormatter.getFormattedSql();
            this.insertString(string3, n);
            return;
        }
        int n3 = this.editor.getLineOfOffset(n);
        int n4 = this.editor.getColumnOfOffset(n);
        boolean bl = this.editor.getTokenMarker().isStringLiteralAt(n3, n4);
        StringBuilder stringBuilder = new StringBuilder(objectTreeNodeArray.length * 20);
        for (int i = 0; i < objectTreeNodeArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.getDisplayString(wbConnection, objectTreeNodeArray[i], !bl));
        }
        this.insertString(stringBuilder.toString(), n);
    }

    private void insertString(String string, int n) {
        int n2;
        int n3 = this.editor.getSelectionStart();
        if (n3 < (n2 = this.editor.getSelectionEnd()) && n3 <= n && n <= n2) {
            this.editor.setSelectedText(string);
        } else {
            this.editor.insertText(n, string);
        }
    }

    private String getDisplayString(WbConnection wbConnection, ObjectTreeNode objectTreeNode, boolean bl) {
        String string;
        if (objectTreeNode == null) {
            return "";
        }
        DbObject dbObject = objectTreeNode.getDbObject();
        if (dbObject == null) {
            if ("column-list".equals(objectTreeNode.getType())) {
                return this.getColumnList(objectTreeNode, bl);
            }
            return objectTreeNode.getName();
        }
        if (dbObject instanceof ProcedureDefinition) {
            string = ((ProcedureDefinition)dbObject).getDisplayName();
        } else {
            string = dbObject.getObjectExpression(wbConnection);
            if (bl) {
                return FormatterUtil.getIdentifier(string);
            }
        }
        return string;
    }

    private String getColumnList(ObjectTreeNode objectTreeNode, boolean bl) {
        int n = objectTreeNode.getChildCount();
        StringBuilder stringBuilder = new StringBuilder(n * 10);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            DbObject dbObject;
            ObjectTreeNode objectTreeNode2 = objectTreeNode.getChildAt(i);
            if (objectTreeNode2 == null || objectTreeNode2.getDbObject() == null || !((dbObject = objectTreeNode2.getDbObject()) instanceof ColumnIdentifier)) continue;
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(dbObject.getObjectName());
            ++n2;
        }
        String string = stringBuilder.toString();
        if (bl) {
            return FormatterUtil.getIdentifier(string);
        }
        return string;
    }
}

