/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects.objecttree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import workbench.db.CatalogIdentifier;
import workbench.db.ColumnIdentifier;
import workbench.db.DbObject;
import workbench.db.IndexDefinition;
import workbench.db.ProcedureDefinition;
import workbench.db.SchemaIdentifier;
import workbench.db.TableIdentifier;
import workbench.db.TriggerDefinition;
import workbench.db.TriggerLevel;
import workbench.db.WbConnection;
import workbench.gui.dbobjects.objecttree.DbTreeSettings;
import workbench.gui.dbobjects.objecttree.TreeLoader;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.filter.ColumnExpression;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbNumberFormatter;

public class ObjectTreeNode
extends DefaultMutableTreeNode
implements Serializable {
    private Set<String> typesWithChildren = CollectionUtil.caseInsensitiveSet("database", "catalog", "schema", "table", "view", "materialized view", "type", "package", "enum", "index", "procedure");
    private String nodeType;
    private String nodeName;
    private boolean isLoaded;
    private Long rowCount;
    private int originalIndex;
    private List<ObjectTreeNode> filteredNodes = new ArrayList<ObjectTreeNode>();
    private DbObject originalObject;
    private String display;
    private String tooltip;
    private String iconKey;
    private String iconKeyOpen;

    public ObjectTreeNode(DbObject dbObject) {
        super(dbObject);
        this.nodeType = dbObject.getObjectType();
        this.nodeName = dbObject.getObjectName();
        this.allowsChildren = false;
    }

    public ObjectTreeNode(String string, String string2) {
        this.nodeType = string2;
        this.nodeName = string;
    }

    public void setNodeType(String string) {
        this.nodeType = string;
    }

    public void setNameAndType(String string, String string2) {
        this.nodeType = string2;
        this.nodeName = string;
    }

    public void setIconKey(String string) {
        this.iconKey = string;
    }

    public void setIconKeyOpen(String string) {
        this.iconKeyOpen = string;
    }

    public String getIconKey() {
        return this.iconKey;
    }

    public String getIconKeyOpen() {
        return this.iconKeyOpen;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setDisplay(String string) {
        this.display = string;
    }

    public void setChildrenLoaded(boolean bl) {
        this.isLoaded = bl;
    }

    public boolean isFKTable() {
        if (this.getDbObject() == null) {
            return false;
        }
        ObjectTreeNode objectTreeNode = this.getParent();
        if (objectTreeNode == null) {
            return false;
        }
        return "referenced-fk-list".equalsIgnoreCase(objectTreeNode.getType()) || "referencing-fk-list".equals(objectTreeNode.getType());
    }

    public boolean isNamespace() {
        return this.isSchemaNode() || this.isCatalogNode();
    }

    public boolean isSchemaNode() {
        if (this.getDbObject() instanceof SchemaIdentifier) {
            return true;
        }
        return this.getType().equalsIgnoreCase("schema");
    }

    public boolean isCatalogNode() {
        if (this.getDbObject() instanceof CatalogIdentifier) {
            return true;
        }
        return this.getType().equalsIgnoreCase("catalog");
    }

    public boolean childrenAreLoaded() {
        if (!this.isLoaded) {
            return false;
        }
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            ObjectTreeNode objectTreeNode = this.getChildAt(i);
            if (objectTreeNode.isLoaded) continue;
            return false;
        }
        return true;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void setRowCount(Long l) {
        this.rowCount = l;
    }

    @Override
    public void removeAllChildren() {
        super.removeAllChildren();
        this.isLoaded = false;
        this.filteredNodes.clear();
    }

    public boolean canHaveChildren() {
        if (this.getAllowsChildren()) {
            return true;
        }
        return this.getType() != null && this.typesWithChildren.contains(this.getType());
    }

    @Override
    public ObjectTreeNode getChildAt(int n) {
        return (ObjectTreeNode)super.getChildAt(n);
    }

    @Override
    public ObjectTreeNode getParent() {
        return (ObjectTreeNode)super.getParent();
    }

    @Override
    public boolean isLeaf() {
        return !this.allowsChildren;
    }

    public DbObject getDbObject() {
        return (DbObject)this.getUserObject();
    }

    public String getType() {
        if (this.getDbObject() == null) {
            return this.nodeType;
        }
        if (this.getDbObject() instanceof CatalogIdentifier) {
            return "catalog";
        }
        return this.getDbObject().getObjectType();
    }

    public String getName() {
        DbObject dbObject = this.getDbObject();
        if (dbObject == null) {
            return this.nodeName;
        }
        return dbObject.getObjectName();
    }

    public boolean isChanged() {
        return this.originalObject != null;
    }

    public void resetChanged() {
        this.originalObject = null;
    }

    private DbObject copyUserObject() {
        DbObject dbObject = this.getDbObject();
        if (dbObject == null) {
            return null;
        }
        if (dbObject instanceof TableIdentifier) {
            return ((TableIdentifier)dbObject).createCopy();
        }
        if (dbObject instanceof ColumnIdentifier) {
            return ((ColumnIdentifier)dbObject).createCopy();
        }
        if (dbObject instanceof SchemaIdentifier) {
            SchemaIdentifier schemaIdentifier = new SchemaIdentifier(dbObject.getSchema());
            schemaIdentifier.setCatalog(dbObject.getCatalog());
            return schemaIdentifier;
        }
        if (dbObject instanceof CatalogIdentifier) {
            CatalogIdentifier catalogIdentifier = new CatalogIdentifier(dbObject.getCatalog());
            return catalogIdentifier;
        }
        if (dbObject instanceof IndexDefinition) {
            return ((IndexDefinition)dbObject).createCopy();
        }
        return null;
    }

    @Override
    public void setUserObject(Object object) {
        if (object instanceof String) {
            this.originalObject = this.copyUserObject();
            DbObject dbObject = this.getDbObject();
            String string = (String)object;
            dbObject.setName(string);
        } else {
            super.setUserObject(object);
        }
    }

    @Override
    public String toString() {
        DbObject dbObject;
        if (this.display != null) {
            return this.display;
        }
        DbObject dbObject2 = this.getDbObject();
        if (dbObject2 == null) {
            return this.nodeName;
        }
        if (dbObject2 instanceof ColumnIdentifier) {
            ColumnIdentifier columnIdentifier = (ColumnIdentifier)dbObject2;
            String string = null;
            String string2 = null;
            if (columnIdentifier.isNullable()) {
                string = columnIdentifier.getColumnName();
                string2 = columnIdentifier.getDbmsType();
            } else {
                string = "<b>" + columnIdentifier.getColumnName() + "</b>";
                string2 = columnIdentifier.getDbmsType() + " NOT NULL";
            }
            return "<html>" + string + " - <tt>" + string2 + "</tt></html>";
        }
        if (dbObject2 instanceof IndexDefinition) {
            dbObject = (IndexDefinition)dbObject2;
            if (((IndexDefinition)dbObject).isPrimaryKeyIndex()) {
                return ((IndexDefinition)dbObject).getName() + " (PK)";
            }
            if (((IndexDefinition)dbObject).isUnique()) {
                return ((IndexDefinition)dbObject).getName() + " (UNIQUE)";
            }
        }
        if (dbObject2 instanceof ProcedureDefinition) {
            dbObject = (ProcedureDefinition)dbObject2;
            return ((ProcedureDefinition)dbObject).getDisplayName();
        }
        if (dbObject2 instanceof TableIdentifier && this.rowCount != null) {
            return dbObject2.getObjectName() + " (" + this.getRowCountAsString() + ")";
        }
        return dbObject2.getObjectName();
    }

    private String getRowCountAsString() {
        String string = DbTreeSettings.getRowCountFormatString();
        try {
            if (string != null) {
                String string2 = DbTreeSettings.getRowCountGroupSymbol();
                String string3 = Settings.getInstance().getDecimalSymbol();
                WbNumberFormatter wbNumberFormatter = new WbNumberFormatter(string, string3.charAt(0), string2.charAt(this.originalIndex));
                return wbNumberFormatter.format(this.rowCount);
            }
            if (DbTreeSettings.useIntegerFormatterForRowCount()) {
                WbNumberFormatter wbNumberFormatter = Settings.getInstance().createDefaultIntegerFormatter();
                return wbNumberFormatter.format(this.rowCount);
            }
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not format row count", throwable);
        }
        return this.rowCount.toString();
    }

    public void setTooltip(String string) {
        this.tooltip = StringUtil.trimToNull(string);
    }

    public String getTooltip() {
        if (this.tooltip != null) {
            return this.tooltip;
        }
        DbObject dbObject = this.getDbObject();
        if (dbObject == null) {
            return null;
        }
        if (dbObject instanceof TriggerDefinition) {
            TriggerDefinition triggerDefinition = (TriggerDefinition)dbObject;
            String string = null;
            if (triggerDefinition.getTriggerType() != null && triggerDefinition.getTriggerEvent() != null) {
                TriggerLevel triggerLevel;
                string = triggerDefinition.getTriggerType() + " " + triggerDefinition.getTriggerEvent();
                if (triggerDefinition.getRelatedTable() != null) {
                    string = string + " ON " + triggerDefinition.getRelatedTable().getTableName();
                }
                if ((triggerLevel = triggerDefinition.getLevel()) == TriggerLevel.row) {
                    string = string + " FOR EACH ROW";
                } else if (triggerLevel == TriggerLevel.statement) {
                    string = string + " FOR EACH STATEMENT";
                }
            } else {
                string = triggerDefinition.getObjectType();
            }
            return string;
        }
        if (dbObject instanceof ColumnIdentifier) {
            if ("parameter".equals(this.nodeType)) {
                return ((ColumnIdentifier)dbObject).getArgumentMode();
            }
            return this.getColumnTooltip((ColumnIdentifier)dbObject);
        }
        String string = dbObject.getComment();
        if (StringUtil.isNonBlank(string)) {
            return string;
        }
        return dbObject.getObjectType();
    }

    private String getColumnTooltip(ColumnIdentifier columnIdentifier) {
        String string = null;
        if (StringUtil.isNonBlank(columnIdentifier.getDefaultValue())) {
            string = "DEFAULT " + columnIdentifier.getDefaultValue();
        }
        String string2 = columnIdentifier.getComment();
        String string3 = null;
        string3 = StringUtil.isNonEmpty(string2) ? "<html>" + (string == null ? "" : string + "<br>") + string2 + "</html>" : string;
        return string3;
    }

    public boolean isFiltered() {
        return CollectionUtil.isNonEmpty(this.filteredNodes);
    }

    public boolean applyFilter(ColumnExpression columnExpression) {
        this.resetFilter();
        if (columnExpression == null) {
            return false;
        }
        int n = this.getChildCount();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            String string;
            boolean bl;
            DbObject dbObject;
            ObjectTreeNode objectTreeNode = this.getChildAt(i);
            if (objectTreeNode.isCatalogNode() || objectTreeNode.isSchemaNode() || (dbObject = objectTreeNode.getDbObject()) == null || (bl = columnExpression.evaluate(string = dbObject.getObjectName()))) continue;
            objectTreeNode.originalIndex = i;
            this.filteredNodes.add(objectTreeNode);
        }
        for (ObjectTreeNode objectTreeNode : this.filteredNodes) {
            this.remove(objectTreeNode);
        }
        return this.filteredNodes.size() > 0;
    }

    public void resetFilter() {
        if (this.filteredNodes.isEmpty()) {
            return;
        }
        for (ObjectTreeNode objectTreeNode : this.filteredNodes) {
            if (objectTreeNode.originalIndex > this.getChildCount()) {
                this.add(objectTreeNode);
                continue;
            }
            this.insert(objectTreeNode, objectTreeNode.originalIndex);
        }
        this.filteredNodes.clear();
    }

    public String displayString() {
        return this.nodeType + ": " + this.getName();
    }

    public String getLocationInfo() {
        if (this.isSchemaNode()) {
            return this.getDbObject().toString();
        }
        if (this.isCatalogNode()) {
            return this.getName();
        }
        String string = "";
        if (this.getDbObject() != null && !this.isFkTable()) {
            string = SqlUtil.removeObjectQuotes(this.getDbObject().getObjectName());
        }
        for (ObjectTreeNode objectTreeNode = this.getParent(); objectTreeNode != null; objectTreeNode = objectTreeNode.getParent()) {
            if (objectTreeNode.getDbObject() == null) continue;
            String string2 = SqlUtil.removeObjectQuotes(objectTreeNode.getDbObject().getObjectName());
            string = string.isEmpty() ? string2 : string2 + "." + string;
        }
        return string;
    }

    private boolean isFkTable() {
        if (this.getParent() == null) {
            return false;
        }
        String string = this.getParent().getType();
        return "fk-definition".equals(string) || "referenced-fk-list".equals(string) || "referencing-fk-list".equals(string);
    }

    public boolean loadChildren(WbConnection wbConnection, TreeLoader treeLoader) {
        return false;
    }
}

