/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects.objecttree;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import workbench.db.BaseObjectType;
import workbench.db.DbObject;
import workbench.db.PackageDefinition;
import workbench.db.ProcedureDefinition;
import workbench.db.ProcedureReader;
import workbench.db.ReaderFactory;
import workbench.db.WbConnection;
import workbench.gui.dbobjects.objecttree.DbObjectTreeModel;
import workbench.gui.dbobjects.objecttree.ObjectTreeNode;
import workbench.gui.dbobjects.objecttree.TreeLoader;
import workbench.resource.ResourceMgr;

public class ProcedureTreeLoader {
    public void loadProcedures(ObjectTreeNode objectTreeNode, DbObjectTreeModel dbObjectTreeModel, WbConnection wbConnection, TreeLoader treeLoader) throws SQLException {
        Object object;
        if (objectTreeNode == null) {
            return;
        }
        ProcedureReader procedureReader = ReaderFactory.getProcedureReader(wbConnection.getMetadata());
        ObjectTreeNode objectTreeNode2 = objectTreeNode.getParent();
        String string = objectTreeNode2.getName();
        String string2 = null;
        ObjectTreeNode objectTreeNode3 = objectTreeNode2.getParent();
        if (objectTreeNode3 != null && objectTreeNode3.isCatalogNode()) {
            string2 = objectTreeNode3.getName();
        }
        List<ProcedureDefinition> list = procedureReader.getProcedureList(string2, string, null);
        Map<String, List<ProcedureDefinition>> map = this.getPackageProcedures(list);
        for (Map.Entry<String, List<ProcedureDefinition>> iterator : map.entrySet()) {
            PackageDefinition packageDefinition = new PackageDefinition(string, iterator.getKey());
            object = new ObjectTreeNode(packageDefinition);
            ((ObjectTreeNode)object).setNodeType("package");
            ((DefaultMutableTreeNode)object).setAllowsChildren(true);
            for (Object object2 : iterator.getValue()) {
                Serializable serializable = new ObjectTreeNode((DbObject)object2);
                this.addParameterNode((ObjectTreeNode)serializable);
                ((ObjectTreeNode)serializable).setChildrenLoaded(false);
                ((DefaultMutableTreeNode)object).add((MutableTreeNode)((Object)serializable));
            }
            ((ObjectTreeNode)object).setChildrenLoaded(true);
            treeLoader.addDependencyNodes((ObjectTreeNode)object);
            objectTreeNode.add((MutableTreeNode)object);
        }
        Map<String, List<ProcedureDefinition>> map2 = this.getTypeMethods(list);
        for (Map.Entry entry : map2.entrySet()) {
            object = new BaseObjectType(string, (String)entry.getKey());
            ObjectTreeNode objectTreeNode4 = new ObjectTreeNode((DbObject)object);
            objectTreeNode4.setAllowsChildren(true);
            for (Serializable serializable : (List)entry.getValue()) {
                ObjectTreeNode objectTreeNode5 = new ObjectTreeNode((DbObject)((Object)serializable));
                this.addParameterNode(objectTreeNode5);
                objectTreeNode5.setChildrenLoaded(true);
                objectTreeNode4.add(objectTreeNode5);
            }
            objectTreeNode4.setChildrenLoaded(true);
            treeLoader.addDependencyNodes(objectTreeNode4);
            objectTreeNode.add(objectTreeNode4);
        }
        for (ProcedureDefinition procedureDefinition : list) {
            if (procedureDefinition.isPackageProcedure() || procedureDefinition.isOracleObjectType()) continue;
            object = new ObjectTreeNode(procedureDefinition);
            this.addParameterNode((ObjectTreeNode)object);
            treeLoader.addDependencyNodes((ObjectTreeNode)object);
            ((ObjectTreeNode)object).setChildrenLoaded(true);
            objectTreeNode.add((MutableTreeNode)object);
        }
        objectTreeNode.setChildrenLoaded(true);
        dbObjectTreeModel.nodeStructureChanged(objectTreeNode);
    }

    private void addParameterNode(ObjectTreeNode objectTreeNode) {
        ObjectTreeNode objectTreeNode2 = new ObjectTreeNode(ResourceMgr.getString("TxtDbExpProcParams"), "parameter-list");
        objectTreeNode.setAllowsChildren(true);
        objectTreeNode.add(objectTreeNode2);
    }

    private Map<String, List<ProcedureDefinition>> getTypeMethods(List<ProcedureDefinition> list) {
        TreeMap<String, List<ProcedureDefinition>> treeMap = new TreeMap<String, List<ProcedureDefinition>>();
        for (ProcedureDefinition procedureDefinition : list) {
            if (!procedureDefinition.isOracleObjectType()) continue;
            ArrayList<ProcedureDefinition> arrayList = (ArrayList<ProcedureDefinition>)treeMap.get(procedureDefinition.getPackageName());
            if (arrayList == null) {
                arrayList = new ArrayList<ProcedureDefinition>();
                treeMap.put(procedureDefinition.getPackageName(), arrayList);
            }
            arrayList.add(procedureDefinition);
        }
        return treeMap;
    }

    private Map<String, List<ProcedureDefinition>> getPackageProcedures(List<ProcedureDefinition> list) {
        TreeMap<String, List<ProcedureDefinition>> treeMap = new TreeMap<String, List<ProcedureDefinition>>();
        for (ProcedureDefinition procedureDefinition : list) {
            if (!procedureDefinition.isPackageProcedure()) continue;
            ArrayList<ProcedureDefinition> arrayList = (ArrayList<ProcedureDefinition>)treeMap.get(procedureDefinition.getPackageName());
            if (arrayList == null) {
                arrayList = new ArrayList<ProcedureDefinition>();
                treeMap.put(procedureDefinition.getPackageName(), arrayList);
            }
            arrayList.add(procedureDefinition);
        }
        return treeMap;
    }
}

