/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects.objecttree;

import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import workbench.db.ColumnIdentifier;
import workbench.db.DbObject;
import workbench.db.ObjectScripter;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.gui.dbobjects.objecttree.ObjectTreeNode;
import workbench.gui.dbobjects.objecttree.ObjectTreeTransferable;
import workbench.gui.sql.SqlPanel;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.util.CollectionUtil;

public class ResultTabDropHandler
implements DropTargetListener {
    private SqlPanel sqlPanel;
    private final DropTarget target1;
    private final DropTarget target2;

    public ResultTabDropHandler(SqlPanel sqlPanel, JComponent jComponent, JComponent jComponent2) {
        this.sqlPanel = sqlPanel;
        this.target1 = new DropTarget(jComponent, 1, this);
        this.target2 = new DropTarget(jComponent2, 1, this);
    }

    public void handleDrop(ObjectTreeTransferable objectTreeTransferable) {
        if (this.sqlPanel.isConnectionBusy()) {
            this.sqlPanel.appendToLog(ResourceMgr.getString("ErrConnectionBusy"));
            return;
        }
        if (objectTreeTransferable == null) {
            return;
        }
        ObjectTreeNode[] objectTreeNodeArray = objectTreeTransferable.getSelectedNodes();
        if (objectTreeNodeArray == null) {
            return;
        }
        DbObject dbObject = null;
        List<ColumnIdentifier> list = this.getSelectedColumns(objectTreeNodeArray);
        if (CollectionUtil.isNonEmpty(list)) {
            dbObject = objectTreeNodeArray[0].getParent().getParent().getDbObject();
        } else if (objectTreeNodeArray.length == 1) {
            dbObject = objectTreeNodeArray[0].getDbObject();
        }
        if (dbObject instanceof TableIdentifier) {
            this.sqlPanel.showData((TableIdentifier)dbObject, list);
        } else {
            this.showSource(dbObject);
        }
    }

    private void showSource(DbObject dbObject) {
        if (dbObject == null) {
            return;
        }
        WbConnection wbConnection = this.sqlPanel.getConnection();
        if (wbConnection == null) {
            return;
        }
        ObjectScripter objectScripter = new ObjectScripter(CollectionUtil.arrayList(dbObject), wbConnection);
        objectScripter.setEndTransaction(true);
        objectScripter.setShowPackageProcedureOnly(true);
        objectScripter.setIncludeForeignKeys(false);
        objectScripter.setIncludeGrants(false);
        String string = objectScripter.getScript();
        this.sqlPanel.showLogMessage(string);
    }

    private List<ColumnIdentifier> getSelectedColumns(ObjectTreeNode[] objectTreeNodeArray) {
        if (objectTreeNodeArray == null) {
            return null;
        }
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>(objectTreeNodeArray.length);
        for (ObjectTreeNode objectTreeNode : objectTreeNodeArray) {
            DbObject dbObject = objectTreeNode.getDbObject();
            if (!(dbObject instanceof ColumnIdentifier)) {
                return null;
            }
            arrayList.add((ColumnIdentifier)dbObject);
        }
        return arrayList;
    }

    private boolean canHandleSelection(ObjectTreeNode[] objectTreeNodeArray) {
        if (objectTreeNodeArray == null) {
            return false;
        }
        if (objectTreeNodeArray.length == 1) {
            return true;
        }
        ObjectTreeNode objectTreeNode = objectTreeNodeArray[0].getParent();
        for (ObjectTreeNode objectTreeNode2 : objectTreeNodeArray) {
            DbObject dbObject = objectTreeNode2.getDbObject();
            if (!(dbObject instanceof ColumnIdentifier)) {
                return false;
            }
            if (objectTreeNode2.getParent() == objectTreeNode) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        if (this.target1 != null) {
            this.target1.removeDropTargetListener(this);
        }
        if (this.target2 != null) {
            this.target2.removeDropTargetListener(this);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (this.sqlPanel.isConnectionBusy()) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        Transferable transferable = dropTargetDragEvent.getTransferable();
        if (transferable.isDataFlavorSupported(ObjectTreeTransferable.DATA_FLAVOR)) {
            try {
                ObjectTreeTransferable objectTreeTransferable = (ObjectTreeTransferable)transferable.getTransferData(ObjectTreeTransferable.DATA_FLAVOR);
                ObjectTreeNode[] objectTreeNodeArray = objectTreeTransferable.getSelectedNodes();
                if (this.canHandleSelection(objectTreeNodeArray)) {
                    dropTargetDragEvent.acceptDrag(1);
                    return;
                }
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error processing drag event", exception);
            }
        }
        dropTargetDragEvent.rejectDrag();
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (transferable.isDataFlavorSupported(ObjectTreeTransferable.DATA_FLAVOR)) {
                ObjectTreeTransferable objectTreeTransferable = (ObjectTreeTransferable)transferable.getTransferData(ObjectTreeTransferable.DATA_FLAVOR);
                this.handleDrop(objectTreeTransferable);
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error processing drop event", exception);
            dropTargetDropEvent.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }
}

