/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects.objecttree;

import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import workbench.db.CatalogChanger;
import workbench.db.CatalogIdentifier;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.DbSettings;
import workbench.db.DependencyNode;
import workbench.db.IndexColumn;
import workbench.db.IndexDefinition;
import workbench.db.JdbcUtils;
import workbench.db.ObjectNameSorter;
import workbench.db.PartitionLister;
import workbench.db.ProcedureDefinition;
import workbench.db.SchemaIdentifier;
import workbench.db.SubPartitionState;
import workbench.db.TableDefinition;
import workbench.db.TableDependency;
import workbench.db.TableIdentifier;
import workbench.db.TablePartition;
import workbench.db.TriggerDefinition;
import workbench.db.TriggerReader;
import workbench.db.TriggerReaderFactory;
import workbench.db.WbConnection;
import workbench.db.dependency.DependencyReader;
import workbench.db.dependency.DependencyReaderFactory;
import workbench.gui.dbobjects.IsolationLevelChanger;
import workbench.gui.dbobjects.objecttree.CatalogObjectTypesNode;
import workbench.gui.dbobjects.objecttree.DbObjectSorter;
import workbench.gui.dbobjects.objecttree.DbObjectTreeModel;
import workbench.gui.dbobjects.objecttree.DbTreeSettings;
import workbench.gui.dbobjects.objecttree.GlobalTreeNode;
import workbench.gui.dbobjects.objecttree.ObjectTreeNode;
import workbench.gui.dbobjects.objecttree.ProcedureTreeLoader;
import workbench.gui.dbobjects.objecttree.RootNode;
import workbench.gui.dbobjects.objecttree.vertica.ProjectionListNode;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.DbExplorerSettings;
import workbench.resource.ResourceMgr;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class TreeLoader {
    public static final String TYPE_ROOT = "database";
    public static final String TYPE_SCHEMA = "schema";
    public static final String TYPE_CATALOG = "catalog";
    public static final String TYPE_GLOBAL = "global";
    public static final String TYPE_TABLE = "table";
    public static final String TYPE_VIEW = "view";
    public static final String TYPE_COLUMN_LIST = "column-list";
    public static final String TYPE_PARAMETER_LIST = "parameter-list";
    public static final String TYPE_INDEX_LIST = "index-list";
    public static final String TYPE_PROJECTION_LIST = "projection-list";
    public static final String TYPE_PROJECTION_BUDDIES = "projection-buddies";
    public static final String TYPE_PROJECTION_COLUMNS = "projection-columns";
    public static final String TYPE_DEPENDENCY_USED = "dep-used";
    public static final String TYPE_DEPENDENCY_USING = "dep-using";
    public static final String TYPE_PARTITIONS_NODE = "table-partitions-node";
    public static final String TYPE_FK_LIST = "referenced-fk-list";
    public static final String TYPE_REF_LIST = "referencing-fk-list";
    public static final String TYPE_IDX_COL = "index-column";
    public static final String TYPE_DBO_TYPE_NODE = "dbobject-type";
    public static final String TYPE_FK_DEF = "fk-definition";
    public static final String TYPE_TRIGGERS_NODE = "table-trigger";
    public static final String TYPE_FUNCTION = "function";
    public static final String TYPE_PROCEDURES_NODE = "procedures";
    public static final String TYPE_PROC_PARAMETER = "parameter";
    public static final String TYPE_PACKAGE_NODE = "package";
    public static final String TYPE_PROJECTION_NODE = "projection";
    public static final String TYPE_PROJECTION_COL_NODE = "projection-column";
    public static final String TYPE_PROJECTION_BUDDY = "projection-buddy";
    private WbConnection connection;
    private DbObjectTreeModel model;
    private ObjectTreeNode root;
    private GlobalTreeNode globalNode;
    private Collection<String> availableTypes;
    private ProcedureTreeLoader procLoader;
    private DependencyReader dependencyLoader;
    private PartitionLister partitionLister;
    private final Set<String> typesToShow = CollectionUtil.caseInsensitiveSet();
    private IsolationLevelChanger levelChanger = new IsolationLevelChanger();

    public TreeLoader() {
        this.root = new RootNode();
        this.model = new DbObjectTreeModel(this.root);
    }

    public void setConnection(WbConnection wbConnection) {
        this.connection = wbConnection;
        this.clear();
        if (this.connection != null) {
            this.availableTypes = this.connection.getMetadata().getObjectTypes();
            LogMgr.logDebug(new CallerInfo(){}, "Using object types: " + this.availableTypes);
            Set<String> set = this.connection.getDbSettings().getGlobalObjectTypes();
            if (!set.isEmpty()) {
                LogMgr.logDebug(new CallerInfo(){}, "Using global object types: " + set);
            }
            this.availableTypes.removeAll(set);
        }
        if (DbExplorerSettings.getShowTriggerPanel()) {
            this.availableTypes.add("TRIGGER");
        }
        this.procLoader = new ProcedureTreeLoader();
        this.dependencyLoader = DependencyReaderFactory.getReader(this.connection);
        this.partitionLister = PartitionLister.Factory.createReader(this.connection);
    }

    private void removeAllChildren(ObjectTreeNode objectTreeNode) {
        if (objectTreeNode == null) {
            return;
        }
        int n = objectTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            ObjectTreeNode objectTreeNode2 = objectTreeNode.getChildAt(i);
            this.removeAllChildren(objectTreeNode2);
        }
        objectTreeNode.removeAllChildren();
    }

    public void setSelectedTypes(List<String> list) {
        this.typesToShow.clear();
        if (list != null) {
            this.typesToShow.addAll(list);
        }
        if (this.globalNode != null && DbTreeSettings.applyTypeFilterForGlobalObjects()) {
            this.globalNode.setTypesToShow(this.typesToShow);
        }
        LogMgr.logDebug(new CallerInfo(){}, "Selected object types: " + this.typesToShow);
    }

    private String getRootName() {
        if (this.connection == null || this.connection.isClosed() || this.connection.getDbSettings() == null) {
            return ResourceMgr.getString("TxtDbExplorerTables");
        }
        if (this.connection.getDbSettings().supportsCatalogs()) {
            return this.getDatabaseLabel();
        }
        if (this.connection.getDbSettings().supportsSchemas()) {
            return ResourceMgr.getString("LblSchemas");
        }
        return ResourceMgr.getString("TxtDbExplorerTables");
    }

    private String getDatabaseLabel() {
        if (this.connection.getMetadata().getCatalogTerm().toLowerCase().equals(TYPE_ROOT)) {
            return ResourceMgr.getString("LblDatabases");
        }
        return ResourceMgr.getString("LblCatalogs");
    }

    private void setRootLabel(String string) {
        String string2 = this.root.getName();
        if (StringUtil.stringsAreNotEqual(string2, string)) {
            this.root.setNameAndType(string, TYPE_ROOT);
            this.model.nodeChanged(this.root);
        }
    }

    public void clear() {
        this.removeAllChildren(this.root);
        this.root.setNameAndType(this.getRootName(), TYPE_ROOT);
        this.model.nodeStructureChanged(this.root);
    }

    public DbObjectTreeModel getModel() {
        return this.model;
    }

    public void load() throws SQLException {
        boolean bl = false;
        CallerInfo callerInfo = new CallerInfo(){};
        if (this.connection == null) {
            LogMgr.logWarning(callerInfo, "TreeLoader.load() called without connection!", new Exception("Backtrace"));
            return;
        }
        boolean bl2 = this.connection.setBusy(true);
        if (bl2) {
            LogMgr.logError(callerInfo, "TreeLoader.load() called even though connection is busy!", new Exception("Backtrace"));
        }
        Savepoint savepoint = null;
        try {
            if (this.connection.getDbSettings().useSavePointForDML() && !this.connection.getAutoCommit()) {
                savepoint = this.connection.setSavepoint(callerInfo);
            }
            if (CollectionUtil.isNonEmpty(this.connection.getDbSettings().getGlobalObjectTypes())) {
                if (DbTreeSettings.applyTypeFilterForGlobalObjects()) {
                    this.globalNode = new GlobalTreeNode(this.typesToShow);
                } else {
                    Set<String> set = this.connection.getDbSettings().getGlobalObjectTypes();
                    this.globalNode = new GlobalTreeNode(set);
                }
                this.globalNode.loadChildren(this.connection, this);
                this.root.add(this.globalNode);
            }
            if (this.connection.getDbSettings().supportsCatalogs()) {
                bl = this.loadCatalogs(this.root);
            }
            if (bl) {
                this.setRootLabel(this.getDatabaseLabel());
            } else if (this.connection.getDbSettings().supportsSchemas()) {
                this.setRootLabel(ResourceMgr.getString("LblSchemas"));
                bl = this.loadSchemas(this.root);
            }
            if (!bl) {
                this.addTypeNodes(this.root);
                this.root.setChildrenLoaded(true);
                this.model.nodeStructureChanged(this.root);
            }
            this.connection.releaseSavepoint(savepoint, callerInfo);
        }
        catch (SQLException sQLException) {
            this.connection.rollback(savepoint, callerInfo);
            throw sQLException;
        }
        finally {
            this.connection.setBusy(bl2);
            this.endTransaction(callerInfo);
        }
    }

    public void endTransaction(CallerInfo callerInfo) {
        if (this.connection == null) {
            return;
        }
        if (this.connection.getDbSettings().selectStartsTransaction() && !this.connection.getAutoCommit()) {
            if (DbTreeSettings.useTabConnection() || this.connection.isShared()) {
                this.connection.endReadOnlyTransaction(callerInfo);
            } else {
                LogMgr.logDebug(new CallerInfo(){}, "Ending DbTree transaction using rollback on connection: " + this.connection.getId());
                this.connection.rollbackSilently();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadSchemas(ObjectTreeNode objectTreeNode) throws SQLException {
        boolean bl = objectTreeNode.getType().equals(TYPE_CATALOG);
        CatalogChanger catalogChanger = null;
        boolean bl2 = false;
        boolean bl3 = this.connection.getMetadata().supportsCatalogForGetSchemas();
        String string = null;
        String string2 = null;
        if (bl) {
            catalogChanger = new CatalogChanger();
            catalogChanger.setFireEvents(false);
            string2 = this.connection.getMetadata().getCurrentCatalog();
            string = objectTreeNode.getName();
        }
        CallerInfo callerInfo = new CallerInfo(){};
        try {
            this.levelChanger.changeIsolationLevel(this.connection);
            if (bl && this.connection.getDbSettings().changeCatalogToRetrieveSchemas() && !bl3) {
                LogMgr.logDebug(callerInfo, "Setting current catalog to: " + string);
                catalogChanger.setCurrentCatalog(this.connection, string);
                bl2 = true;
            }
            if (string != null) {
                LogMgr.logDebug(callerInfo, "Loading schemas for catalog: " + string);
            }
            List<String> list = this.connection.getMetadata().getSchemas(this.connection.getSchemaFilter(), string);
            LogMgr.logDebug(callerInfo, "Loaded " + list.size() + " schemas. Currently selected types: " + this.typesToShow);
            if (CollectionUtil.isEmpty(list)) {
                boolean bl4 = false;
                return bl4;
            }
            for (String string3 : list) {
                ObjectTreeNode objectTreeNode2 = new ObjectTreeNode(string3, TYPE_SCHEMA);
                objectTreeNode2.setAllowsChildren(true);
                SchemaIdentifier schemaIdentifier = new SchemaIdentifier(string3);
                if (bl) {
                    schemaIdentifier.setCatalog(string);
                }
                objectTreeNode2.setUserObject(schemaIdentifier);
                objectTreeNode.add(objectTreeNode2);
                this.addTypeNodes(objectTreeNode2);
            }
        }
        finally {
            this.levelChanger.restoreIsolationLevel(this.connection);
            if (bl2) {
                LogMgr.logDebug(callerInfo, "Resetting current catalog to: " + string2);
                catalogChanger.setCurrentCatalog(this.connection, string2);
            }
        }
        objectTreeNode.setChildrenLoaded(true);
        this.model.nodeStructureChanged(objectTreeNode);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadCatalogs(ObjectTreeNode objectTreeNode) throws SQLException {
        if (objectTreeNode.getChildCount() > 0) {
            LogMgr.logWarning(new CallerInfo(){}, "Loading catalogs to an already populated parent node: " + objectTreeNode, new Exception("Backtrack"));
        }
        boolean bl = this.connection.getMetadata().supportsCatalogLevelObjects();
        try {
            this.levelChanger.changeIsolationLevel(this.connection);
            List<String> list = this.connection.getMetadata().getCatalogInformation(this.connection.getCatalogFilter());
            for (String string : list) {
                Set<String> set;
                ObjectTreeNode objectTreeNode2 = new ObjectTreeNode(string, TYPE_CATALOG);
                objectTreeNode2.setAllowsChildren(true);
                CatalogIdentifier catalogIdentifier = new CatalogIdentifier(string);
                catalogIdentifier.setTypeName(this.connection.getMetadata().getCatalogTerm());
                objectTreeNode2.setUserObject(catalogIdentifier);
                objectTreeNode.add(objectTreeNode2);
                if (bl && !(set = this.connection.getDbSettings().getCatalogLevelTypes()).isEmpty()) {
                    CatalogObjectTypesNode catalogObjectTypesNode = new CatalogObjectTypesNode(set);
                    objectTreeNode2.add(catalogObjectTypesNode);
                    catalogObjectTypesNode.loadChildren(this.connection, this);
                }
                if (this.connection.getDbSettings().supportsSchemas()) continue;
                this.addTypeNodes(objectTreeNode2);
            }
            this.model.nodeStructureChanged(objectTreeNode);
            boolean bl2 = list.size() > 0;
            return bl2;
        }
        finally {
            this.levelChanger.restoreIsolationLevel(this.connection);
        }
    }

    private void addTypeNodes(ObjectTreeNode objectTreeNode) {
        Object object;
        if (objectTreeNode == null) {
            return;
        }
        for (String object2 : this.availableTypes) {
            if (object2.equalsIgnoreCase("TRIGGER") || object2.equalsIgnoreCase("PROCEDURE") || !this.typesToShow.isEmpty() && !this.typesToShow.contains(object2)) continue;
            ObjectTreeNode objectTreeNode2 = new ObjectTreeNode(object2, TYPE_DBO_TYPE_NODE);
            objectTreeNode2.setAllowsChildren(true);
            objectTreeNode.add(objectTreeNode2);
        }
        if (this.typesToShow.isEmpty() || this.typesToShow.contains("PROCEDURE")) {
            object = ResourceMgr.getString("TxtDbExplorerProcs");
            if (this.connection.getMetadata().isPostgres() && !JdbcUtils.hasMinimumServerVersion(this.connection, "11.0")) {
                object = ResourceMgr.getString("TxtDbExplorerFuncs");
            }
            ObjectTreeNode objectTreeNode3 = new ObjectTreeNode((String)object, TYPE_PROCEDURES_NODE);
            objectTreeNode3.setAllowsChildren(true);
            objectTreeNode3.setChildrenLoaded(false);
            objectTreeNode.add(objectTreeNode3);
        }
        if (this.typesToShow.isEmpty() || this.typesToShow.contains("TRIGGER")) {
            object = new ObjectTreeNode(ResourceMgr.getString("TxtDbExplorerTriggers"), TYPE_TRIGGERS_NODE);
            ((DefaultMutableTreeNode)object).setAllowsChildren(true);
            objectTreeNode.add((MutableTreeNode)object);
        }
        objectTreeNode.setChildrenLoaded(true);
    }

    private void loadTypesForSchema(ObjectTreeNode objectTreeNode) {
        if (objectTreeNode == null) {
            return;
        }
        if (!objectTreeNode.isSchemaNode()) {
            return;
        }
        int n = objectTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            ObjectTreeNode objectTreeNode2 = objectTreeNode.getChildAt(i);
            try {
                objectTreeNode2.removeAllChildren();
                this.loadObjectsForTypeNode(objectTreeNode2);
                continue;
            }
            catch (SQLException sQLException) {
                LogMgr.logError(new CallerInfo(){}, "Could not load schema nodes for " + objectTreeNode2.displayString(), sQLException);
            }
        }
    }

    public void reloadSchema(ObjectTreeNode objectTreeNode) throws SQLException {
        if (objectTreeNode == null) {
            return;
        }
        if (!objectTreeNode.isSchemaNode()) {
            return;
        }
        try {
            objectTreeNode.removeAllChildren();
            this.addTypeNodes(objectTreeNode);
            this.loadNodeObjects(objectTreeNode);
            this.endTransaction(new CallerInfo(){});
        }
        catch (Throwable throwable) {
            this.endTransaction(new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
    }

    public void loadNodeObjects(ObjectTreeNode objectTreeNode) throws SQLException {
        if (objectTreeNode == null) {
            return;
        }
        int n = objectTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            ObjectTreeNode objectTreeNode2 = objectTreeNode.getChildAt(i);
            if (objectTreeNode2.isLoaded()) continue;
            this.loadObjectsForTypeNode(objectTreeNode2);
        }
        objectTreeNode.setChildrenLoaded(true);
        this.model.nodeStructureChanged(objectTreeNode);
        this.model.nodeChanged(objectTreeNode);
    }

    public void reloadTableNode(ObjectTreeNode objectTreeNode) throws SQLException {
        DbObject dbObject = objectTreeNode.getDbObject();
        if (!(dbObject instanceof TableIdentifier)) {
            return;
        }
        objectTreeNode.removeAllChildren();
        this.addColumnsNode(objectTreeNode);
        this.addTableSubNodes(objectTreeNode);
        int n = objectTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            ObjectTreeNode objectTreeNode2 = objectTreeNode.getChildAt(i);
            this.loadChildren(objectTreeNode2);
        }
        objectTreeNode.setChildrenLoaded(true);
        this.model.nodeStructureChanged(objectTreeNode);
    }

    public void reloadNode(ObjectTreeNode objectTreeNode) throws SQLException {
        if (objectTreeNode == null) {
            return;
        }
        objectTreeNode.removeAllChildren();
        this.loadChildren(objectTreeNode);
        objectTreeNode.setChildrenLoaded(true);
        this.model.nodeStructureChanged(objectTreeNode);
    }

    private TableIdentifier getParentInfo(ObjectTreeNode objectTreeNode) {
        Object object;
        ObjectTreeNode objectTreeNode2 = objectTreeNode.getParent();
        if (objectTreeNode2 == null) {
            return new TableIdentifier(null, null, "$wb-dummy$", false);
        }
        String string = null;
        String string2 = null;
        if (objectTreeNode2.getDbObject() != null) {
            object = objectTreeNode2.getDbObject();
            string = object.getSchema();
            string2 = object.getCatalog();
        } else if (objectTreeNode2.isCatalogNode()) {
            string2 = objectTreeNode2.getName();
        } else if (objectTreeNode2.isSchemaNode()) {
            string = objectTreeNode2.getName();
        }
        if (this.connection.getDbSettings().supportsCatalogs() && this.connection.getDbSettings().supportsSchemas() && string2 == null && (object = objectTreeNode2.getParent()) != null && ((ObjectTreeNode)object).getType().equalsIgnoreCase(TYPE_CATALOG)) {
            string2 = ((ObjectTreeNode)object).getName();
        }
        return new TableIdentifier(string2, string, "$wb-dummy$", false);
    }

    public void loadObjectsForTypeNode(ObjectTreeNode objectTreeNode) throws SQLException {
        if (objectTreeNode == null) {
            return;
        }
        if (objectTreeNode.getType().equalsIgnoreCase(TYPE_TRIGGERS_NODE)) {
            this.loadTriggers(objectTreeNode);
            return;
        }
        if (objectTreeNode.getType().equalsIgnoreCase(TYPE_PROCEDURES_NODE)) {
            this.loadProcedures(objectTreeNode);
            return;
        }
        TableIdentifier tableIdentifier = this.getParentInfo(objectTreeNode);
        String string = tableIdentifier.getRawSchema();
        String string2 = tableIdentifier.getRawCatalog();
        boolean bl = true;
        List<TableIdentifier> list = this.connection.getMetadata().getObjectList(null, string2, string, new String[]{objectTreeNode.getName()});
        ObjectNameSorter objectNameSorter = new ObjectNameSorter();
        objectNameSorter.setUseNaturalSort(DbTreeSettings.useNaturalSort());
        list.sort(objectNameSorter);
        for (TableIdentifier tableIdentifier2 : list) {
            ObjectTreeNode objectTreeNode2 = new ObjectTreeNode(tableIdentifier2);
            objectTreeNode2.setAllowsChildren(false);
            if (this.hasColumns(tableIdentifier2)) {
                objectTreeNode2.setAllowsChildren(true);
                this.addColumnsNode(objectTreeNode2);
            }
            if (this.isTable(tableIdentifier2)) {
                this.addTableSubNodes(objectTreeNode2);
                this.connection.getObjectCache().addTable(new TableDefinition(tableIdentifier2));
            } else if (this.hasIndexes(objectTreeNode2)) {
                objectTreeNode2.setAllowsChildren(true);
                this.addIndexNode(objectTreeNode2);
                this.addDependencyNodes(objectTreeNode2);
            } else {
                this.addDependencyNodes(objectTreeNode2);
            }
            if (this.connection.getMetadata().isViewType(objectTreeNode.getName()) && !tableIdentifier2.getType().equals("MATERIALIZED VIEW")) {
                this.addViewTriggerNode(objectTreeNode2);
                this.connection.getObjectCache().addTable(new TableDefinition(tableIdentifier2));
            }
            objectTreeNode.add(objectTreeNode2);
            objectTreeNode2.setChildrenLoaded(bl);
        }
        objectTreeNode.setChildrenLoaded(true);
        this.model.nodeStructureChanged(objectTreeNode);
        this.model.nodeChanged(objectTreeNode);
    }

    private boolean supportsUsedByDependencies(ObjectTreeNode objectTreeNode) {
        if (this.dependencyLoader == null) {
            return false;
        }
        if (objectTreeNode == null) {
            return false;
        }
        if (objectTreeNode.getDbObject() == null) {
            return false;
        }
        return this.dependencyLoader.supportsUsedByDependency(objectTreeNode.getDbObject().getObjectType());
    }

    private boolean supportsIsUsingDependencies(ObjectTreeNode objectTreeNode) {
        if (this.dependencyLoader == null) {
            return false;
        }
        if (objectTreeNode == null) {
            return false;
        }
        if (objectTreeNode.getDbObject() == null) {
            return false;
        }
        return this.dependencyLoader.supportsIsUsingDependency(objectTreeNode.getDbObject().getObjectType());
    }

    private boolean hasIndexes(ObjectTreeNode objectTreeNode) {
        if (objectTreeNode == null) {
            return false;
        }
        DbObject dbObject = objectTreeNode.getDbObject();
        if (dbObject == null) {
            return false;
        }
        DbSettings dbSettings = this.connection.getDbSettings();
        if (dbSettings.isViewType(dbObject.getObjectType()) && dbSettings.supportsIndexedViews()) {
            return true;
        }
        return dbSettings.isMview(dbObject.getObjectType());
    }

    private void addViewTriggerNode(ObjectTreeNode objectTreeNode) {
        TriggerReader triggerReader = TriggerReaderFactory.createReader(this.connection);
        if (triggerReader == null) {
            return;
        }
        if (triggerReader.supportsTriggersOnViews()) {
            ObjectTreeNode objectTreeNode2 = new ObjectTreeNode(ResourceMgr.getString("TxtDbExplorerTriggers"), TYPE_TRIGGERS_NODE);
            objectTreeNode2.setAllowsChildren(true);
            objectTreeNode.add(objectTreeNode2);
        }
    }

    private void addColumnsNode(ObjectTreeNode objectTreeNode) {
        ObjectTreeNode objectTreeNode2 = new ObjectTreeNode(ResourceMgr.getString("TxtDbExplorerTableDefinition"), TYPE_COLUMN_LIST);
        objectTreeNode2.setAllowsChildren(true);
        objectTreeNode.add(objectTreeNode2);
    }

    public boolean addPartitionsNode(ObjectTreeNode objectTreeNode) {
        if (objectTreeNode == null) {
            return false;
        }
        if (this.partitionLister == null) {
            return false;
        }
        objectTreeNode.setAllowsChildren(true);
        ObjectTreeNode objectTreeNode2 = new ObjectTreeNode("Partitions", TYPE_PARTITIONS_NODE);
        objectTreeNode.add(objectTreeNode2);
        return true;
    }

    public boolean addDependencyNodes(ObjectTreeNode objectTreeNode) {
        ObjectTreeNode objectTreeNode2;
        if (objectTreeNode == null) {
            return false;
        }
        boolean bl = false;
        if (this.supportsIsUsingDependencies(objectTreeNode)) {
            objectTreeNode.setAllowsChildren(true);
            objectTreeNode2 = new ObjectTreeNode(ResourceMgr.getString("TxtDepsUses"), TYPE_DEPENDENCY_USING);
            objectTreeNode2.setAllowsChildren(true);
            objectTreeNode.add(objectTreeNode2);
            bl = true;
        }
        if (this.supportsUsedByDependencies(objectTreeNode)) {
            objectTreeNode.setAllowsChildren(true);
            objectTreeNode2 = new ObjectTreeNode(ResourceMgr.getString("TxtDepsUsedBy"), TYPE_DEPENDENCY_USED);
            objectTreeNode2.setAllowsChildren(true);
            objectTreeNode.add(objectTreeNode2);
            bl = true;
        }
        return bl;
    }

    private void addIndexNode(ObjectTreeNode objectTreeNode) {
        ObjectTreeNode objectTreeNode2 = null;
        if (this.connection.getMetadata().isVertica()) {
            objectTreeNode2 = new ProjectionListNode();
        } else {
            objectTreeNode2 = new ObjectTreeNode(ResourceMgr.getString("TxtDbExplorerIndexes"), TYPE_INDEX_LIST);
            objectTreeNode2.setAllowsChildren(true);
        }
        objectTreeNode.add(objectTreeNode2);
    }

    private void addTableSubNodes(ObjectTreeNode objectTreeNode) {
        this.addIndexNode(objectTreeNode);
        ObjectTreeNode objectTreeNode2 = new ObjectTreeNode(ResourceMgr.getString("TxtDbExplorerFkColumns"), TYPE_FK_LIST);
        objectTreeNode2.setAllowsChildren(true);
        objectTreeNode.add(objectTreeNode2);
        ObjectTreeNode objectTreeNode3 = new ObjectTreeNode(ResourceMgr.getString("TxtDbExplorerReferencedColumns"), TYPE_REF_LIST);
        objectTreeNode3.setAllowsChildren(true);
        objectTreeNode.add(objectTreeNode3);
        this.addPartitionsNode(objectTreeNode);
        this.addDependencyNodes(objectTreeNode);
        ObjectTreeNode objectTreeNode4 = new ObjectTreeNode(ResourceMgr.getString("TxtDbExplorerTriggers"), TYPE_TRIGGERS_NODE);
        objectTreeNode4.setAllowsChildren(true);
        objectTreeNode.add(objectTreeNode4);
    }

    public void loadProcedures(ObjectTreeNode objectTreeNode) throws SQLException {
        this.procLoader.loadProcedures(objectTreeNode, this.model, this.connection, this);
    }

    public boolean isDependencyNode(ObjectTreeNode objectTreeNode) {
        if (objectTreeNode == null) {
            return false;
        }
        return objectTreeNode.getType().equals(TYPE_DEPENDENCY_USED) || objectTreeNode.getType().equals(TYPE_DEPENDENCY_USING);
    }

    public void loadProcedureParameters(ObjectTreeNode objectTreeNode) {
        if (objectTreeNode == null) {
            return;
        }
        ObjectTreeNode objectTreeNode2 = objectTreeNode.getParent();
        ProcedureDefinition procedureDefinition = (ProcedureDefinition)objectTreeNode2.getDbObject();
        if (procedureDefinition == null) {
            return;
        }
        List<ColumnIdentifier> list = procedureDefinition.getParameters(this.connection);
        for (ColumnIdentifier columnIdentifier : list) {
            String string = columnIdentifier.getArgumentMode();
            ObjectTreeNode objectTreeNode3 = null;
            if (string.equals("RETURN")) {
                objectTreeNode3 = new ObjectTreeNode("RETURNS " + columnIdentifier.getDbmsType(), TYPE_PROC_PARAMETER);
            } else {
                objectTreeNode3 = new ObjectTreeNode(columnIdentifier);
                objectTreeNode3.setNameAndType(columnIdentifier.getColumnName(), TYPE_PROC_PARAMETER);
            }
            objectTreeNode3.setAllowsChildren(false);
            objectTreeNode3.setChildrenLoaded(true);
            objectTreeNode.add(objectTreeNode3);
        }
        objectTreeNode.setChildrenLoaded(true);
        this.model.nodeStructureChanged(objectTreeNode);
    }

    public void loadTriggers(ObjectTreeNode objectTreeNode) throws SQLException {
        if (objectTreeNode == null) {
            return;
        }
        TableIdentifier tableIdentifier = this.getParentInfo(objectTreeNode);
        TriggerReader triggerReader = TriggerReaderFactory.createReader(this.connection);
        List<TriggerDefinition> list = triggerReader.getTriggerList(tableIdentifier.getRawCatalog(), tableIdentifier.getRawSchema(), null);
        DbObjectSorter.sort(list, DbExplorerSettings.useNaturalSort());
        for (TriggerDefinition triggerDefinition : list) {
            ObjectTreeNode objectTreeNode2 = new ObjectTreeNode(triggerDefinition);
            boolean bl = this.supportsIsUsingDependencies(objectTreeNode2) || this.supportsUsedByDependencies(objectTreeNode2);
            objectTreeNode2.setAllowsChildren(bl);
            this.addDependencyNodes(objectTreeNode2);
            objectTreeNode2.setChildrenLoaded(!bl);
            objectTreeNode.add(objectTreeNode2);
        }
        this.model.nodeStructureChanged(objectTreeNode);
        objectTreeNode.setChildrenLoaded(true);
    }

    public void loadTableTriggers(DbObject dbObject, ObjectTreeNode objectTreeNode) throws SQLException {
        if (objectTreeNode == null) {
            return;
        }
        if (dbObject == null) {
            objectTreeNode.setAllowsChildren(false);
            return;
        }
        TriggerReader triggerReader = TriggerReaderFactory.createReader(this.connection);
        TableIdentifier tableIdentifier = (TableIdentifier)dbObject;
        List<TriggerDefinition> list = triggerReader.getTriggerList(tableIdentifier.getRawCatalog(), tableIdentifier.getRawSchema(), tableIdentifier.getRawTableName());
        DbObjectSorter.sort(list, DbExplorerSettings.useNaturalSort());
        for (TriggerDefinition triggerDefinition : list) {
            ObjectTreeNode objectTreeNode2 = new ObjectTreeNode(triggerDefinition);
            objectTreeNode2.setAllowsChildren(false);
            objectTreeNode2.setChildrenLoaded(true);
            objectTreeNode.add(objectTreeNode2);
        }
        this.model.nodeStructureChanged(objectTreeNode);
        objectTreeNode.setChildrenLoaded(true);
    }

    public void loadTableIndexes(DbObject dbObject, ObjectTreeNode objectTreeNode) throws SQLException {
        if (objectTreeNode == null) {
            return;
        }
        if (dbObject == null) {
            objectTreeNode.setAllowsChildren(false);
            return;
        }
        DbMetadata dbMetadata = this.connection.getMetadata();
        TableIdentifier tableIdentifier = (TableIdentifier)dbObject;
        List<IndexDefinition> list = dbMetadata.getIndexReader().getTableIndexList(tableIdentifier, false);
        DbObjectSorter.sort(list, DbExplorerSettings.useNaturalSort());
        for (IndexDefinition indexDefinition : list) {
            ObjectTreeNode objectTreeNode2 = new ObjectTreeNode(indexDefinition);
            objectTreeNode2.setAllowsChildren(true);
            objectTreeNode2.setChildrenLoaded(true);
            for (IndexColumn indexColumn : indexDefinition.getColumns()) {
                ObjectTreeNode objectTreeNode3 = new ObjectTreeNode(indexColumn.getExpression(), TYPE_IDX_COL);
                objectTreeNode3.setAllowsChildren(false);
                objectTreeNode3.setChildrenLoaded(true);
                objectTreeNode2.add(objectTreeNode3);
            }
            objectTreeNode.add(objectTreeNode2);
        }
        this.model.nodeStructureChanged(objectTreeNode);
        objectTreeNode.setChildrenLoaded(true);
    }

    private void loadDependencies(DbObject dbObject, ObjectTreeNode objectTreeNode) {
        if (objectTreeNode == null) {
            return;
        }
        if (dbObject == null || this.dependencyLoader == null) {
            objectTreeNode.setAllowsChildren(false);
            return;
        }
        List<DbObject> list = null;
        list = objectTreeNode.getType().equals(TYPE_DEPENDENCY_USED) ? this.dependencyLoader.getUsedBy(this.connection, dbObject) : this.dependencyLoader.getUsedObjects(this.connection, dbObject);
        ObjectNameSorter objectNameSorter = new ObjectNameSorter();
        objectNameSorter.setUseNaturalSort(DbTreeSettings.useNaturalSort());
        list.sort(objectNameSorter);
        for (DbObject dbObject2 : list) {
            ObjectTreeNode objectTreeNode2 = new ObjectTreeNode(dbObject2);
            objectTreeNode2.setAllowsChildren(objectTreeNode2.canHaveChildren());
            objectTreeNode.add(objectTreeNode2);
        }
        this.model.nodeStructureChanged(objectTreeNode);
        objectTreeNode.setChildrenLoaded(true);
    }

    private void loadTableColumns(DbObject dbObject, ObjectTreeNode objectTreeNode) throws SQLException {
        if (objectTreeNode == null) {
            return;
        }
        if (dbObject == null) {
            objectTreeNode.setAllowsChildren(false);
            return;
        }
        List<ColumnIdentifier> list = this.connection.getMetadata().getObjectColumns(dbObject);
        if (list == null) {
            return;
        }
        if (dbObject instanceof TableIdentifier) {
            TableIdentifier tableIdentifier = (TableIdentifier)dbObject;
            this.connection.getObjectCache().addTable(new TableDefinition(tableIdentifier, list));
        }
        for (ColumnIdentifier columnIdentifier : list) {
            ObjectTreeNode objectTreeNode2 = new ObjectTreeNode(columnIdentifier);
            objectTreeNode2.setAllowsChildren(false);
            objectTreeNode.add(objectTreeNode2);
        }
        this.model.nodeStructureChanged(objectTreeNode);
        objectTreeNode.setChildrenLoaded(true);
    }

    private TableIdentifier findTableParent(ObjectTreeNode objectTreeNode) {
        if (objectTreeNode == null) {
            return null;
        }
        for (ObjectTreeNode objectTreeNode2 = objectTreeNode.getParent(); objectTreeNode2 != null; objectTreeNode2 = objectTreeNode2.getParent()) {
            if (!(objectTreeNode2.getUserObject() instanceof TableIdentifier)) continue;
            return (TableIdentifier)objectTreeNode2.getUserObject();
        }
        return null;
    }

    private void loadSubPartitions(ObjectTreeNode objectTreeNode) {
        if (this.partitionLister == null) {
            return;
        }
        TablePartition tablePartition = (TablePartition)objectTreeNode.getDbObject();
        TableIdentifier tableIdentifier = this.findTableParent(objectTreeNode);
        List<? extends TablePartition> list = this.partitionLister.getSubPartitions(tableIdentifier, tablePartition);
        objectTreeNode.setChildrenLoaded(true);
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        for (TablePartition tablePartition2 : list) {
            ObjectTreeNode objectTreeNode2 = new ObjectTreeNode(tablePartition2);
            objectTreeNode2.setAllowsChildren(false);
            objectTreeNode.add(objectTreeNode2);
        }
        this.model.nodeStructureChanged(objectTreeNode);
    }

    private void loadTablePartitions(DbObject dbObject, ObjectTreeNode objectTreeNode) {
        if (this.partitionLister == null) {
            return;
        }
        List<? extends TablePartition> list = this.partitionLister.getPartitions((TableIdentifier)dbObject);
        objectTreeNode.setChildrenLoaded(true);
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        for (TablePartition tablePartition : list) {
            ObjectTreeNode objectTreeNode2 = new ObjectTreeNode(tablePartition);
            boolean bl = tablePartition.getSubPartitionState() != SubPartitionState.none;
            objectTreeNode2.setAllowsChildren(bl);
            if (bl) {
                objectTreeNode2.setIconKey("partitions");
            }
            objectTreeNode.add(objectTreeNode2);
        }
        this.model.nodeStructureChanged(objectTreeNode);
    }

    private void loadForeignKeys(DbObject dbObject, ObjectTreeNode objectTreeNode, boolean bl) throws SQLException {
        if (objectTreeNode == null) {
            return;
        }
        if (dbObject == null) {
            objectTreeNode.setAllowsChildren(false);
            return;
        }
        DbMetadata dbMetadata = this.connection.getMetadata();
        if (!dbMetadata.isTableType(dbObject.getObjectType())) {
            return;
        }
        TableIdentifier tableIdentifier = (TableIdentifier)dbObject;
        TableDependency tableDependency = new TableDependency(this.connection, tableIdentifier);
        List<DependencyNode> list = null;
        if (bl) {
            list = tableDependency.getIncomingForeignKeys();
            this.connection.getObjectCache().addReferencingTables(tableIdentifier, list);
        } else {
            list = tableDependency.getOutgoingForeignKeys();
            this.connection.getObjectCache().addReferencedTables(tableIdentifier, list);
        }
        list.sort((dependencyNode, dependencyNode2) -> dependencyNode.getTable().compareTo(dependencyNode2.getTable()));
        for (DependencyNode dependencyNode3 : list) {
            TableIdentifier tableIdentifier2 = dependencyNode3.getTable();
            ObjectTreeNode objectTreeNode2 = new ObjectTreeNode(tableIdentifier2);
            objectTreeNode2.setAllowsChildren(true);
            objectTreeNode2.setChildrenLoaded(true);
            objectTreeNode.add(objectTreeNode2);
            String string = "<html><b>" + dependencyNode3.getFkName() + "</b>: ";
            string = bl ? string + dependencyNode3.getTable().getTableExpression(this.connection) + "(" + dependencyNode3.getSourceColumnsList() + ") REFERENCES  " + tableIdentifier.getTableExpression(this.connection) + "(" + dependencyNode3.getTargetColumnsList() : string + tableIdentifier.getTableExpression(this.connection) + "(" + dependencyNode3.getTargetColumnsList() + ") REFERENCES  " + dependencyNode3.getTable().getTableExpression(this.connection) + "(" + dependencyNode3.getSourceColumnsList();
            string = string + ")</html>";
            ObjectTreeNode objectTreeNode3 = new ObjectTreeNode(dependencyNode3.getFkName(), TYPE_FK_DEF);
            objectTreeNode3.setDisplay(string);
            objectTreeNode3.setAllowsChildren(false);
            objectTreeNode3.setChildrenLoaded(true);
            objectTreeNode3.setTooltip(dependencyNode3.getComment());
            objectTreeNode2.add(objectTreeNode3);
        }
        this.model.nodeStructureChanged(objectTreeNode);
        objectTreeNode.setChildrenLoaded(true);
    }

    private boolean isTable(DbObject dbObject) {
        if (dbObject == null) {
            return false;
        }
        DbMetadata dbMetadata = this.connection.getMetadata();
        return dbMetadata.isExtendedTableType(dbObject.getObjectType());
    }

    private boolean hasColumns(DbObject dbObject) {
        if (dbObject == null) {
            return false;
        }
        DbMetadata dbMetadata = this.connection.getMetadata();
        return dbMetadata.hasColumns(dbObject);
    }

    public WbConnection getConnection() {
        return this.connection;
    }

    public void loadChildren(ObjectTreeNode objectTreeNode) throws SQLException {
        if (objectTreeNode == null) {
            return;
        }
        if (this.connection == null) {
            return;
        }
        Savepoint savepoint = null;
        CallerInfo callerInfo = new CallerInfo(){};
        if (this.connection.getDbSettings().useSavePointForDML()) {
            savepoint = this.connection.setSavepoint(callerInfo);
        }
        try {
            this.levelChanger.changeIsolationLevel(this.connection);
            this.connection.setBusy(true);
            if (objectTreeNode.loadChildren(this.connection, this)) {
                this.model.nodeStructureChanged(objectTreeNode);
                this.connection.releaseSavepoint(savepoint);
                return;
            }
            String string = objectTreeNode.getType();
            if (objectTreeNode.isCatalogNode()) {
                if (this.connection.getDbSettings().supportsSchemas()) {
                    this.loadSchemas(objectTreeNode);
                } else if (!objectTreeNode.childrenAreLoaded()) {
                    this.addTypeNodes(objectTreeNode);
                    this.loadNodeObjects(objectTreeNode);
                }
            } else if (objectTreeNode.isSchemaNode()) {
                this.loadTypesForSchema(objectTreeNode);
            } else if (TYPE_DBO_TYPE_NODE.equals(string)) {
                this.loadObjectsForTypeNode(objectTreeNode);
            } else if (TYPE_COLUMN_LIST.equals(string)) {
                ObjectTreeNode objectTreeNode2 = objectTreeNode.getParent();
                DbObject dbObject = objectTreeNode2.getDbObject();
                this.loadTableColumns(dbObject, objectTreeNode);
            } else if (TYPE_INDEX_LIST.equals(string)) {
                ObjectTreeNode objectTreeNode3 = objectTreeNode.getParent();
                DbObject dbObject = objectTreeNode3.getDbObject();
                this.loadTableIndexes(dbObject, objectTreeNode);
            } else if ("PARTITION".equals(string)) {
                this.loadSubPartitions(objectTreeNode);
            } else if (TYPE_PARTITIONS_NODE.equals(string)) {
                ObjectTreeNode objectTreeNode4 = objectTreeNode.getParent();
                DbObject dbObject = objectTreeNode4.getDbObject();
                this.loadTablePartitions(dbObject, objectTreeNode);
            } else if (TYPE_FK_LIST.equals(string)) {
                ObjectTreeNode objectTreeNode5 = objectTreeNode.getParent();
                DbObject dbObject = objectTreeNode5.getDbObject();
                this.loadForeignKeys(dbObject, objectTreeNode, false);
            } else if (TYPE_REF_LIST.equals(string)) {
                ObjectTreeNode objectTreeNode6 = objectTreeNode.getParent();
                DbObject dbObject = objectTreeNode6.getDbObject();
                this.loadForeignKeys(dbObject, objectTreeNode, true);
            } else if (TYPE_TRIGGERS_NODE.equals(string)) {
                ObjectTreeNode objectTreeNode7 = objectTreeNode.getParent();
                DbObject dbObject = objectTreeNode7.getDbObject();
                if (dbObject instanceof TableIdentifier) {
                    this.loadTableTriggers(dbObject, objectTreeNode);
                } else {
                    this.loadTriggers(objectTreeNode);
                }
            } else if (TYPE_DEPENDENCY_USED.equals(string) || TYPE_DEPENDENCY_USING.equals(string)) {
                ObjectTreeNode objectTreeNode8 = objectTreeNode.getParent();
                DbObject dbObject = objectTreeNode8.getDbObject();
                this.loadDependencies(dbObject, objectTreeNode);
            } else if (TYPE_PROCEDURES_NODE.equals(string)) {
                this.loadProcedures(objectTreeNode);
            } else if (TYPE_PARAMETER_LIST.equals(string)) {
                this.loadProcedureParameters(objectTreeNode);
            } else if (this.connection.getMetadata().isExtendedTableType(string) || this.connection.getMetadata().isViewType(string)) {
                this.reloadTableNode(objectTreeNode);
            }
            this.connection.releaseSavepoint(savepoint, callerInfo);
        }
        catch (SQLException sQLException) {
            this.connection.rollback(savepoint, callerInfo);
            throw sQLException;
        }
        finally {
            this.connection.setBusy(false);
            this.levelChanger.restoreIsolationLevel(this.connection);
            this.endTransaction(callerInfo);
        }
    }
}

