/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dialogs.export;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import workbench.gui.dialogs.export.SpreadSheetOptions;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;

public class SpreadSheetOptionsPanel
extends JPanel
implements SpreadSheetOptions {
    private String exportType;
    private JCheckBox cbxOptimizeCols;
    private JCheckBox createAutoFilter;
    private JCheckBox createInfosheet;
    private JCheckBox exportHeaders;
    private JCheckBox freezeHeaders;
    private JTextField pageTitle;
    private JLabel pageTitleLabel;

    public SpreadSheetOptionsPanel(String string) {
        this.exportType = string;
        this.initComponents();
    }

    public void saveSettings() {
        Settings settings = Settings.getInstance();
        settings.setProperty("workbench.export." + this.exportType + ".pagetitle", this.getPageTitle());
        settings.setProperty("workbench.export." + this.exportType + ".header", this.getExportHeaders());
        settings.setProperty("workbench.export." + this.exportType + ".fixedheader", this.getCreateFixedHeaders());
        settings.setProperty("workbench.export." + this.exportType + ".autofilter", this.getCreateAutoFilter());
        settings.setProperty("workbench.export." + this.exportType + ".infosheet", this.getCreateInfoSheet());
        settings.setProperty("workbench.export." + this.exportType + ".optimizecols", this.getOptimizeColumns());
    }

    public void restoreSettings() {
        Settings settings = Settings.getInstance();
        this.setPageTitle(settings.getProperty("workbench.export." + this.exportType + ".pagetitle", ""));
        boolean bl = settings.getBoolProperty("workbench.export." + this.exportType + ".default.header", false);
        boolean bl2 = settings.getBoolProperty("workbench.export." + this.exportType + ".header", bl);
        this.setExportHeaders(bl2);
        if (this.createAutoFilter.isEnabled()) {
            this.setCreateAutoFilter(settings.getBoolProperty("workbench.export." + this.exportType + ".autofilter", true));
        }
        this.setCreateInfoSheet(settings.getBoolProperty("workbench.export." + this.exportType + ".infosheet", false));
        this.setCreateFixedHeaders(settings.getBoolProperty("workbench.export." + this.exportType + ".fixedheader", true));
        this.setOptimizeColumns(settings.getBoolProperty("workbench.export." + this.exportType + ".optimizecols", true));
        this.checkHeaderSettings();
    }

    @Override
    public boolean getOptimizeColumns() {
        return this.cbxOptimizeCols.isSelected();
    }

    @Override
    public void setOptimizeColumns(boolean bl) {
        this.cbxOptimizeCols.setSelected(bl);
    }

    @Override
    public boolean getCreateInfoSheet() {
        return this.createInfosheet.isSelected();
    }

    @Override
    public void setCreateInfoSheet(boolean bl) {
        this.createInfosheet.setSelected(bl);
    }

    @Override
    public boolean getCreateFixedHeaders() {
        return this.freezeHeaders.isSelected();
    }

    @Override
    public void setCreateFixedHeaders(boolean bl) {
        this.freezeHeaders.setSelected(bl);
    }

    @Override
    public boolean getCreateAutoFilter() {
        return this.createAutoFilter.isSelected();
    }

    @Override
    public void setCreateAutoFilter(boolean bl) {
        this.createAutoFilter.setSelected(bl);
    }

    @Override
    public boolean getExportHeaders() {
        return this.exportHeaders.isSelected();
    }

    @Override
    public void setExportHeaders(boolean bl) {
        this.exportHeaders.setSelected(bl);
    }

    @Override
    public String getPageTitle() {
        return this.pageTitle.getText();
    }

    @Override
    public void setPageTitle(String string) {
        this.pageTitle.setText(string);
    }

    private void checkHeaderSettings() {
        this.freezeHeaders.setEnabled(this.exportHeaders.isSelected());
    }

    private void initComponents() {
        this.pageTitleLabel = new JLabel();
        this.pageTitle = new JTextField();
        this.exportHeaders = new JCheckBox();
        this.createInfosheet = new JCheckBox();
        this.freezeHeaders = new JCheckBox();
        this.createAutoFilter = new JCheckBox();
        this.cbxOptimizeCols = new JCheckBox();
        FormListener formListener = new FormListener();
        this.setLayout(new GridBagLayout());
        this.pageTitleLabel.setText(ResourceMgr.getString("LblSheetName"));
        this.pageTitleLabel.setHorizontalTextPosition(10);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 6, 3, 6);
        this.add((Component)this.pageTitleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.add((Component)this.pageTitle, gridBagConstraints);
        this.exportHeaders.setText(ResourceMgr.getString("LblExportIncludeHeaders"));
        this.exportHeaders.setBorder(null);
        this.exportHeaders.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 6, 0, 6);
        this.add((Component)this.exportHeaders, gridBagConstraints);
        this.createInfosheet.setText(ResourceMgr.getString("LblExportInfoSheet"));
        this.createInfosheet.setToolTipText(ResourceMgr.getString("d_LblExportInfoSheet"));
        this.createInfosheet.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.createInfosheet, gridBagConstraints);
        this.freezeHeaders.setText(ResourceMgr.getString("LblExportFreezeHeader"));
        this.freezeHeaders.setToolTipText(ResourceMgr.getString("d_LblExportFreezeHeader"));
        this.freezeHeaders.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.freezeHeaders, gridBagConstraints);
        this.createAutoFilter.setText(ResourceMgr.getString("LblExportAutoFilter"));
        this.createAutoFilter.setToolTipText(ResourceMgr.getString("d_LblExportAutoFilter"));
        this.createAutoFilter.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.createAutoFilter, gridBagConstraints);
        this.cbxOptimizeCols.setText(ResourceMgr.getPlainString("MnuTxtOptimizeCol"));
        this.cbxOptimizeCols.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.cbxOptimizeCols, gridBagConstraints);
    }

    private void exportHeadersActionPerformed(ActionEvent actionEvent) {
        this.checkHeaderSettings();
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == SpreadSheetOptionsPanel.this.exportHeaders) {
                SpreadSheetOptionsPanel.this.exportHeadersActionPerformed(actionEvent);
            }
        }
    }
}

