/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dialogs.export;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import workbench.db.ColumnIdentifier;
import workbench.db.TableIdentifier;
import workbench.db.exporter.BlobMode;
import workbench.db.exporter.ExportType;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.ColumnSelectorPanel;
import workbench.gui.components.KeyColumnSelectorPanel;
import workbench.gui.dialogs.export.SqlOptions;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.storage.MergeGenerator;
import workbench.storage.ResultInfo;
import workbench.util.StringUtil;

public class SqlOptionsPanel
extends JPanel
implements SqlOptions,
ActionListener {
    private List<String> keyColumns;
    private ColumnSelectorPanel columnSelectorPanel;
    private ResultInfo tableColumns;
    public JTextField alternateTable;
    public JComboBox blobTypes;
    public JLabel blobTypesLabel;
    public JTextField commitCount;
    public JLabel commitLabel;
    public JCheckBox createTable;
    public JPanel extOptionsPanel;
    public JCheckBox ignoreIdentity;
    public JLabel jLabel1;
    public JLabel jLabel2;
    public JPanel jPanel2;
    public JPanel jPanel4;
    public JComboBox literalTypes;
    public JLabel literalTypesLabel;
    public JComboBox mergeTypes;
    public JLabel mergeTypesLabel;
    public JCheckBox multiRowInserts;
    public JButton selectKeys;
    public JComboBox syntaxType;
    public ButtonGroup typeGroup;

    public SqlOptionsPanel(ResultInfo resultInfo) {
        this.initComponents();
        this.setResultInfo(resultInfo);
        List<String> list = Settings.getInstance().getLiteralTypeList();
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
        this.literalTypes.setModel(defaultComboBoxModel);
        List<String> list2 = MergeGenerator.Factory.getSupportedTypes();
        DefaultComboBoxModel<Object> defaultComboBoxModel2 = new DefaultComboBoxModel<Object>(list2.toArray());
        this.mergeTypes.setModel(defaultComboBoxModel2);
        List<String> list3 = BlobMode.getTypes();
        list3.remove(BlobMode.Base64.getTypeString());
        DefaultComboBoxModel<Object> defaultComboBoxModel3 = new DefaultComboBoxModel<Object>(list3.toArray());
        this.blobTypes.setModel(defaultComboBoxModel3);
        this.blobTypes.setSelectedItem(BlobMode.SaveToFile.toString());
        WbSwingUtilities.setMinimumSizeFromCols(this.commitCount);
    }

    public final void setResultInfo(ResultInfo resultInfo) {
        this.tableColumns = resultInfo;
        boolean bl = this.tableColumns != null;
        boolean bl2 = resultInfo == null ? false : resultInfo.hasPkColumns();
        this.selectKeys.setEnabled(bl);
        this.setIncludeDeleteInsert(bl2);
        this.setIncludeUpdate(bl2);
        if (resultInfo != null) {
            TableIdentifier tableIdentifier = resultInfo.getUpdateTable();
            if (tableIdentifier != null) {
                this.alternateTable.setText(tableIdentifier.getTableName());
            } else {
                this.alternateTable.setText("target_table");
            }
        }
    }

    @Override
    public boolean getUseMultiRowInserts() {
        return this.multiRowInserts.isSelected();
    }

    public void saveSettings() {
        Settings settings = Settings.getInstance();
        settings.setProperty("workbench.export.sql.commitevery", this.getCommitEvery());
        settings.setProperty("workbench.export.sql.insert.multirow", this.getUseMultiRowInserts());
        settings.setProperty("workbench.export.sql.createtable", this.getCreateTable());
        settings.setProperty("workbench.export.sql.ignoreidentity", this.ignoreIdentityColumns());
        settings.setProperty("workbench.export.sql.saveas.dateliterals", this.getDateLiteralType());
        settings.setProperty("workbench.export.sql.saveas.blobliterals", this.getBlobMode().getTypeString());
    }

    public void restoreSettings() {
        Settings settings = Settings.getInstance();
        this.setCommitEvery(settings.getIntProperty("workbench.export.sql.commitevery", 0));
        this.setCreateTable(settings.getBoolProperty("workbench.export.sql.createtable"));
        String string = settings.getProperty("workbench.export.sql.default.dateliterals", "dbms");
        String string2 = settings.getProperty("workbench.export.sql.saveas.dateliterals", string);
        this.literalTypes.setSelectedItem(string2);
        string2 = settings.getProperty("workbench.export.sql.saveas.blobliterals", BlobMode.SaveToFile.getTypeString());
        this.blobTypes.setSelectedItem(string2);
        boolean bl = settings.getBoolProperty("workbench.export.sql.ignoreidentity", Settings.getInstance().getGenerateInsertIgnoreIdentity());
        this.ignoreIdentity.setSelected(bl);
        boolean bl2 = settings.getBoolProperty("workbench.export.sql.insert.multirow", false);
        this.multiRowInserts.setSelected(bl2);
    }

    @Override
    public boolean ignoreIdentityColumns() {
        return this.ignoreIdentity.isSelected();
    }

    @Override
    public String getMergeType() {
        return (String)this.mergeTypes.getSelectedItem();
    }

    @Override
    public BlobMode getBlobMode() {
        String string = (String)this.blobTypes.getSelectedItem();
        BlobMode blobMode = BlobMode.getMode(string);
        return blobMode;
    }

    @Override
    public String getDateLiteralType() {
        return (String)this.literalTypes.getSelectedItem();
    }

    @Override
    public String getAlternateUpdateTable() {
        String string = this.alternateTable.getText();
        if (StringUtil.isNonBlank(string)) {
            return string.trim();
        }
        return null;
    }

    @Override
    public void setAlternateUpdateTable(String string) {
        this.alternateTable.setText(string == null ? "" : string.trim());
    }

    @Override
    public int getCommitEvery() {
        int n = -1;
        try {
            String string = this.commitCount.getText();
            n = string != null && string.length() > 0 ? Integer.parseInt(string) : 0;
        }
        catch (Exception exception) {
            LogMgr.logDebug(new CallerInfo(){}, "Could not retrieve commit frequency", exception);
        }
        return n;
    }

    public void setDbId(String string) {
        String string2 = MergeGenerator.Factory.getTypeForDBID(string);
        this.mergeTypes.setSelectedItem(string2);
    }

    private void removeSyntaxType(String string) {
        this.syntaxType.removeItem(string);
    }

    private int getSyntaxTypeIndex(String string) {
        int n = this.syntaxType.getItemCount();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)this.syntaxType.getItemAt(i);
            if (!string2.equals(string)) continue;
            return i;
        }
        return -1;
    }

    private void addSyntaxType(String string) {
        int n;
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.syntaxType.getModel();
        int n2 = this.getSyntaxTypeIndex(string);
        if (string.equals("MERGE") && n2 == -1) {
            defaultComboBoxModel.addElement(string);
        }
        if (string.equals("UPDATE") && n2 == -1) {
            n = this.getSyntaxTypeIndex("INSERT");
            defaultComboBoxModel.insertElementAt(string, n + 1);
        }
        if (string.equals("DELETE/INSERT") && n2 == -1) {
            n = this.getSyntaxTypeIndex("UPDATE");
            defaultComboBoxModel.insertElementAt(string, n + 1);
        }
    }

    public void setIncludeMerge(boolean bl) {
        if (bl) {
            this.addSyntaxType("MERGE");
            this.mergeTypes.setEnabled(true);
            this.mergeTypesLabel.setEnabled(true);
        } else {
            this.removeSyntaxType("MERGE");
            this.mergeTypes.setEnabled(false);
            this.mergeTypesLabel.setEnabled(false);
        }
    }

    public void setIncludeUpdate(boolean bl) {
        if (bl) {
            this.addSyntaxType("UPDATE");
        } else {
            this.removeSyntaxType("UPDATE");
        }
    }

    public void setIncludeDeleteInsert(boolean bl) {
        if (bl) {
            this.addSyntaxType("DELETE/INSERT");
            this.addSyntaxType("DELETE");
        } else {
            this.removeSyntaxType("DELETE/INSERT");
            this.removeSyntaxType("DELETE");
        }
    }

    private String getSelectedSyntaxType() {
        return (String)this.syntaxType.getSelectedItem();
    }

    @Override
    public ExportType getExportType() {
        String string = this.getSelectedSyntaxType();
        if (string.equals("UPDATE")) {
            return ExportType.SQL_UPDATE;
        }
        if (string.equals("DELETE")) {
            return ExportType.SQL_DELETE;
        }
        if (string.equals("DELETE/INSERT")) {
            return ExportType.SQL_DELETE_INSERT;
        }
        if (string.equals("MERGE")) {
            return ExportType.SQL_MERGE;
        }
        return ExportType.SQL_INSERT;
    }

    @Override
    public boolean getCreateTable() {
        return this.createTable.isSelected();
    }

    @Override
    public void setCommitEvery(int n) {
        if (n > 0) {
            this.commitCount.setText(Integer.toString(n));
        } else {
            this.commitCount.setText("");
        }
    }

    @Override
    public void setExportType(ExportType exportType) {
        switch (exportType) {
            case SQL_DELETE: {
                this.syntaxType.setSelectedItem("DELETE");
                break;
            }
            case SQL_DELETE_INSERT: {
                this.syntaxType.setSelectedItem("DELETE/INSERT");
                break;
            }
            case SQL_UPDATE: {
                this.syntaxType.setSelectedItem("UPDATE");
                break;
            }
            case SQL_MERGE: {
                this.syntaxType.setSelectedItem("MERGE");
                break;
            }
            default: {
                this.syntaxType.setSelectedItem("INSERT");
            }
        }
        this.checkMultiRow();
    }

    private void checkMultiRow() {
        this.multiRowInserts.setEnabled(this.getExportType() == ExportType.SQL_INSERT);
    }

    @Override
    public void setCreateTable(boolean bl) {
        this.createTable.setSelected(bl);
    }

    @Override
    public List<String> getKeyColumns() {
        return this.keyColumns;
    }

    private void selectColumns() {
        if (this.tableColumns == null) {
            return;
        }
        if (this.columnSelectorPanel == null) {
            this.columnSelectorPanel = new KeyColumnSelectorPanel(this.tableColumns);
        } else {
            this.columnSelectorPanel.selectColumns(this.keyColumns);
        }
        int n = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(this), this.columnSelectorPanel, ResourceMgr.getString("MsgSelectKeyColumnsWindowTitle"), 2, -1);
        if (n == 0) {
            int n2;
            this.keyColumns = null;
            List<ColumnIdentifier> list = this.columnSelectorPanel.getSelectedColumns();
            int n3 = list.size();
            this.keyColumns = new ArrayList<String>(n3);
            for (n2 = 0; n2 < n3; n2 += 1) {
                ColumnIdentifier columnIdentifier = list.get(n2);
                this.keyColumns.add(columnIdentifier.getColumnName());
            }
            n2 = n3 > 0 ? 1 : 0;
            this.setIncludeUpdate(n2 != 0);
            this.setIncludeDeleteInsert(n2 != 0);
            this.setIncludeMerge(n2 != 0);
        }
    }

    private void initComponents() {
        this.typeGroup = new ButtonGroup();
        this.selectKeys = new JButton();
        this.jPanel2 = new JPanel();
        this.jPanel4 = new JPanel();
        this.literalTypesLabel = new JLabel();
        this.literalTypes = new JComboBox();
        this.mergeTypesLabel = new JLabel();
        this.mergeTypes = new JComboBox();
        this.jLabel2 = new JLabel();
        this.syntaxType = new JComboBox();
        this.blobTypesLabel = new JLabel();
        this.blobTypes = new JComboBox();
        this.extOptionsPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.alternateTable = new JTextField();
        this.commitLabel = new JLabel();
        this.commitCount = new JTextField();
        this.ignoreIdentity = new JCheckBox();
        this.multiRowInserts = new JCheckBox();
        this.createTable = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.selectKeys.setText(ResourceMgr.getString("LblSelectKeyColumns"));
        this.selectKeys.setToolTipText(ResourceMgr.getString("d_LblSelectKeyColumns"));
        this.selectKeys.addActionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(7, 0, 6, 0);
        this.add((Component)this.selectKeys, gridBagConstraints);
        this.jPanel2.setLayout(new BorderLayout(10, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 4, 0, 21);
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.literalTypesLabel.setText(ResourceMgr.getString("LblLiteralType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel4.add((Component)this.literalTypesLabel, gridBagConstraints);
        this.literalTypes.setToolTipText(ResourceMgr.getDescription("LblLiteralType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 4, 5, 0);
        this.jPanel4.add((Component)this.literalTypes, gridBagConstraints);
        this.mergeTypesLabel.setText(ResourceMgr.getString("LblMergeType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel4.add((Component)this.mergeTypesLabel, gridBagConstraints);
        this.mergeTypes.setToolTipText(ResourceMgr.getDescription("LblLiteralType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 4, 5, 11);
        this.jPanel4.add((Component)this.mergeTypes, gridBagConstraints);
        this.jLabel2.setText(ResourceMgr.getString("LblSqlExpType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel4.add((Component)this.jLabel2, gridBagConstraints);
        this.syntaxType.setModel(new DefaultComboBoxModel<String>(new String[]{"INSERT", "UPDATE", "DELETE/INSERT", "MERGE", "DELETE"}));
        this.syntaxType.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 4, 5, 11);
        this.jPanel4.add((Component)this.syntaxType, gridBagConstraints);
        this.blobTypesLabel.setText(ResourceMgr.getString("LblBlobType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel4.add((Component)this.blobTypesLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 4, 5, 0);
        this.jPanel4.add((Component)this.blobTypes, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 6);
        this.add((Component)this.jPanel4, gridBagConstraints);
        this.extOptionsPanel.setLayout(new GridBagLayout());
        this.jLabel1.setText(ResourceMgr.getString("LblUseExportTableName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.extOptionsPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.alternateTable.setMinimumSize(new Dimension(40, 20));
        this.alternateTable.setPreferredSize(new Dimension(40, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 7, 0, 0);
        this.extOptionsPanel.add((Component)this.alternateTable, gridBagConstraints);
        this.commitLabel.setText(ResourceMgr.getString("LblExportCommitEvery"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        this.extOptionsPanel.add((Component)this.commitLabel, gridBagConstraints);
        this.commitCount.setColumns(4);
        this.commitCount.setMinimumSize(new Dimension(32, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 7, 5, 0);
        this.extOptionsPanel.add((Component)this.commitCount, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.add((Component)this.extOptionsPanel, gridBagConstraints);
        this.ignoreIdentity.setText(ResourceMgr.getString("LblIgnoreIdentity"));
        this.ignoreIdentity.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 0, 7, 0);
        this.add((Component)this.ignoreIdentity, gridBagConstraints);
        this.multiRowInserts.setText(ResourceMgr.getString("LblMultiRowInsert"));
        this.multiRowInserts.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 0, 7, 0);
        this.add((Component)this.multiRowInserts, gridBagConstraints);
        this.createTable.setText(ResourceMgr.getString("LblExportIncludeCreateTable"));
        this.createTable.setToolTipText(ResourceMgr.getString("d_LblExportIncludeCreateTable"));
        this.createTable.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 7, 0);
        this.add((Component)this.createTable, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.selectKeys) {
            this.selectKeysActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.syntaxType) {
            this.syntaxTypeActionPerformed(actionEvent);
        }
    }

    private void selectKeysActionPerformed(ActionEvent actionEvent) {
        this.selectColumns();
    }

    private void syntaxTypeActionPerformed(ActionEvent actionEvent) {
        this.checkMultiRow();
    }
}

