/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dialogs.export;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import workbench.db.exporter.BlobMode;
import workbench.db.exporter.ControlFileFormat;
import workbench.db.exporter.WrongFormatFileException;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.FoldingPanel;
import workbench.gui.components.WbComboBox;
import workbench.gui.dialogs.QuoteEscapeSelector;
import workbench.gui.dialogs.export.TextOptions;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.CharacterEscapeType;
import workbench.util.CharacterRange;
import workbench.util.CollectionUtil;
import workbench.util.QuoteEscapeType;
import workbench.util.StringUtil;

public class TextOptionsPanel
extends JPanel
implements TextOptions {
    private JComboBox blobTypes;
    private JLabel blobTypesLabel;
    private JTextField controlFiles;
    private JLabel ctrlFileLabel;
    private JTextField decimalChar;
    private JLabel decimalLabel;
    private JTextField delimiter;
    private JLabel delimiterLabel;
    private JLabel escapeLabel;
    private JComboBox escapeRange;
    private JComboBox escapeSelect;
    private JCheckBox exportHeaders;
    private JPanel extOptionsPanel;
    private JLabel jLabel1;
    private JComboBox lineEnding;
    private JLabel lineEndingLabel;
    private JCheckBox quoteAlways;
    private JTextField quoteChar;
    private JLabel quoteCharLabel;
    private JCheckBox quoteHeader;

    public TextOptionsPanel() {
        Object object2;
        this.initComponents();
        TextOptionsPanel.populateEscapeRange((WbComboBox)this.escapeRange);
        StringBuilder stringBuilder = new StringBuilder(20);
        boolean bl = true;
        for (Object object2 : ControlFileFormat.values()) {
            if (object2 == ControlFileFormat.none) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(object2.toString());
        }
        String string = ResourceMgr.getFormattedString("d_LblFmtFiles", stringBuilder.toString());
        this.controlFiles.setToolTipText(string);
        this.ctrlFileLabel.setToolTipText(string);
        List<String> list = CollectionUtil.arrayList(BlobMode.AnsiLiteral.getTypeString(), BlobMode.SaveToFile.getTypeString(), BlobMode.Base64.getTypeString(), BlobMode.DbmsLiteral.getTypeString());
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
        this.blobTypes.setModel(defaultComboBoxModel);
        this.blobTypes.setSelectedItem(BlobMode.SaveToFile.toString());
        object2 = (GridBagLayout)this.getLayout();
        GridBagConstraints gridBagConstraints = ((GridBagLayout)object2).getConstraints(this.extOptionsPanel);
        this.remove(this.extOptionsPanel);
        FoldingPanel foldingPanel = new FoldingPanel(this.extOptionsPanel);
        this.add((Component)foldingPanel, gridBagConstraints);
        this.invalidate();
    }

    public static void populateEscapeRange(WbComboBox wbComboBox) {
        int n;
        CharacterRange[] characterRangeArray = CharacterRange.getRanges();
        Font font = wbComboBox.getFont();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < characterRangeArray.length; ++i) {
            FontMetrics fontMetrics;
            wbComboBox.addItem(characterRangeArray[i]);
            if (font == null || (fontMetrics = wbComboBox.getFontMetrics(font)) == null) continue;
            n = fontMetrics.stringWidth(characterRangeArray[i].toString());
            if (i == 0) {
                n2 = n;
            }
            if (n <= n3) continue;
            n3 = n;
        }
        if (n2 == 0) {
            n2 = 50;
        }
        Dimension dimension = wbComboBox.getPreferredSize();
        int n4 = (int)dimension.getWidth();
        n = n4 - n3;
        Dimension dimension2 = new Dimension(n2 += n, (int)dimension.getHeight());
        wbComboBox.setMaximumSize(dimension2);
        wbComboBox.setPreferredSize(dimension2);
        wbComboBox.setPopupWidth(n4);
    }

    public void saveSettings() {
        Settings settings = Settings.getInstance();
        settings.setProperty("workbench.export.text.includeheader", this.getExportHeaders());
        settings.setProperty("workbench.export.text.quotealways", this.getQuoteAlways());
        settings.setProperty("workbench.export.text.quoteheader", this.getQuoteHeader());
        settings.setProperty("workbench.export.text.escaperange", this.getEscapeRange().getId());
        settings.setProperty("workbench.export.text.lineending", (String)this.lineEnding.getSelectedItem());
        settings.setLastExportDecimalSeparator(this.getDecimalSymbol());
        settings.setDefaultExportTextDelimiter(this.getTextDelimiter());
        settings.setQuoteChar(this.getTextQuoteChar());
        settings.setProperty("workbench.export.text.quote.escape", this.getQuoteEscaping().toString());
        settings.setProperty("workbench.export.text.formatfiles", this.controlFiles.getText());
        settings.setProperty("workbench.export.text.blobmode", this.getBlobMode().getTypeString());
    }

    public void restoreSettings() {
        Settings settings = Settings.getInstance();
        this.setExportHeaders(settings.getBoolProperty("workbench.export.text.includeheader"));
        this.setQuoteAlways(settings.getBoolProperty("workbench.export.text.quotealways"));
        this.setQuoteHeader(settings.getBoolProperty("workbench.export.text.quoteheader"));
        int n = settings.getIntProperty("workbench.export.text.escaperange", CharacterRange.RANGE_NONE.getId());
        CharacterRange characterRange = CharacterRange.getRangeById(n);
        this.setEscapeRange(characterRange);
        this.setLineEnding(settings.getProperty("workbench.export.text.lineending", "LF"));
        this.setTextQuoteChar(settings.getQuoteChar());
        this.setTextDelimiter(settings.getDefaultTextDelimiter(true));
        this.setDecimalSymbol(settings.getLastExportDecimalSeparator());
        String string = settings.getProperty("workbench.export.text.quote.escape", "none");
        QuoteEscapeType quoteEscapeType = null;
        try {
            quoteEscapeType = QuoteEscapeType.valueOf(string);
        }
        catch (Exception exception) {
            quoteEscapeType = QuoteEscapeType.none;
        }
        ((QuoteEscapeSelector)this.escapeSelect).setEscapeType(quoteEscapeType);
        this.controlFiles.setText(settings.getProperty("workbench.export.text.formatfiles", ""));
        String string2 = settings.getProperty("workbench.export.text.blobmode", BlobMode.SaveToFile.getTypeString());
        this.blobTypes.setSelectedItem(string2);
    }

    @Override
    public BlobMode getBlobMode() {
        String string = (String)this.blobTypes.getSelectedItem();
        BlobMode blobMode = BlobMode.getMode(string);
        return blobMode;
    }

    @Override
    public QuoteEscapeType getQuoteEscaping() {
        return ((QuoteEscapeSelector)this.escapeSelect).getEscapeType();
    }

    @Override
    public void setDecimalSymbol(String string) {
        this.decimalChar.setText(string);
    }

    @Override
    public String getDecimalSymbol() {
        return this.decimalChar.getText();
    }

    @Override
    public boolean getExportHeaders() {
        return this.exportHeaders.isSelected();
    }

    @Override
    public String getTextDelimiter() {
        return this.delimiter.getText();
    }

    @Override
    public String getTextQuoteChar() {
        return this.quoteChar.getText();
    }

    @Override
    public void setExportHeaders(boolean bl) {
        this.exportHeaders.setSelected(bl);
    }

    @Override
    public void setTextDelimiter(String string) {
        this.delimiter.setText(string);
    }

    @Override
    public void setTextQuoteChar(String string) {
        this.quoteChar.setText(string);
    }

    @Override
    public boolean getQuoteAlways() {
        if (!this.quoteAlways.isEnabled()) {
            return false;
        }
        return this.quoteAlways.isSelected();
    }

    @Override
    public void setQuoteAlways(boolean bl) {
        this.quoteAlways.setSelected(bl);
    }

    @Override
    public boolean getQuoteHeader() {
        if (!this.quoteHeader.isEnabled()) {
            return false;
        }
        return this.quoteHeader.isSelected();
    }

    @Override
    public void setQuoteHeader(boolean bl) {
        this.quoteHeader.setSelected(bl);
    }

    @Override
    public void setEscapeType(CharacterEscapeType characterEscapeType) {
    }

    @Override
    public CharacterEscapeType getEscapeType() {
        return CharacterEscapeType.unicode;
    }

    @Override
    public void setEscapeRange(CharacterRange characterRange) {
        this.escapeRange.setSelectedItem(characterRange);
    }

    @Override
    public CharacterRange getEscapeRange() {
        return (CharacterRange)this.escapeRange.getSelectedItem();
    }

    @Override
    public String getLineEnding() {
        String string = (String)this.lineEnding.getSelectedItem();
        if ("LF".equals(string)) {
            return "\n";
        }
        if ("CRLF".equals(string)) {
            return "\r\n";
        }
        return StringUtil.LINE_TERMINATOR;
    }

    @Override
    public void setLineEnding(String string) {
        if (string == null) {
            return;
        }
        if ("\n".equals(string)) {
            this.lineEnding.setSelectedItem("LF");
        } else if ("\r\n".equals(string)) {
            this.lineEnding.setSelectedItem("CRLF");
        } else {
            this.lineEnding.setSelectedItem(string.toUpperCase());
        }
    }

    @Override
    public Set<ControlFileFormat> getControlFiles() {
        String string = this.controlFiles.getText();
        try {
            Set<ControlFileFormat> set = ControlFileFormat.parseCommandLine(string);
            return set;
        }
        catch (WrongFormatFileException wrongFormatFileException) {
            String string2 = ResourceMgr.getFormattedString("ErrExpWrongCtl", wrongFormatFileException.getFormat());
            WbSwingUtilities.showErrorMessage(string2);
            return Collections.emptySet();
        }
    }

    private void initComponents() {
        this.delimiterLabel = new JLabel();
        this.delimiter = new JTextField();
        this.exportHeaders = new JCheckBox();
        this.quoteCharLabel = new JLabel();
        this.quoteChar = new JTextField();
        this.quoteAlways = new JCheckBox();
        this.lineEndingLabel = new JLabel();
        this.lineEnding = new JComboBox();
        this.decimalLabel = new JLabel();
        this.decimalChar = new JTextField();
        this.escapeSelect = new QuoteEscapeSelector();
        this.jLabel1 = new JLabel();
        this.extOptionsPanel = new JPanel();
        this.ctrlFileLabel = new JLabel();
        this.controlFiles = new JTextField();
        this.blobTypes = new JComboBox();
        this.blobTypesLabel = new JLabel();
        this.escapeLabel = new JLabel();
        this.escapeRange = new WbComboBox();
        this.quoteHeader = new JCheckBox();
        this.setMinimumSize(new Dimension(200, 50));
        this.setLayout(new GridBagLayout());
        this.delimiterLabel.setText(ResourceMgr.getString("LblFieldDelimiter"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.add((Component)this.delimiterLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.add((Component)this.delimiter, gridBagConstraints);
        this.exportHeaders.setText(ResourceMgr.getString("LblExportIncludeHeaders"));
        this.exportHeaders.setToolTipText("");
        this.exportHeaders.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 4, 6, 0);
        this.add((Component)this.exportHeaders, gridBagConstraints);
        this.quoteCharLabel.setText(ResourceMgr.getString("LblQuoteChar"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 4, 4, 4);
        this.add((Component)this.quoteCharLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.add((Component)this.quoteChar, gridBagConstraints);
        this.quoteAlways.setText(ResourceMgr.getString("LblExportQuoteAlways"));
        this.quoteAlways.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 6, 0);
        this.add((Component)this.quoteAlways, gridBagConstraints);
        this.lineEndingLabel.setText(ResourceMgr.getString("LblExportLineEnding"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.add((Component)this.lineEndingLabel, gridBagConstraints);
        this.lineEnding.setModel(new DefaultComboBoxModel<String>(new String[]{"LF", "CRLF"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.add((Component)this.lineEnding, gridBagConstraints);
        this.decimalLabel.setText(ResourceMgr.getString("LblDecimalSymbol"));
        this.decimalLabel.setToolTipText(ResourceMgr.getDescription("LblDecimalSymbol"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 4, 4);
        this.add((Component)this.decimalLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.add((Component)this.decimalChar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.add((Component)this.escapeSelect, gridBagConstraints);
        this.jLabel1.setText(ResourceMgr.getString("LblQuoteEsc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 4, 4);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.extOptionsPanel.setLayout(new GridBagLayout());
        this.ctrlFileLabel.setText(ResourceMgr.getString("LblFmtFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 5, 4);
        this.extOptionsPanel.add((Component)this.ctrlFileLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 5, 4);
        this.extOptionsPanel.add((Component)this.controlFiles, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 0, 4);
        this.extOptionsPanel.add((Component)this.blobTypes, gridBagConstraints);
        this.blobTypesLabel.setText(ResourceMgr.getString("LblBlobType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 4, 0, 4);
        this.extOptionsPanel.add((Component)this.blobTypesLabel, gridBagConstraints);
        this.escapeLabel.setText(ResourceMgr.getString("LblExportEscapeType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 5, 4);
        this.extOptionsPanel.add((Component)this.escapeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 5, 4);
        this.extOptionsPanel.add((Component)this.escapeRange, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.extOptionsPanel, gridBagConstraints);
        this.quoteHeader.setText(ResourceMgr.getString("LblExportQuoteHeader"));
        this.quoteHeader.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 6, 0);
        this.add((Component)this.quoteHeader, gridBagConstraints);
    }
}

