/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.editor;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class SyntaxStyle {
    public static final String PREFIX_COLOR = "workbench.editor.color.";
    public static final String PREFIX_STYLE = "workbench.editor.syntax.style.";
    public static final String COMMENT1 = "comment1";
    public static final String PROP_COMMENT1 = "workbench.editor.color.comment1";
    public static final String COMMENT2 = "comment2";
    public static final String PROP_COMMENT2 = "workbench.editor.color.comment2";
    public static final String KEYWORD1 = "keyword1";
    public static final String PROP_KEYWORD1 = "workbench.editor.color.keyword1";
    public static final String KEYWORD2 = "keyword2";
    public static final String PROP_KEYWORD2 = "workbench.editor.color.keyword2";
    public static final String KEYWORD3 = "keyword3";
    public static final String PROP_KEYWORD3 = "workbench.editor.color.keyword3";
    public static final String LITERAL1 = "literal1";
    public static final String PROP_LITERAL1 = "workbench.editor.color.literal1";
    public static final String LITERAL2 = "literal2";
    public static final String PROP_LITERAL2 = "workbench.editor.color.literal2";
    public static final String OPERATOR = "operator";
    public static final String PROP_OPERATOR = "workbench.editor.color.operator";
    public static final String DATATYPE = "datatype";
    public static final String PROP_DATATYPE = "workbench.editor.color.datatype";
    public static final String INVALID = "invalid";
    private Color color;
    private final int style;
    private Font lastFont;
    private Font lastStyledFont;

    public SyntaxStyle(Color color, int n) {
        this.color = color;
        this.style = n < 0 || n > 3 ? 0 : n;
    }

    public void clearFontCache() {
        this.lastFont = null;
        this.lastStyledFont = null;
    }

    public Color getColor() {
        return this.color;
    }

    public int getFontStyle() {
        return this.style;
    }

    public Font getStyledFont(Font font) {
        if (font.equals(this.lastFont)) {
            return this.lastStyledFont;
        }
        this.lastFont = font;
        this.lastStyledFont = new Font(font.getFamily(), this.style, font.getSize());
        return this.lastStyledFont;
    }

    public void setGraphicsFlags(Graphics graphics, Font font) {
        Font font2 = this.getStyledFont(font);
        graphics.setFont(font2);
        graphics.setColor(this.color);
    }
}

