/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.editor;

import javax.swing.text.BadLocationException;
import workbench.gui.editor.JEditTextArea;
import workbench.gui.editor.SyntaxDocument;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class TextIndenter {
    private JEditTextArea editor;

    public TextIndenter(JEditTextArea jEditTextArea) {
        this.editor = jEditTextArea;
    }

    public void indentSelection() {
        this.shiftSelection(true);
    }

    public void unIndentSelection() {
        this.shiftSelection(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shiftSelection(boolean bl) {
        int n;
        int n2 = this.editor.getSelectionStartLine();
        int n3 = n = this.editor.getSelectionEndLine();
        int n4 = this.editor.getTabSize();
        StringBuilder stringBuilder = new StringBuilder(n4);
        for (int i = 0; i < n4; ++i) {
            stringBuilder.append(' ');
        }
        String string = stringBuilder.toString();
        boolean bl2 = Settings.getInstance().getEditorUseTabCharacter();
        int n5 = this.editor.getSelectionEnd(n3) - this.editor.getLineStartOffset(n3);
        if (n5 == 0) {
            --n3;
        }
        SyntaxDocument syntaxDocument = this.editor.getDocument();
        try {
            syntaxDocument.beginCompoundEdit();
            for (int i = n2; i <= n3; ++i) {
                int n6;
                String string2 = this.editor.getLineText(i);
                if (StringUtil.isBlank(string2)) continue;
                int n7 = this.editor.getLineStartOffset(i);
                if (bl) {
                    if (bl2) {
                        syntaxDocument.insertString(n7, "\t", null);
                        continue;
                    }
                    syntaxDocument.insertString(n7, string, null);
                    continue;
                }
                char c = string2.charAt(0);
                if (c == '\t') {
                    syntaxDocument.remove(n7, 1);
                    continue;
                }
                for (n6 = 0; Character.isWhitespace(string2.charAt(n6)) && n6 < n4; ++n6) {
                }
                syntaxDocument.remove(n7, n6);
            }
        }
        catch (BadLocationException badLocationException) {
            LogMgr.logError(new CallerInfo(){}, "Error when shifting selection", badLocationException);
        }
        finally {
            syntaxDocument.endCompoundEdit();
        }
    }
}

