/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.editor;

import java.util.ArrayList;
import javax.swing.text.Segment;
import workbench.gui.editor.Token;

public abstract class TokenMarker {
    protected ArrayList<Token> lineStartTokens = new ArrayList(250);
    protected int length;

    protected TokenMarker() {
    }

    public Token getLastTokenInLine(int n) {
        Token token = this.getFirstTokenInLine(n);
        if (token == null) {
            return null;
        }
        while (token != null) {
            if (token.next == null) {
                return token;
            }
            token = token.next;
        }
        return null;
    }

    private Token findTokenForPosition(int n, int n2) {
        Token token = this.getFirstTokenInLine(n);
        if (token == null) {
            return null;
        }
        int n3 = 0;
        while (token != null) {
            if (n3 <= n2 && n2 <= n3 + token.length) {
                return token;
            }
            token = token.next;
            if ((n3 += token.length) <= n2) continue;
            return null;
        }
        return null;
    }

    public boolean isStringLiteralAt(int n, int n2) {
        Token token = this.findTokenForPosition(n, n2);
        if (token == null) {
            return false;
        }
        if (token.isLiteral()) {
            char c = this.getPendingLiteralChar();
            return c == '\u0000';
        }
        return false;
    }

    public Token getFirstTokenInLine(int n) {
        if (n < 0 || n >= this.length) {
            return null;
        }
        return this.lineStartTokens.get(n);
    }

    public Token getToken(Segment segment, int n) {
        Token token = this.getFirstTokenInLine(n);
        if (token == null) {
            token = this.markTokens(segment, n);
        }
        return token;
    }

    protected Token getPreviousLineToken(int n) {
        Token token = null;
        while (n > 0 && (token = this.getLastTokenInLine(--n)) == null) {
        }
        return token;
    }

    protected synchronized void clearLine(int n) {
        Token token = this.getFirstTokenInLine(n);
        if (token == null) {
            return;
        }
        while (token.next != null) {
            token = token.next;
            token.next = null;
        }
        this.lineStartTokens.set(n, null);
    }

    public synchronized Token markTokens(Segment segment, int n) {
        if (n >= this.length) {
            return null;
        }
        Token token = this.getPreviousLineToken(n);
        this.lineStartTokens.set(n, null);
        this.markTokensImpl(token, segment, n);
        Token token2 = this.getLastTokenInLine(n);
        if (token2 != null) {
            token2.setPendingLiteralChar(this.getPendingLiteralChar());
        }
        return this.lineStartTokens.get(n);
    }

    protected abstract void markTokensImpl(Token var1, Segment var2, int var3);

    public abstract char getPendingLiteralChar();

    public void reset() {
        for (int i = 0; i < this.lineStartTokens.size(); ++i) {
            this.clearLine(i);
        }
        this.lineStartTokens = new ArrayList(250);
        this.length = 0;
    }

    public void insertLines(int n, int n2) {
        if (n2 <= 0) {
            return;
        }
        this.length += n2;
        this.lineStartTokens.ensureCapacity(this.length);
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this.lineStartTokens.add(n, null);
        }
    }

    public void deleteLines(int n, int n2) {
        if (n2 <= 0) {
            return;
        }
        int n3 = n + n2;
        this.length -= n2;
        for (int i = n; i < n3; ++i) {
            this.clearLine(n);
            this.lineStartTokens.remove(n);
        }
    }

    public int getLineCount() {
        return this.length;
    }

    protected Token addToken(int n, int n2, byte by) {
        if (n2 == 0) {
            return null;
        }
        Token token = new Token(n2, by);
        Token token2 = this.lineStartTokens.get(n);
        if (token2 == null) {
            this.lineStartTokens.set(n, token);
        } else {
            while (token2.next != null) {
                token2 = token2.next;
            }
            token2.next = token;
        }
        return token;
    }
}

