/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.filter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import workbench.db.ColumnIdentifier;
import workbench.gui.components.FlatButton;
import workbench.gui.components.TextComponentMouseListener;
import workbench.gui.components.WbTraversalPolicy;
import workbench.gui.filter.ComparatorListItem;
import workbench.gui.filter.ListComboBoxModel;
import workbench.gui.filter.ListValuePicker;
import workbench.interfaces.ValueProvider;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.storage.ResultInfo;
import workbench.storage.filter.ColumnComparator;
import workbench.storage.filter.ColumnExpression;
import workbench.storage.filter.ComparatorFactory;
import workbench.storage.filter.DataRowExpression;
import workbench.storage.filter.ExpressionValue;
import workbench.storage.filter.FilterExpression;
import workbench.util.ValueConverter;

public class ColumnExpressionPanel
extends JPanel
implements ActionListener {
    private final ComparatorFactory factory = new ComparatorFactory();
    private JComboBox comparatorDropDown;
    private JCheckBox ignoreCase;
    protected JComboBox columnSelector;
    private List<ComparatorListItem> comparatorItems;
    private ListComboBoxModel activeItems;
    private ValueProvider filterData;
    protected JTextField valueField;
    protected JButton selectValueButton;
    private ValueConverter converter = new ValueConverter();
    private boolean ignoreComparatorChange;

    public ColumnExpressionPanel(ValueProvider valueProvider, ExpressionValue expressionValue) {
        this.filterData = valueProvider;
        ResultInfo resultInfo = this.filterData.getResultInfo();
        this.comparatorDropDown = new JComboBox();
        this.activeItems = new ListComboBoxModel();
        List<ColumnComparator> list = this.factory.getAvailableComparators();
        this.comparatorItems = new ArrayList<ComparatorListItem>(list.size());
        for (ColumnComparator columnComparator : list) {
            this.comparatorItems.add(new ComparatorListItem(columnComparator));
        }
        this.buildColumnComparatorDropDown(String.class);
        Dimension dimension = this.comparatorDropDown.getPreferredSize();
        this.comparatorDropDown.setPreferredSize(dimension);
        this.comparatorDropDown.setMinimumSize(dimension);
        this.columnSelector = new JComboBox();
        int n = resultInfo.getColumnCount();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        arrayList.add("*");
        for (int i = 0; i < n; ++i) {
            arrayList.add(resultInfo.getColumnName(i));
        }
        ListComboBoxModel listComboBoxModel = new ListComboBoxModel(arrayList);
        this.columnSelector.setModel(listComboBoxModel);
        this.setLayout(new GridBagLayout());
        this.ignoreCase = new JCheckBox(ResourceMgr.getString("LblFilterIgnoreCase"));
        this.ignoreCase.setSelected(false);
        this.ignoreCase.setEnabled(false);
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        this.valueField = new JTextField(10);
        TextComponentMouseListener textComponentMouseListener = new TextComponentMouseListener();
        this.valueField.addMouseListener(textComponentMouseListener);
        jPanel.add((Component)this.valueField, "Center");
        this.selectValueButton = new FlatButton("...");
        this.selectValueButton.addActionListener(this);
        jPanel.add((Component)this.selectValueButton, "East");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.add((Component)this.columnSelector, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)this.comparatorDropDown, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)this.ignoreCase, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.add((Component)jPanel, gridBagConstraints);
        this.columnSelector.addActionListener(this);
        this.comparatorDropDown.addActionListener(this);
        if (expressionValue == null) {
            this.columnSelector.setSelectedIndex(0);
            this.columnSelector.repaint();
        } else {
            this.setExpressionValue(expressionValue);
        }
        WbTraversalPolicy wbTraversalPolicy = new WbTraversalPolicy();
        wbTraversalPolicy.addComponent(this.columnSelector);
        wbTraversalPolicy.addComponent(this.comparatorDropDown);
        wbTraversalPolicy.addComponent(this.ignoreCase);
        wbTraversalPolicy.addComponent(this.valueField);
        this.setFocusTraversalPolicy(wbTraversalPolicy);
    }

    public void selectColumn(String string) {
        int n = this.findColumnInDropDown(string);
        if (n > -1) {
            SwingUtilities.invokeLater(() -> this.columnSelector.setSelectedIndex(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.columnSelector) {
            try {
                this.ignoreComparatorChange = true;
                int n = this.columnSelector.getSelectedIndex();
                if (n == 0) {
                    this.buildColumnComparatorDropDown(String.class);
                } else {
                    ColumnIdentifier columnIdentifier = this.filterData.getResultInfo().getColumn(n - 1);
                    this.buildColumnComparatorDropDown(columnIdentifier);
                }
            }
            finally {
                this.ignoreComparatorChange = false;
            }
            this.checkComparator();
        } else if (actionEvent.getSource() == this.selectValueButton) {
            this.selectColumnValue();
        } else if (!this.ignoreComparatorChange && actionEvent.getSource() == this.comparatorDropDown) {
            this.checkComparator();
        }
    }

    private void selectColumnValue() {
        String string = this.getColumnName();
        if ("*".equals(string)) {
            return;
        }
        String string2 = ListValuePicker.pickValue(this, string, this.filterData, (String)this.getFilterValue());
        if (string2 != null) {
            this.valueField.setText(string2);
        }
    }

    private void checkComparator() {
        try {
            ColumnComparator columnComparator = this.getComparator();
            if (columnComparator != null) {
                this.ignoreCase.setSelected(columnComparator.supportsIgnoreCase());
                this.ignoreCase.setEnabled(columnComparator.supportsIgnoreCase());
                boolean bl = columnComparator.needsValue();
                this.valueField.setEnabled(bl);
                if (bl) {
                    this.valueField.setBackground(Color.WHITE);
                } else {
                    this.valueField.setBackground(this.getBackground());
                }
                String string = this.getColumnName();
                if ("*".equals(string)) {
                    this.selectValueButton.setEnabled(false);
                } else {
                    this.selectValueButton.setEnabled(true);
                }
            } else {
                this.ignoreCase.setSelected(false);
                this.ignoreCase.setEnabled(false);
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when updating comparator", exception);
        }
    }

    private int findColumnInDropDown(String string) {
        ListComboBoxModel listComboBoxModel = (ListComboBoxModel)this.columnSelector.getModel();
        return listComboBoxModel.findItemIgnoreCase(string);
    }

    public final void setExpressionValue(ExpressionValue expressionValue) {
        String string = expressionValue.getColumnName();
        int n = 0;
        if (!"*".equals(string)) {
            n = this.filterData.getResultInfo().findColumn(string);
        }
        if (n > -1) {
            int n2 = this.findColumnInDropDown(string);
            if (n2 > -1) {
                this.columnSelector.setSelectedIndex(n2);
            }
            ComparatorListItem comparatorListItem = new ComparatorListItem(expressionValue.getComparator());
            this.comparatorDropDown.setSelectedItem(comparatorListItem);
            this.ignoreCase.setSelected(expressionValue.isIgnoreCase());
            Object object = expressionValue.getFilterValue();
            if (object != null) {
                this.valueField.setText(object.toString());
            }
        }
    }

    public void setFocusToColumn() {
        this.valueField.requestFocus();
    }

    public String getColumnName() {
        return (String)this.columnSelector.getSelectedItem();
    }

    public boolean validateInput() {
        ColumnComparator columnComparator = this.getComparator();
        if (columnComparator == null) {
            return false;
        }
        Object object = this.getFilterValue();
        return columnComparator.validateInput(object);
    }

    public String getInputValue() {
        return this.valueField.getText();
    }

    public ExpressionValue getExpressionValue() {
        String string = this.getColumnName();
        if (string == null) {
            return null;
        }
        ColumnComparator columnComparator = this.getComparator();
        if (columnComparator == null) {
            return null;
        }
        Object object = this.getFilterValue();
        if (object == null && columnComparator.needsValue()) {
            return null;
        }
        FilterExpression filterExpression = null;
        filterExpression = "*".equals(string) ? new DataRowExpression(columnComparator, object) : new ColumnExpression(string, columnComparator, object);
        if (this.ignoreCase.isEnabled()) {
            filterExpression.setIgnoreCase(this.ignoreCase.isSelected());
        }
        return filterExpression;
    }

    public ColumnComparator getComparator() {
        ComparatorListItem comparatorListItem = (ComparatorListItem)this.comparatorDropDown.getSelectedItem();
        if (comparatorListItem != null) {
            return comparatorListItem.getComparator();
        }
        return null;
    }

    public Object getFilterValue() {
        String string = this.getInputValue();
        String string2 = this.getColumnName();
        int n = this.filterData.getResultInfo().findColumn(string2);
        if (n > -1) {
            int n2 = this.filterData.getResultInfo().getColumnType(n);
            try {
                Object object = this.converter.convertValue(string, n2);
                return object;
            }
            catch (Exception exception) {
                LogMgr.logWarning(new CallerInfo(){}, "Error converting input value", exception);
            }
        }
        return string;
    }

    private void buildColumnComparatorDropDown(ColumnIdentifier columnIdentifier) {
        Class clazz = null;
        try {
            clazz = columnIdentifier.getColumnClass();
            this.buildColumnComparatorDropDown(clazz);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error finding column class", exception);
        }
    }

    private void buildColumnComparatorDropDown(Class clazz) {
        try {
            int n = this.comparatorItems.size();
            int n2 = 0;
            ArrayList<ComparatorListItem> arrayList = new ArrayList<ComparatorListItem>(n);
            for (int i = 0; i < n; ++i) {
                ComparatorListItem comparatorListItem = this.comparatorItems.get(i);
                if (!comparatorListItem.getComparator().supportsType(clazz)) continue;
                arrayList.add(comparatorListItem);
                ++n2;
            }
            this.activeItems.setData(arrayList);
            this.comparatorDropDown.setModel(this.activeItems);
            if (n2 > 0) {
                this.comparatorDropDown.setSelectedIndex(0);
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error building dropdown", exception);
        }
    }
}

