/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.lnf;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.gui.lnf.LnFType;
import workbench.resource.Settings;
import workbench.util.ClasspathUtil;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class LnFDefinition
implements Comparable<LnFDefinition> {
    private String name;
    private String className;
    private List<String> liblist;
    private LnFType type;
    public static final String LNF_PATH_SEPARATOR = "$|$";

    public LnFDefinition(String string) {
        this(string, null, null);
        this.type = LnFType.dynamic;
    }

    public LnFDefinition(String string, String string2) {
        this(string, string2, null);
        this.type = LnFType.builtIn;
    }

    public LnFDefinition(String string, String string2, List<String> list) {
        this.name = string;
        this.className = string2 == null ? string2 : string2.trim();
        this.setLibraries(list);
    }

    private boolean isExtLibs(List<String> list) {
        ClasspathUtil classpathUtil = new ClasspathUtil();
        for (String string : list) {
            String string2 = Settings.getInstance().replaceLibDirKey(string);
            if ("ext".equalsIgnoreCase(string2)) {
                return true;
            }
            File file = new File(string2);
            if (classpathUtil.isInExtDir(file)) continue;
            return false;
        }
        return true;
    }

    public boolean isExt() {
        return this.type == LnFType.ext;
    }

    public boolean isDynamic() {
        return this.type == LnFType.dynamic;
    }

    public boolean isBuiltIn() {
        return this.type == LnFType.builtIn;
    }

    public boolean isComplete() {
        boolean bl = StringUtil.isNonBlank(this.className);
        if (this.type != LnFType.dynamic) {
            return bl;
        }
        return bl && StringUtil.isNonBlank(this.name) && CollectionUtil.isNonEmpty(this.liblist);
    }

    public String debugString() {
        return this.name + ", class: " + this.className + ", type: " + (Object)((Object)this.type);
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public List<String> getLibraries() {
        if (this.type == LnFType.builtIn) {
            return Collections.singletonList("rt.jar");
        }
        if (this.type == LnFType.ext) {
            ClasspathUtil classpathUtil = new ClasspathUtil();
            return CollectionUtil.arrayList(classpathUtil.getExtDir().getAbsolutePath());
        }
        if (CollectionUtil.isEmpty(this.liblist)) {
            return new ArrayList<String>(0);
        }
        return Collections.unmodifiableList(this.liblist);
    }

    public void setLibraries(List<String> list) {
        if (list != null) {
            this.liblist = new ArrayList<String>(list);
            this.type = this.isExtLibs(list) ? LnFType.ext : LnFType.dynamic;
        } else {
            this.liblist = null;
            this.type = LnFType.builtIn;
        }
    }

    public LnFDefinition createCopy() {
        return new LnFDefinition(this.getName(), this.getClassName(), this.liblist);
    }

    @Override
    public int compareTo(LnFDefinition lnFDefinition) {
        String string = lnFDefinition.getClassName();
        return this.className.compareTo(string);
    }

    public boolean equals(Object object) {
        if (object instanceof LnFDefinition) {
            LnFDefinition lnFDefinition = (LnFDefinition)object;
            return this.className.equals(lnFDefinition.className);
        }
        if (object instanceof String) {
            return this.className.equals((String)object);
        }
        return false;
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    public static LnFDefinition newExtLaf(String string, String string2) {
        LnFDefinition lnFDefinition = new LnFDefinition(string, string2);
        lnFDefinition.type = LnFType.ext;
        return lnFDefinition;
    }
}

