/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.macros;

import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import workbench.gui.macros.MacroTreeNode;
import workbench.resource.ResourceMgr;
import workbench.sql.macros.MacroDefinition;
import workbench.sql.macros.MacroGroup;
import workbench.sql.macros.MacroStorage;
import workbench.sql.macros.Sortable;

public class MacroListModel
extends DefaultTreeModel {
    private final MacroTreeNode rootNode = new MacroTreeNode("Macros", true);
    private MacroStorage macros;
    private boolean isPopupTree;

    public MacroListModel(MacroStorage macroStorage, boolean bl) {
        super(new MacroTreeNode("Macros", true), true);
        this.isPopupTree = bl;
        if (macroStorage != null) {
            this.macros = macroStorage.createCopy();
            this.buildTree();
        }
    }

    public MacroStorage getMacros() {
        return this.macros;
    }

    @Override
    public Object getRoot() {
        if (this.rootNode == null) {
            return super.getRoot();
        }
        return this.rootNode;
    }

    public TreePath deleteNode(MacroTreeNode macroTreeNode) {
        if (macroTreeNode == null) {
            return null;
        }
        if (this.macros == null) {
            return null;
        }
        Object object = macroTreeNode.getDataObject();
        if (object instanceof MacroDefinition) {
            this.macros.removeMacro((MacroDefinition)object);
        } else {
            this.macros.removeGroup((MacroGroup)object);
        }
        MacroTreeNode macroTreeNode2 = (MacroTreeNode)macroTreeNode.getParent();
        if (macroTreeNode2 == null) {
            return null;
        }
        MacroTreeNode macroTreeNode3 = (MacroTreeNode)macroTreeNode2.getChildBefore(macroTreeNode);
        if (macroTreeNode3 == null) {
            macroTreeNode3 = (MacroTreeNode)macroTreeNode2.getChildAfter(macroTreeNode);
        }
        this.removeNodeFromParent(macroTreeNode);
        if (macroTreeNode3 != null) {
            return new TreePath(new Object[]{this.rootNode, macroTreeNode2, macroTreeNode3});
        }
        return new TreePath(new Object[]{this.rootNode, macroTreeNode2});
    }

    private MacroTreeNode findNode(Object object) {
        return this.findNode(this.rootNode, object);
    }

    private MacroTreeNode findNode(MacroTreeNode macroTreeNode, Object object) {
        if (object == null) {
            return null;
        }
        int n = macroTreeNode.getChildCount();
        MacroTreeNode macroTreeNode2 = null;
        for (int i = 0; i < n; ++i) {
            MacroTreeNode macroTreeNode3 = (MacroTreeNode)macroTreeNode.getChildAt(i);
            if (macroTreeNode3 == null) continue;
            Object object2 = macroTreeNode3.getDataObject();
            if (object2 != null && object2.equals(object)) {
                return macroTreeNode3;
            }
            if (macroTreeNode3.getAllowsChildren()) {
                macroTreeNode2 = this.findNode(macroTreeNode3, object);
            }
            if (macroTreeNode2 == null) continue;
            return macroTreeNode2;
        }
        return null;
    }

    public TreePath addMacro(MacroGroup macroGroup, MacroDefinition macroDefinition) {
        if (macroDefinition == null) {
            return null;
        }
        if (macroGroup == null) {
            return null;
        }
        MacroTreeNode macroTreeNode = this.findNode(macroGroup);
        if (macroTreeNode != null) {
            MacroTreeNode macroTreeNode2 = new MacroTreeNode(macroDefinition, false);
            this.insertNodeInto(macroTreeNode2, macroTreeNode, macroTreeNode.getChildCount());
            return new TreePath(new Object[]{this.rootNode, macroTreeNode, macroTreeNode2});
        }
        return null;
    }

    public TreePath addGroup(String string) {
        if (string == null) {
            return null;
        }
        if (this.macros == null) {
            return null;
        }
        MacroGroup macroGroup = new MacroGroup(string);
        MacroTreeNode macroTreeNode = new MacroTreeNode(macroGroup, true);
        this.macros.addGroup(macroGroup);
        this.insertNodeInto(macroTreeNode, this.rootNode, this.rootNode.getChildCount());
        return new TreePath(new Object[]{this.rootNode, macroTreeNode});
    }

    public TreePath[] getGroupNodes() {
        if (this.rootNode == null) {
            return null;
        }
        int n = this.rootNode.getChildCount();
        TreePath[] treePathArray = new TreePath[n];
        for (int i = 0; i < n; ++i) {
            TreeNode treeNode = this.rootNode.getChildAt(i);
            if (treeNode == null) continue;
            treePathArray[i] = new TreePath(new Object[]{this.rootNode, treeNode});
        }
        return treePathArray;
    }

    public void sortGroups() {
        if (this.macros == null) {
            return;
        }
        if (this.rootNode == null) {
            return;
        }
        this.macros.sortGroupsByName();
        int n = this.rootNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            MutableTreeNode object = (MutableTreeNode)this.rootNode.getChildAt(i);
            if (object == null) continue;
            this.removeNodeFromParent(object);
        }
        for (MacroGroup macroGroup : this.macros.getGroups()) {
            MacroTreeNode macroTreeNode = new MacroTreeNode(macroGroup, true);
            this.insertNodeInto(macroTreeNode, this.rootNode, this.rootNode.getChildCount());
        }
    }

    public void sortByName(MacroGroup macroGroup) {
        if (this.rootNode == null) {
            return;
        }
        macroGroup.sortByName();
        int n = this.rootNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            MacroGroup macroGroup2;
            MacroTreeNode macroTreeNode = (MacroTreeNode)this.rootNode.getChildAt(i);
            if (macroTreeNode == null || !(macroGroup2 = (MacroGroup)macroTreeNode.getDataObject()).equals(macroGroup)) continue;
            while (macroTreeNode.getChildCount() > 0) {
                MacroTreeNode macroTreeNode2 = (MacroTreeNode)macroTreeNode.getChildAt(0);
                this.removeNodeFromParent(macroTreeNode2);
            }
            for (MacroDefinition macroDefinition : macroGroup.getMacros()) {
                MacroTreeNode macroTreeNode3 = new MacroTreeNode(macroDefinition, false);
                this.insertNodeInto(macroTreeNode3, macroTreeNode, macroTreeNode.getChildCount());
            }
        }
    }

    private void buildTree() {
        if (this.macros == null) {
            return;
        }
        List<MacroGroup> list = this.macros.getGroups();
        this.rootNode.removeAllChildren();
        for (MacroGroup macroGroup : list) {
            if (this.isPopupTree && !macroGroup.isVisibleInPopup()) continue;
            MacroTreeNode macroTreeNode = new MacroTreeNode(macroGroup, true);
            this.rootNode.add(macroTreeNode);
            List<MacroDefinition> list2 = this.isPopupTree ? macroGroup.getMacrosForPopup() : macroGroup.getMacros();
            for (MacroDefinition macroDefinition : list2) {
                MacroTreeNode macroTreeNode2 = new MacroTreeNode(macroDefinition, false);
                macroTreeNode.add(macroTreeNode2);
            }
        }
        this.setRoot(this.rootNode);
    }

    protected void putInFront(MacroTreeNode macroTreeNode, MacroTreeNode macroTreeNode2) {
        if (macroTreeNode == null) {
            return;
        }
        if (macroTreeNode2 == null) {
            return;
        }
        if (this.macros == null) {
            return;
        }
        MacroTreeNode macroTreeNode3 = (MacroTreeNode)macroTreeNode2.getParent();
        if (macroTreeNode3 == null) {
            return;
        }
        MacroTreeNode macroTreeNode4 = (MacroTreeNode)macroTreeNode.getParent();
        if (!macroTreeNode4.equals(macroTreeNode3)) {
            MacroDefinition macroDefinition = (MacroDefinition)macroTreeNode.getDataObject();
            MacroGroup macroGroup = (MacroGroup)macroTreeNode3.getDataObject();
            MacroGroup macroGroup2 = (MacroGroup)macroTreeNode4.getDataObject();
            macroGroup2.removeMacro(macroDefinition);
            macroGroup.addMacro(macroDefinition);
        }
        int n = macroTreeNode3.getIndex(macroTreeNode2);
        this.removeNodeFromParent(macroTreeNode);
        this.insertNodeInto(macroTreeNode, (MacroTreeNode)macroTreeNode2.getParent(), n);
        int n2 = macroTreeNode3.getChildCount();
        for (int i = 0; i < n2; ++i) {
            MacroTreeNode macroTreeNode5 = (MacroTreeNode)macroTreeNode3.getChildAt(i);
            Sortable sortable = (Sortable)macroTreeNode5.getDataObject();
            sortable.setSortOrder(i);
        }
        this.macros.applySort();
    }

    public void copyMacrosToGroup(MacroTreeNode[] macroTreeNodeArray, MacroTreeNode macroTreeNode) {
        if (this.macros == null) {
            return;
        }
        if (!macroTreeNode.getAllowsChildren()) {
            return;
        }
        MacroGroup macroGroup = (MacroGroup)macroTreeNode.getDataObject();
        for (MacroTreeNode macroTreeNode2 : macroTreeNodeArray) {
            if (macroTreeNode2.getAllowsChildren()) continue;
            MacroDefinition macroDefinition = (MacroDefinition)macroTreeNode2.getDataObject();
            MacroDefinition macroDefinition2 = macroDefinition.createCopy();
            macroDefinition2.setName(ResourceMgr.getString("TxtCopyOf") + " " + macroDefinition.getName());
            this.macros.addMacro(macroGroup, macroDefinition2);
            int n = macroTreeNode.getChildCount();
            macroDefinition2.setSortOrder(n + 1);
            this.insertNodeInto(new MacroTreeNode(macroDefinition2, false), macroTreeNode, n);
        }
        this.macros.applySort();
    }

    public void moveMacrosToGroup(MacroTreeNode[] macroTreeNodeArray, MacroTreeNode macroTreeNode) {
        if (this.macros == null) {
            return;
        }
        if (!macroTreeNode.getAllowsChildren()) {
            return;
        }
        MacroGroup macroGroup = (MacroGroup)macroTreeNode.getDataObject();
        for (MacroTreeNode macroTreeNode2 : macroTreeNodeArray) {
            if (macroTreeNode2.getAllowsChildren()) continue;
            MacroDefinition macroDefinition = (MacroDefinition)macroTreeNode2.getDataObject();
            this.macros.moveMacro(macroDefinition, macroGroup);
            this.removeNodeFromParent(macroTreeNode2);
            this.insertNodeInto(macroTreeNode2, macroTreeNode, macroTreeNode.getChildCount());
        }
        for (int i = 0; i < macroTreeNode.getChildCount(); ++i) {
            MacroTreeNode macroTreeNode3 = (MacroTreeNode)macroTreeNode.getChildAt(i);
            MacroDefinition macroDefinition = (MacroDefinition)macroTreeNode3.getDataObject();
            macroDefinition.setSortOrder(i + 1);
        }
        this.macros.applySort();
    }

    public void moveNodes(MacroTreeNode[] macroTreeNodeArray, MacroTreeNode macroTreeNode) {
        boolean bl = true;
        for (MacroTreeNode macroTreeNode2 : macroTreeNodeArray) {
            bl = bl && macroTreeNode2.getAllowsChildren();
        }
        if (bl && macroTreeNode.getAllowsChildren() || macroTreeNodeArray.length == 1 && !macroTreeNode.getAllowsChildren()) {
            this.putInFront(macroTreeNodeArray[0], macroTreeNode);
        } else if (macroTreeNode.getAllowsChildren() && !bl) {
            this.moveMacrosToGroup(macroTreeNodeArray, macroTreeNode);
        }
    }

    public boolean isFiltered() {
        if (this.macros == null) {
            return false;
        }
        return this.macros.isFiltered();
    }

    public void resetFilter() {
        if (this.macros == null) {
            return;
        }
        this.macros.resetFilter();
        this.buildTree();
    }

    public void applyFilter(String string) {
        if (this.macros == null) {
            return;
        }
        this.macros.applyFilter(string);
        this.buildTree();
    }
}

