/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.macros;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.CollapseTreeAction;
import workbench.gui.actions.DeleteListEntryAction;
import workbench.gui.actions.ExpandTreeAction;
import workbench.gui.actions.NewListEntryAction;
import workbench.gui.components.DividerBorder;
import workbench.gui.components.WbSplitPane;
import workbench.gui.components.WbToolbar;
import workbench.gui.macros.MacroDefinitionPanel;
import workbench.gui.macros.MacroGroupPanel;
import workbench.gui.macros.MacroTree;
import workbench.gui.macros.MacroTreeNode;
import workbench.gui.macros.MacroTreeQuickFilter;
import workbench.gui.profiles.NewGroupAction;
import workbench.interfaces.FileActions;
import workbench.resource.Settings;
import workbench.sql.macros.MacroDefinition;
import workbench.sql.macros.MacroGroup;
import workbench.util.StringUtil;

public class MacroManagerGui
extends JPanel
implements FileActions,
TreeSelectionListener,
PropertyChangeListener,
TreeModelListener {
    private JToolBar toolbar;
    private JSplitPane splitPane;
    private MacroDefinitionPanel macroPanel;
    private MacroGroupPanel groupPanel;
    private MacroTree macroTree;
    private MacroTreeQuickFilter filterHandler;

    public MacroManagerGui(int n) {
        this.macroTree = new MacroTree(n, false);
        this.setLayout(new BorderLayout());
        this.toolbar = new WbToolbar();
        this.toolbar.add(new NewListEntryAction(this));
        this.toolbar.add(new NewGroupAction(this.macroTree, "LblNewMacroGroup"));
        this.toolbar.addSeparator();
        JPanel jPanel = new JPanel(new BorderLayout());
        DeleteListEntryAction deleteListEntryAction = new DeleteListEntryAction(this);
        this.toolbar.add(deleteListEntryAction);
        this.toolbar.addSeparator();
        this.toolbar.add(new ExpandTreeAction(this.macroTree));
        this.toolbar.add(new CollapseTreeAction(this.macroTree));
        this.macroTree.addPopupAction(deleteListEntryAction, true);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel.add((Component)this.toolbar, "First");
        this.filterHandler = new MacroTreeQuickFilter(this.macroTree);
        JPanel jPanel3 = this.filterHandler.createFilterPanel();
        jPanel3.setBorder(new DividerBorder(4));
        jPanel.add((Component)jPanel3, "Last");
        jPanel2.add((Component)jPanel, "North");
        this.splitPane = new WbSplitPane();
        this.splitPane.setDividerLocation(140);
        JScrollPane jScrollPane = new JScrollPane(this.macroTree);
        jScrollPane.setBorder(WbSwingUtilities.EMPTY_BORDER);
        jPanel2.add((Component)jScrollPane, "Center");
        this.splitPane.setLeftComponent(jPanel2);
        this.macroPanel = new MacroDefinitionPanel(this);
        this.groupPanel = new MacroGroupPanel(this);
        JPanel jPanel4 = new JPanel();
        jPanel4.setMinimumSize(this.macroPanel.getMinimumSize());
        jPanel4.setPreferredSize(this.macroPanel.getPreferredSize());
        this.splitPane.setRightComponent(jPanel4);
        this.add((Component)this.splitPane, "Center");
        this.macroTree.addTreeSelectionListener(this);
        ToolTipManager.sharedInstance().registerComponent(this.macroTree);
        Dimension dimension = this.macroPanel.getMinimumSize();
        Dimension dimension2 = this.macroTree.getMinimumSize();
        int n2 = Math.max(dimension.height, dimension2.height);
        int n3 = dimension.width + dimension2.width;
        Dimension dimension3 = new Dimension(n3, n2);
        this.splitPane.setMinimumSize(dimension3);
        Dimension dimension4 = new Dimension(dimension3.width + 15, dimension3.height + 15);
        this.setMinimumSize(dimension4);
    }

    public void dispose() {
        ToolTipManager.sharedInstance().unregisterComponent(this.macroTree);
    }

    public void setCurrentConnection(WbConnection wbConnection) {
        this.macroPanel.setCurrentConnection(wbConnection);
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.macroTree.addTreeSelectionListener(treeSelectionListener);
    }

    public MacroDefinition getSelectedMacro() {
        return this.macroTree.getSelectedMacro();
    }

    @Override
    public void deleteItem() throws Exception {
        this.macroTree.deleteSelection();
        this.macroTree.repaint();
    }

    @Override
    public void newItem(boolean bl) {
        boolean bl2 = this.macroTree.addMacro(bl);
        if (bl2) {
            this.macroPanel.selectMacroName();
        }
    }

    private void selectListLater() {
        EventQueue.invokeLater(this.macroTree::requestFocusInWindow);
    }

    @Override
    public void saveItem() throws Exception {
        this.macroPanel.applyChanges();
        this.macroTree.saveChanges();
    }

    public void saveSettings() {
        int n = this.splitPane.getDividerLocation();
        Settings.getInstance().setProperty(this.getClass().getName() + ".divider", n);
        MacroDefinition macroDefinition = this.getSelectedMacro();
        Settings.getInstance().setProperty(this.getClass().getName() + ".lastmacro", macroDefinition == null ? "" : macroDefinition.getName());
        MacroGroup macroGroup = this.macroTree.getCurrentGroup();
        Settings.getInstance().setProperty(this.getClass().getName() + ".lastmacrogroup", macroGroup == null ? "" : macroGroup.getName());
        List<String> list = this.macroTree.getExpandedGroupNames();
        Settings.getInstance().setProperty(this.getClass().getName() + ".expandedgroups", StringUtil.listToString(list, ',', true));
    }

    public void restoreSettings() {
        int n = Settings.getInstance().getIntProperty(this.getClass().getName() + ".divider", 190);
        this.splitPane.setDividerLocation(n);
        String string = Settings.getInstance().getProperty(this.getClass().getName() + ".lastmacro", null);
        String string2 = Settings.getInstance().getProperty(this.getClass().getName() + ".lastmacrogroup", null);
        this.macroTree.selectMacro(string2, string);
        String string3 = Settings.getInstance().getProperty(this.getClass().getName() + ".expandedgroups", null);
        List<String> list = StringUtil.stringToList(string3, ",", true, true);
        this.macroTree.expandGroups(list);
        this.selectListLater();
    }

    private void showGroup(MacroGroup macroGroup) {
        this.macroPanel.setMacro(null);
        this.groupPanel.setMacroGroup(macroGroup);
        this.changePanel(this.groupPanel);
    }

    private void showMacro(MacroDefinition macroDefinition) {
        this.groupPanel.setMacroGroup(null);
        this.macroPanel.setMacro(macroDefinition);
        this.changePanel(this.macroPanel);
    }

    private void changePanel(JPanel jPanel) {
        int n = this.splitPane.getDividerLocation();
        this.splitPane.setRightComponent(jPanel);
        this.splitPane.setDividerLocation(n);
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.macroTree.repaint();
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getPath();
        if (treePath == null) {
            return;
        }
        MacroTreeNode macroTreeNode = (MacroTreeNode)treePath.getLastPathComponent();
        if (macroTreeNode.getAllowsChildren()) {
            MacroGroup macroGroup = (MacroGroup)macroTreeNode.getDataObject();
            this.showGroup(macroGroup);
        } else {
            MacroDefinition macroDefinition = (MacroDefinition)macroTreeNode.getDataObject();
            this.showMacro(macroDefinition);
        }
    }
}

