/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.macros;

import java.util.List;
import javax.swing.JMenu;
import workbench.gui.MainWindow;
import workbench.gui.actions.RunMacroAction;
import workbench.gui.components.WbMenu;
import workbench.gui.components.WbTable;
import workbench.resource.ResourceMgr;
import workbench.sql.annotations.MacroAnnotation;
import workbench.sql.macros.MacroDefinition;
import workbench.sql.macros.MacroGroup;
import workbench.sql.macros.MacroManager;
import workbench.sql.macros.MacroStorage;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class MacroMenuBuilder {
    public static final String MENU_ITEM_NAME = "macroDataMenu";

    public void buildMacroMenu(MainWindow mainWindow, JMenu jMenu) {
        MacroStorage macroStorage = MacroManager.getInstance().getMacros(mainWindow.getMacroClientId());
        if (macroStorage == null) {
            return;
        }
        List<MacroGroup> list = macroStorage.getVisibleGroups();
        if (list == null || list.isEmpty()) {
            return;
        }
        jMenu.addSeparator();
        int n = list.size();
        int n2 = 0;
        for (MacroGroup macroGroup : list) {
            WbMenu wbMenu = n > 1 ? new WbMenu(macroGroup.getName(), ++n2) : null;
            List<MacroDefinition> list2 = macroGroup.getVisibleMacros();
            int n3 = 1;
            for (MacroDefinition macroDefinition : list2) {
                if (StringUtil.isBlank(macroDefinition.getText())) continue;
                RunMacroAction runMacroAction = new RunMacroAction(mainWindow, macroDefinition, n3);
                if (wbMenu == null) {
                    runMacroAction.addToMenu(jMenu);
                } else {
                    runMacroAction.addToMenu(wbMenu);
                }
                ++n3;
            }
            if (wbMenu == null) continue;
            jMenu.add(wbMenu);
        }
    }

    public WbMenu buildDataMacroMenu(MainWindow mainWindow, WbTable wbTable, List<MacroAnnotation> list) {
        if (wbTable == null) {
            return null;
        }
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        MacroStorage macroStorage = MacroManager.getInstance().getMacros(mainWindow.getMacroClientId());
        if (macroStorage == null) {
            return null;
        }
        WbMenu wbMenu = new WbMenu(ResourceMgr.getString("MnuTxtMacro"));
        wbMenu.setName(MENU_ITEM_NAME);
        for (MacroAnnotation macroAnnotation : list) {
            MacroDefinition macroDefinition = macroStorage.getMacro(macroAnnotation.getMacroName());
            if (macroDefinition == null) continue;
            RunMacroAction runMacroAction = new RunMacroAction(mainWindow, macroDefinition, -1);
            runMacroAction.setTooltip(null);
            runMacroAction.setDataTable(wbTable, macroAnnotation.getColumnMap());
            runMacroAction.addToMenu(wbMenu);
        }
        return wbMenu;
    }
}

