/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.profiles;

import java.awt.Component;
import java.awt.Window;
import javax.swing.JCheckBox;
import workbench.db.ConnectionProfile;
import workbench.gui.components.MapEditor;
import workbench.gui.components.ValidatingDialog;
import workbench.interfaces.FileActions;
import workbench.resource.ResourceMgr;
import workbench.storage.DataStore;

public class ConnectionPropertiesEditor
extends MapEditor
implements FileActions {
    private JCheckBox copyProps = new JCheckBox(ResourceMgr.getString("LblCpProps2System"));

    public ConnectionPropertiesEditor(ConnectionProfile connectionProfile) {
        super(connectionProfile.getConnectionProperties());
        this.copyProps.setToolTipText(ResourceMgr.getDescription("LblCpProps2System"));
        this.add((Component)this.copyProps, "South");
        this.copyProps.setSelected(connectionProfile.getCopyExtendedPropsToSystem());
    }

    @Override
    protected DataStore createDataStore() {
        String[] stringArray = new String[]{ResourceMgr.getString("TxtConnDataPropName"), ResourceMgr.getString("TxtConnDataPropValue")};
        int[] nArray = new int[]{12, 12};
        int[] nArray2 = new int[]{15, 5};
        return new DataStore(stringArray, nArray, nArray2);
    }

    public boolean getCopyToSystem() {
        return this.copyProps.isSelected();
    }

    public static void editProperties(Window window, ConnectionProfile connectionProfile) {
        ConnectionPropertiesEditor connectionPropertiesEditor = new ConnectionPropertiesEditor(connectionProfile);
        connectionPropertiesEditor.optimizeColumnWidths();
        boolean bl = ValidatingDialog.showConfirmDialog(window, connectionPropertiesEditor, ResourceMgr.getString("TxtEditConnPropsWindowTitle"));
        if (bl) {
            connectionProfile.setConnectionProperties(connectionPropertiesEditor.getProperties());
            connectionProfile.setCopyExtendedPropsToSystem(connectionPropertiesEditor.getCopyToSystem());
        }
    }
}

