/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.profiles;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import workbench.db.ConnectionMgr;
import workbench.db.ConnectionProfile;
import workbench.db.DbDriver;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.CollapseTreeAction;
import workbench.gui.actions.CopyProfileAction;
import workbench.gui.actions.DeleteListEntryAction;
import workbench.gui.actions.ExpandTreeAction;
import workbench.gui.actions.NewListEntryAction;
import workbench.gui.actions.QuickFilterAction;
import workbench.gui.actions.SaveListFileAction;
import workbench.gui.actions.WbAction;
import workbench.gui.components.DividerBorder;
import workbench.gui.components.WbLabel;
import workbench.gui.components.WbSplitPane;
import workbench.gui.components.WbToolbar;
import workbench.gui.components.WbTraversalPolicy;
import workbench.gui.profiles.ConnectionEditorPanel;
import workbench.gui.profiles.NewGroupAction;
import workbench.gui.profiles.ProfileChangeListener;
import workbench.gui.profiles.ProfileKey;
import workbench.gui.profiles.ProfileListModel;
import workbench.gui.profiles.ProfileTree;
import workbench.gui.profiles.TagSearchPopup;
import workbench.interfaces.FileActions;
import workbench.interfaces.QuickFilter;
import workbench.interfaces.ValidatingComponent;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class ProfileSelectionPanel
extends JPanel
implements FileActions,
ValidatingComponent,
PropertyChangeListener,
KeyListener,
QuickFilter {
    private ProfileListModel model;
    private WbToolbar toolbar;
    protected ConnectionEditorPanel connectionEditor;
    private Consumer selectionListener;
    private NewListEntryAction newItem;
    private CopyProfileAction copyItem;
    private JTextField filterValue;
    protected boolean dummyAdded;
    private List<String> orgExpandedGroups;
    private ConnectionProfile initialProfile;
    private WbAction resetFilter;
    private QuickFilterAction applyFilter;
    protected JSplitPane jSplitPane;
    protected JPanel listPanel;
    protected JTree profileTree;
    protected JScrollPane treeScroll;

    public ProfileSelectionPanel(String string) {
        Object object;
        Object object2;
        this.initComponents();
        this.connectionEditor = new ConnectionEditorPanel();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.connectionEditor, "Center");
        this.jSplitPane.setRightComponent(jPanel);
        this.fillDrivers();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.toolbar = new WbToolbar();
        this.newItem = new NewListEntryAction(this, "LblNewProfile");
        this.newItem.setIcon("new-profile");
        this.toolbar.add(this.newItem);
        this.copyItem = new CopyProfileAction(this);
        this.copyItem.setEnabled(false);
        this.toolbar.add(this.copyItem);
        ProfileTree profileTree = (ProfileTree)this.profileTree;
        this.treeScroll.setBorder(WbSwingUtilities.EMPTY_BORDER);
        this.toolbar.add(new NewGroupAction(profileTree, "LblNewProfileGroup"));
        this.toolbar.addSeparator();
        this.toolbar.add(this.getDeleteAction());
        this.toolbar.addSeparator();
        SaveListFileAction saveListFileAction = new SaveListFileAction(this);
        String string2 = saveListFileAction.getToolTipText();
        List<WbFile> list = ConnectionMgr.getInstance().getProfileSources();
        String string3 = list.stream().map(wbFile -> wbFile.getFullPath()).collect(Collectors.joining(",\n"));
        string2 = string2 + "\n" + string3;
        saveListFileAction.setTooltip(string2);
        this.toolbar.add(saveListFileAction);
        this.toolbar.addSeparator();
        this.toolbar.add(new ExpandTreeAction(profileTree));
        this.toolbar.add(new CollapseTreeAction(profileTree));
        jPanel2.add((Component)this.toolbar, "First");
        if (GuiSettings.enableProfileQuickFilter()) {
            this.applyFilter = new QuickFilterAction(this);
            this.resetFilter = new WbAction(){

                @Override
                public void executeAction(ActionEvent actionEvent) {
                    ProfileSelectionPanel.this.resetFilter();
                }
            };
            this.resetFilter.setIcon("resetfilter");
            this.resetFilter.setEnabled(true);
            object2 = new JPanel(new BorderLayout(0, 1));
            ((JComponent)object2).setBorder(new DividerBorder(4));
            this.filterValue = new JTextField();
            object = new WbLabel();
            ((WbLabel)object).setTextByKey("LblConnFilter");
            ((JLabel)object).setLabelFor(this.filterValue);
            ((JComponent)object).setBorder(new EmptyBorder(0, 5, 0, 5));
            ((Container)object2).add((Component)object, "Before");
            ((Container)object2).add((Component)this.filterValue, "Center");
            WbToolbar wbToolbar = new WbToolbar();
            wbToolbar.add(this.applyFilter);
            wbToolbar.add(this.resetFilter);
            wbToolbar.setMargin(WbSwingUtilities.getEmptyInsets());
            wbToolbar.setBorderPainted(true);
            ((Container)object2).add((Component)wbToolbar, "After");
            jPanel2.add((Component)object2, "Last");
            this.filterValue.setToolTipText(ResourceMgr.getDescription("LblConnTagFilter", true));
        }
        this.listPanel.add((Component)jPanel2, "North");
        object2 = new WbTraversalPolicy();
        this.setFocusCycleRoot(false);
        ((WbTraversalPolicy)object2).addComponent(this.profileTree);
        ((WbTraversalPolicy)object2).addComponent(this.connectionEditor);
        ((WbTraversalPolicy)object2).setDefaultComponent(this.profileTree);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)object2);
        this.buildTree();
        this.restoreSettings();
        object = Settings.getInstance().getLastConnection(string);
        ((ProfileTree)this.profileTree).selectProfile((ProfileKey)object);
        ConnectionMgr.getInstance().addDriverChangeListener(this);
        if (this.filterValue != null) {
            this.filterValue.addKeyListener(this);
        }
    }

    private DeleteListEntryAction getDeleteAction() {
        return ((ProfileTree)this.profileTree).getDeleteAction();
    }

    private void showTagPopup() {
        TagSearchPopup tagSearchPopup = new TagSearchPopup(this.filterValue, this.model.getAllTags(), this);
        tagSearchPopup.showPopup();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        EventQueue.invokeLater(this::applyQuickFilter);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 32 && WbAction.isCtrlPressed(keyEvent.getModifiers())) {
            keyEvent.consume();
            EventQueue.invokeLater(this::showTagPopup);
            return;
        }
        if (keyEvent.getModifiers() != 0) {
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 33: 
            case 34: 
            case 38: 
            case 40: {
                this.profileTree.dispatchEvent(keyEvent);
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 39: {
                if (!StringUtil.isBlank(this.filterValue.getText())) break;
                this.profileTree.dispatchEvent(keyEvent);
                break;
            }
            case 27: {
                if (!StringUtil.isNonBlank(this.filterValue.getText())) break;
                keyEvent.consume();
                this.resetFilter();
            }
        }
    }

    public void initDivider() {
        this.jSplitPane.setDividerLocation(0.3);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void resetFilter() {
        ConnectionProfile connectionProfile = null;
        connectionProfile = GuiSettings.restoreProfileSelectionBeforeFilter() ? this.initialProfile : this.getSelectedProfile();
        this.filterValue.setText("");
        this.model.resetFilter();
        ProfileTree profileTree = (ProfileTree)this.profileTree;
        if (this.orgExpandedGroups != null) {
            profileTree.expandGroups(this.orgExpandedGroups);
        }
        if (connectionProfile != null) {
            profileTree.selectProfile(connectionProfile.getKey());
        } else {
            profileTree.selectFirstProfile();
        }
    }

    @Override
    public void applyQuickFilter() {
        if (this.orgExpandedGroups == null) {
            this.orgExpandedGroups = ((ProfileTree)this.profileTree).getExpandedGroupNames();
        }
        ProfileTree profileTree = (ProfileTree)this.profileTree;
        ConnectionProfile connectionProfile = profileTree.getSelectedProfile();
        if (this.initialProfile == null) {
            this.initialProfile = connectionProfile;
        }
        boolean bl = true;
        String string = this.filterValue.getText().trim();
        if (string.isEmpty()) {
            this.resetFilter();
        } else {
            if (string.length() >= GuiSettings.getMinTagLength()) {
                Set<String> set = CollectionUtil.caseInsensitiveSet();
                set.addAll(StringUtil.stringToList(string, ",", true, true, false, false));
                Set<String> set2 = this.model.getAllTags();
                if (CollectionUtil.containsAny(set2, set)) {
                    this.model.applyTagFilter(set);
                    bl = false;
                }
            }
            if (bl) {
                this.model.applyNameFilter(string);
            }
            if (this.model.isFiltered()) {
                profileTree.expandAll();
                if (connectionProfile != null) {
                    profileTree.selectProfile(connectionProfile.getKey());
                } else {
                    profileTree.selectFirstProfile();
                }
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("drivers")) {
            EventQueue.invokeLater(this::fillDrivers);
        }
    }

    public void done() {
        ConnectionMgr.getInstance().removeDriverChangeListener(this);
    }

    public JComponent getInitialFocusComponent() {
        if (this.dummyAdded) {
            return this.connectionEditor.getInitialFocusComponent();
        }
        if (this.filterValue != null && GuiSettings.focusToProfileQuickFilter()) {
            return this.filterValue;
        }
        return this.profileTree;
    }

    public void addSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.profileTree.addTreeSelectionListener(treeSelectionListener);
    }

    public DbDriver getCurrentDriver() {
        return this.connectionEditor.getCurrentDriver();
    }

    public final void fillDrivers() {
        List<DbDriver> list = ConnectionMgr.getInstance().getDrivers();
        this.connectionEditor.setDrivers(list);
    }

    public final void restoreSettings() {
        int n = GuiSettings.getProfileDividerLocation();
        if (n < 200) {
            n = 200;
        }
        this.jSplitPane.setDividerLocation(n);
        if (GuiSettings.getRestoreExpandedProfiles()) {
            String string = Settings.getInstance().getProperty("workbench.profiles.expandedgroups", null);
            List<String> list = StringUtil.stringToList(string, ",", true, true);
            ((ProfileTree)this.profileTree).expandGroups(list);
        }
    }

    public boolean profilesChanged() {
        ProfileListModel profileListModel = (ProfileListModel)this.profileTree.getModel();
        return profileListModel.profilesAreModified();
    }

    public boolean groupsChanged() {
        ProfileListModel profileListModel = (ProfileListModel)this.profileTree.getModel();
        return profileListModel.groupsChanged();
    }

    public void applyProfiles() {
        this.connectionEditor.updateProfile();
        ProfileListModel profileListModel = (ProfileListModel)this.profileTree.getModel();
        profileListModel.applyProfiles();
    }

    public void saveSettings() {
        GuiSettings.setProfileDividerLocation(this.jSplitPane.getDividerLocation());
        List<String> list = this.orgExpandedGroups;
        if (list == null) {
            list = ((ProfileTree)this.profileTree).getExpandedGroupNames();
        }
        Settings.getInstance().setProperty("workbench.profiles.expandedgroups", StringUtil.listToString(list, ',', true));
    }

    private void buildTree() {
        this.dummyAdded = false;
        this.model = new ProfileListModel(ConnectionMgr.getInstance().getProfiles());
        if (this.model.getSize() < 1) {
            this.model.addEmptyProfile();
            this.dummyAdded = true;
        }
        this.profileTree.setModel(this.model);
        this.connectionEditor.addProfileChangeListener(this.model);
    }

    public void addProfileChangelistener(ProfileChangeListener profileChangeListener) {
        this.connectionEditor.addProfileChangeListener(profileChangeListener);
    }

    public ConnectionProfile getSelectedProfile() {
        return ((ProfileTree)this.profileTree).getSelectedProfile();
    }

    public void addProfileSelectionListener(Consumer<MouseEvent> consumer) {
        this.selectionListener = consumer;
    }

    @Override
    public void deleteItem() throws Exception {
        ((ProfileTree)this.profileTree).deleteSelectedItem();
    }

    private boolean shouldPromptForStorage() {
        return ConnectionMgr.getInstance().getProfileSources().size() > 1;
    }

    private WbFile promptForStorage() {
        List<WbFile> list = ConnectionMgr.getInstance().getProfileSources();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JComboBox<WbFile> jComboBox = new JComboBox<WbFile>(list.toArray(new WbFile[0]));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)new JLabel(ResourceMgr.getString("LblProfileFiles1")), gridBagConstraints);
        int n = IconMgr.getInstance().getSizeForLabel() / 4;
        gridBagConstraints.insets = new Insets(n, 0, n, 0);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel(ResourceMgr.getString("LblProfileFiles2")), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add(jComboBox, gridBagConstraints);
        jPanel.setBorder(new EmptyBorder(0, 0, IconMgr.getInstance().getToolbarIconSize(), 0));
        boolean bl = WbSwingUtilities.getOKCancel(ResourceMgr.getString("TxtSelectProfileStorage"), this, jPanel);
        if (bl) {
            int n2 = jComboBox.getSelectedIndex();
            return list.get(n2);
        }
        return null;
    }

    @Override
    public void newItem(boolean bl) {
        Serializable serializable;
        ConnectionProfile connectionProfile = null;
        WbFile wbFile = null;
        if (this.shouldPromptForStorage() && (wbFile = this.promptForStorage()) == null) {
            return;
        }
        if (bl && (serializable = this.getSelectedProfile()) != null) {
            connectionProfile = ((ConnectionProfile)serializable).createCopy();
            connectionProfile.setName(ResourceMgr.getString("TxtCopyOf") + " " + ((ConnectionProfile)serializable).getName());
        }
        if (connectionProfile == null) {
            connectionProfile = ConnectionProfile.createEmptyProfile();
            connectionProfile.setGroup(this.getCurrentGroup());
        }
        connectionProfile.setNew();
        serializable = this.model.addProfile(connectionProfile);
        if (wbFile != null) {
            ConnectionMgr.getInstance().setProfileSource(connectionProfile, wbFile);
        }
        ((ProfileTree)this.profileTree).selectPath((TreePath)serializable);
    }

    private String getCurrentGroup() {
        TreePath treePath = this.profileTree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        if (treePath.getPathCount() == 2) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        }
        if (treePath.getPathCount() > 2) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(1);
        }
        if (defaultMutableTreeNode == null) {
            return null;
        }
        if (defaultMutableTreeNode.getAllowsChildren()) {
            String string = (String)defaultMutableTreeNode.getUserObject();
            return string;
        }
        return null;
    }

    @Override
    public void saveItem() throws Exception {
        this.connectionEditor.updateProfile();
        ProfileListModel profileListModel = (ProfileListModel)this.profileTree.getModel();
        profileListModel.saveProfiles();
    }

    public int getProfileCount() {
        return this.profileTree.getRowCount();
    }

    @Override
    public boolean validateInput() {
        return this.connectionEditor.validateInput();
    }

    @Override
    public void componentWillBeClosed() {
    }

    @Override
    public void componentDisplayed() {
    }

    private void initComponents() {
        this.jSplitPane = new WbSplitPane();
        this.listPanel = new JPanel();
        this.treeScroll = new JScrollPane();
        this.profileTree = new ProfileTree();
        FormListener formListener = new FormListener();
        this.setLayout(new BorderLayout());
        this.jSplitPane.setBorder(BorderFactory.createEtchedBorder());
        this.jSplitPane.setDividerLocation(110);
        this.jSplitPane.setMinimumSize(new Dimension(400, 400));
        this.listPanel.setLayout(new BorderLayout());
        this.treeScroll.setPreferredSize(null);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Profiles");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Postgres");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Dev");
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode("QA");
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode("Production");
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode("yellow");
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("Oracle");
        defaultMutableTreeNode3 = new DefaultMutableTreeNode("Dev");
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode("QA");
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode("Production");
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        this.profileTree.setModel(new DefaultTreeModel(defaultMutableTreeNode));
        this.profileTree.setMinimumSize(new Dimension(150, 400));
        this.profileTree.setName("profileTree");
        this.profileTree.addMouseListener(formListener);
        this.profileTree.addTreeSelectionListener(formListener);
        this.treeScroll.setViewportView(this.profileTree);
        this.listPanel.add((Component)this.treeScroll, "Center");
        this.jSplitPane.setLeftComponent(this.listPanel);
        this.add((Component)this.jSplitPane, "Center");
    }

    private void profileTreeMouseClicked(MouseEvent mouseEvent) {
        if (this.selectionListener != null && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
            Point point = mouseEvent.getPoint();
            TreePath treePath = this.profileTree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            TreePath treePath2 = this.profileTree.getClosestPathForLocation((int)point.getX(), (int)point.getY());
            if (!treePath2.isDescendant(treePath)) {
                return;
            }
            TreeNode treeNode = (TreeNode)treePath2.getLastPathComponent();
            if (treeNode.isLeaf()) {
                this.selectionListener.accept(mouseEvent);
            }
        }
    }

    private void profileTreeValueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.connectionEditor == null) {
            return;
        }
        if (treeSelectionEvent.getSource() == this.profileTree) {
            try {
                ConnectionProfile connectionProfile = this.getSelectedProfile();
                if (connectionProfile != null) {
                    if (!this.connectionEditor.isVisible()) {
                        this.connectionEditor.setVisible(true);
                    }
                    this.connectionEditor.setProfile(connectionProfile);
                    this.connectionEditor.setAllTags(this.model.getAllTags());
                    this.getDeleteAction().setEnabled(true);
                    this.copyItem.setEnabled(true);
                } else {
                    this.connectionEditor.setVisible(false);
                    this.getDeleteAction().setEnabled(true);
                    this.copyItem.setEnabled(false);
                }
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error selecting new profile", exception);
            }
        }
    }

    private class FormListener
    implements MouseListener,
    TreeSelectionListener {
        FormListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == ProfileSelectionPanel.this.profileTree) {
                ProfileSelectionPanel.this.profileTreeMouseClicked(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (treeSelectionEvent.getSource() == ProfileSelectionPanel.this.profileTree) {
                ProfileSelectionPanel.this.profileTreeValueChanged(treeSelectionEvent);
            }
        }
    }
}

