/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.FlatButton;
import workbench.gui.renderer.ToolTipRenderer;
import workbench.gui.renderer.WbRenderer;
import workbench.resource.IconMgr;
import workbench.util.StringUtil;

public class ButtonDisplayPanel
extends JPanel
implements WbRenderer {
    private final int BUTTON_WIDTH = IconMgr.getInstance().getSizeForLabel();
    private FlatButton openButton = new FlatButton("...");
    private JLabel label = new JLabel();
    private Insets insets = ToolTipRenderer.getDefaultInsets();

    public ButtonDisplayPanel() {
        this.setLayout(new GridBagLayout());
        Dimension dimension = new Dimension(this.BUTTON_WIDTH, this.BUTTON_WIDTH);
        this.openButton.setBasicUI();
        this.openButton.setFlatLook();
        this.openButton.setBorder(WbSwingUtilities.FLAT_BUTTON_BORDER);
        this.openButton.setPreferredSize(dimension);
        this.openButton.setMinimumSize(dimension);
        this.openButton.setEnabled(true);
        this.openButton.setFocusable(false);
        this.label.setHorizontalTextPosition(2);
        this.label.setVerticalTextPosition(1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.label, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.openButton, gridBagConstraints);
        this.openButton.setVisible(true);
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    public int getButtonWidth() {
        if (this.openButton != null && this.openButton.isVisible()) {
            return this.BUTTON_WIDTH;
        }
        return 0;
    }

    public void setDisplayValue(String string) {
        this.label.setText(StringUtil.coalesce(string, ""));
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.openButton != null) {
            this.openButton.addActionListener(actionListener);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.openButton != null) {
            this.openButton.removeActionListener(actionListener);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.label != null) {
            this.label.setFont(font);
        }
    }

    public String getLabel() {
        return this.label.getText();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.label != null) {
            this.label.setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.label != null) {
            this.label.setForeground(color);
        }
    }

    @Override
    public String getDisplayValue() {
        return this.getLabel();
    }

    @Override
    public int getHorizontalAlignment() {
        return 2;
    }

    @Override
    public void prepareDisplay(Object object) {
    }

    @Override
    public int calculateDisplaySize(Object object) {
        int n = (int)((double)this.BUTTON_WIDTH * 1.1);
        if (object == null) {
            return n;
        }
        Font font = this.getFont();
        if (font == null) {
            return -1;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return -1;
        }
        int n2 = fontMetrics.stringWidth(this.getLabel()) + n + this.insets.left + this.insets.right;
        return n2;
    }
}

