/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.renderer;

import java.util.Map;
import javax.swing.JPanel;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.MapEditor;
import workbench.gui.components.ValidatingDialog;
import workbench.gui.renderer.AbstractDialogRenderer;
import workbench.gui.renderer.ButtonDisplayPanel;
import workbench.resource.Settings;
import workbench.storage.DataStore;

public class MapColumnRenderer
extends AbstractDialogRenderer {
    private final String CONFIG_PROP = "workbench.gui.mapeditor";
    private ButtonDisplayPanel display;

    @Override
    protected JPanel createDisplayPanel() {
        this.display = new ButtonDisplayPanel();
        this.display.addActionListener(this);
        return this.display;
    }

    @Override
    protected void setCurrentValue(Object object) {
        this.display.setDisplayValue(object == null ? "" : object.toString());
    }

    @Override
    protected void showEditDialog(boolean bl, boolean bl2, boolean bl3) {
        Map map = null;
        if (this.currentValue instanceof Map) {
            map = (Map)this.currentValue;
        }
        MapEditor mapEditor = new MapEditor(map){

            @Override
            protected DataStore createDataStore() {
                String[] stringArray = new String[]{"Key", "Value"};
                int[] nArray = new int[]{12, 12};
                int[] nArray2 = new int[]{15, 25};
                return new DataStore(stringArray, nArray, nArray2);
            }
        };
        ValidatingDialog validatingDialog = ValidatingDialog.createDialog(WbSwingUtilities.getWindowAncestor(this.currentTable), mapEditor, "Edit", null, 0, false);
        if (!Settings.getInstance().restoreWindowSize(validatingDialog, "workbench.gui.mapeditor")) {
            validatingDialog.setSize(400, 300);
        }
        mapEditor.optimizeColumnWidths();
        mapEditor.setEditable(bl);
        validatingDialog.setVisible(true);
        Settings.getInstance().storeWindowSize(validatingDialog, "workbench.gui.mapeditor");
        if (!validatingDialog.isCancelled() && mapEditor.isModified()) {
            Map<String, String> map2 = mapEditor.getMap();
            this.currentTable.setValueAt(map2, this.currentRow, this.currentColumn);
            this.currentValue = map2;
        }
    }
}

