/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.renderer;

import java.math.BigDecimal;
import workbench.gui.renderer.ToolTipRenderer;
import workbench.resource.GuiSettings;
import workbench.util.WbNumberFormatter;

public class NumberColumnRenderer
extends ToolTipRenderer {
    private WbNumberFormatter formatter;

    public NumberColumnRenderer() {
        this.formatter = new WbNumberFormatter(4, '.');
        this.setHorizontalAlignment(GuiSettings.getNumberDataAlignment());
    }

    public NumberColumnRenderer(int n, char c) {
        this(n, c, false);
    }

    public NumberColumnRenderer(int n, char c, boolean bl) {
        this.formatter = new WbNumberFormatter(n, c, bl);
        this.setHorizontalAlignment(GuiSettings.getNumberDataAlignment());
    }

    public NumberColumnRenderer(String string, char c, char c2) {
        this.formatter = new WbNumberFormatter(string, c, c2);
        this.setHorizontalAlignment(GuiSettings.getNumberDataAlignment());
    }

    @Override
    public void prepareDisplay(Object object) {
        try {
            Number number = (Number)object;
            this.displayValue = this.formatter.format(number);
            this.tooltip = this.showTooltip ? (number instanceof BigDecimal ? ((BigDecimal)number).toPlainString() : number.toString()) : null;
        }
        catch (Throwable throwable) {
            this.displayValue = object.toString();
            this.tooltip = null;
        }
    }
}

