/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.renderer;

import workbench.gui.renderer.ToolTipRenderer;
import workbench.util.NumberStringCache;
import workbench.util.SqlUtil;

public class SqlTypeRenderer
extends ToolTipRenderer {
    private boolean showNumericValue;

    public SqlTypeRenderer() {
        this(false);
    }

    public SqlTypeRenderer(boolean bl) {
        this.setHorizontalAlignment(2);
        this.showNumericValue = bl;
    }

    @Override
    public void prepareDisplay(Object object) {
        if (object != null) {
            int n = -1;
            try {
                n = (Integer)object;
                this.displayValue = SqlUtil.getTypeName(n);
                StringBuilder stringBuilder = new StringBuilder(this.displayValue.length() + 8);
                stringBuilder.append(this.displayValue);
                stringBuilder.append(" (");
                stringBuilder.append(NumberStringCache.getNumberString(n));
                stringBuilder.append(')');
                String string = stringBuilder.toString();
                this.setTooltip(string);
                if (this.showNumericValue) {
                    this.displayValue = string;
                }
            }
            catch (Exception exception) {
                this.displayValue = object.toString();
                this.setTooltip(this.displayValue);
            }
        } else {
            this.displayValue = "";
            this.setTooltip(null);
        }
    }
}

