/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import workbench.gui.renderer.WbRenderer;
import workbench.gui.settings.ActionDisplay;
import workbench.resource.GuiSettings;

public class ActionDisplayRenderer
extends DefaultTableCellRenderer
implements WbRenderer {
    private boolean useAlternateColors = false;
    private Color alternateBackground = GuiSettings.getAlternateRowColor();

    public ActionDisplayRenderer() {
        this.useAlternateColors = GuiSettings.getUseAlternateRowColor();
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        try {
            boolean bl3;
            ActionDisplay actionDisplay = (ActionDisplay)object;
            this.setToolTipText(actionDisplay.tooltip);
            boolean bl4 = bl3 = this.useAlternateColors && n % 2 == 1;
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setForeground(jTable.getForeground());
                if (bl3) {
                    this.setBackground(this.alternateBackground);
                } else {
                    this.setBackground(jTable.getBackground());
                }
            }
            return super.getTableCellRendererComponent(jTable, actionDisplay.text, bl, bl2, n, n2);
        }
        catch (Exception exception) {
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    public int getDisplayWidth() {
        return this.getText().length();
    }

    @Override
    public String getDisplayValue() {
        return this.getText();
    }

    public void setUseAlternatingColors(boolean bl) {
        this.useAlternateColors = bl;
    }

    @Override
    public void prepareDisplay(Object object) {
    }
}

