/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import workbench.db.DropType;
import workbench.gui.components.WbTabbedPane;
import workbench.gui.settings.PlacementChooser;
import workbench.interfaces.Restoreable;
import workbench.resource.DbExplorerSettings;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;

public class DbExplorerOptionsPanel
extends JPanel
implements Restoreable,
ActionListener {
    private JCheckBox allowEditing;
    private JCheckBox allowTableAlter;
    private JCheckBox applySQLSort;
    private JCheckBox autogeneratePK;
    private JCheckBox autoselectDataPanel;
    private JPanel dataPanel;
    private JTextField defTableType;
    private JLabel defTableTypeLabel;
    private JLabel dropLabel;
    private JComboBox dropTypesCombo;
    private JCheckBox filterRetrieval;
    private JCheckBox filterWhileTyping;
    private JPanel generalPanel;
    private JCheckBox generateTableGrants;
    private JCheckBox generateViewColumns;
    private JLabel jLabel1;
    private JPanel jPanel2;
    private JPanel jPanel7;
    private JPanel objectList;
    private JTabbedPane optionsPane;
    private JCheckBox partialMatchSearch;
    private JCheckBox rememberColOrder;
    private JCheckBox rememberObjectListSort;
    private JCheckBox rememberObjectType;
    private JCheckBox rememberSort;
    private JCheckBox retrieveDbExplorer;
    private JCheckBox retrieveFKTree;
    private JCheckBox selectSrcPanel;
    private JCheckBox showDbExplorer;
    private JCheckBox showFocus;
    private JCheckBox showSynDetails;
    private JCheckBox showTableHistory;
    private JCheckBox showTriggerPanel;
    private JPanel sqlSourcePanel;
    private JComboBox tabPlacement;
    private JCheckBox useQuickFilterRegex;

    public DbExplorerOptionsPanel() {
        Serializable serializable;
        this.initComponents();
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        for (int i = 0; i < this.optionsPane.getTabCount(); ++i) {
            serializable = (JComponent)this.optionsPane.getComponentAt(i);
            serializable.setBorder(emptyBorder);
        }
        String[] stringArray = new String[]{ResourceMgr.getString("LblDropNone"), ResourceMgr.getString("LblDropPlain"), ResourceMgr.getString("LblDropCascade")};
        serializable = new DefaultComboBoxModel<String>(stringArray);
        this.dropTypesCombo.setModel(serializable);
    }

    @Override
    public void saveSettings() {
        DbExplorerSettings.setRetrieveDbExplorer(this.retrieveDbExplorer.isSelected());
        DbExplorerSettings.setShowDbExplorerInMainWindow(this.showDbExplorer.isSelected());
        DbExplorerSettings.setStoreExplorerObjectType(this.rememberObjectType.isSelected());
        DbExplorerSettings.setAutoGeneratePKName(this.autogeneratePK.isSelected());
        DbExplorerSettings.setShowTriggerPanel(this.showTriggerPanel.isSelected());
        DbExplorerSettings.setSelectDataPanelAfterRetrieve(this.autoselectDataPanel.isSelected());
        DbExplorerSettings.setSelectSourcePanelAfterRetrieve(this.selectSrcPanel.isSelected());
        DbExplorerSettings.setRememberSortInDbExplorer(this.rememberSort.isSelected());
        DbExplorerSettings.setRememberColumnOrder(this.rememberColOrder.isSelected());
        DbExplorerSettings.setShowFocusInDbExplorer(this.showFocus.isSelected());
        DbExplorerSettings.setDefaultExplorerObjectType(this.defTableType.getText());
        DbExplorerSettings.setFilterDuringTyping(this.filterWhileTyping.isSelected());
        DbExplorerSettings.setUsePartialMatch(this.partialMatchSearch.isSelected());
        DbExplorerSettings.setGenerateTableGrants(this.generateTableGrants.isSelected());
        int n = this.dropTypesCombo.getSelectedIndex();
        switch (n) {
            case 0: {
                DbExplorerSettings.setDropTypeToGenerate(DropType.none);
                break;
            }
            case 1: {
                DbExplorerSettings.setDropTypeToGenerate(DropType.regular);
                break;
            }
            case 2: {
                DbExplorerSettings.setDropTypeToGenerate(DropType.cascaded);
            }
        }
        GuiSettings.setUseRegexInQuickFilter(this.useQuickFilterRegex.isSelected());
        DbExplorerSettings.setAllowAlterInDbExplorer(this.allowTableAlter.isSelected());
        DbExplorerSettings.setAutoRetrieveFKTree(this.retrieveFKTree.isSelected());
        DbExplorerSettings.setApplySQLSortInDbExplorer(this.applySQLSort.isSelected());
        DbExplorerSettings.setShowSynonymTargetInDbExplorer(this.showSynDetails.isSelected());
        DbExplorerSettings.setDbExplorerShowTableHistory(this.showTableHistory.isSelected());
        DbExplorerSettings.setGenerateColumnListInViews(this.generateViewColumns.isSelected());
        DbExplorerSettings.setUseFilterForRetrieve(this.filterRetrieval.isSelected());
        DbExplorerSettings.setAllowSourceEditing(this.allowEditing.isSelected());
        ((PlacementChooser)this.tabPlacement).saveSelection();
        Settings.getInstance().setProperty("workbench.gui.dbexplorer.tablelist.sort", this.rememberObjectListSort.isSelected());
    }

    @Override
    public void restoreSettings() {
        DropType dropType = DbExplorerSettings.getDropTypeToGenerate();
        switch (dropType) {
            case none: {
                this.dropTypesCombo.setSelectedIndex(0);
                break;
            }
            case regular: {
                this.dropTypesCombo.setSelectedIndex(1);
                break;
            }
            case cascaded: {
                this.dropTypesCombo.setSelectedIndex(2);
            }
        }
        this.filterRetrieval.setSelected(DbExplorerSettings.getUseFilterForRetrieve());
        this.autogeneratePK.setSelected(DbExplorerSettings.getAutoGeneratePKName());
        this.partialMatchSearch.setSelected(DbExplorerSettings.getUsePartialMatch());
        this.retrieveFKTree.setSelected(DbExplorerSettings.getAutoRetrieveFKTree());
        this.allowTableAlter.setSelected(DbExplorerSettings.allowAlterInDbExplorer());
        this.defTableType.setText(DbExplorerSettings.getDefaultExplorerObjectType());
        this.rememberColOrder.setSelected(DbExplorerSettings.getRememberColumnOrder());
        this.rememberSort.setSelected(DbExplorerSettings.getRememberSortInDbExplorer());
        this.generateTableGrants.setSelected(DbExplorerSettings.getGenerateTableGrants());
        this.useQuickFilterRegex.setSelected(GuiSettings.getUseRegexInQuickFilter());
        this.filterWhileTyping.setSelected(DbExplorerSettings.getFilterDuringTyping());
        this.selectSrcPanel.setSelected(DbExplorerSettings.getSelectSourcePanelAfterRetrieve());
        ((PlacementChooser)this.tabPlacement).showPlacement();
        this.partialMatchSearch.setEnabled(!this.useQuickFilterRegex.isSelected());
        this.applySQLSort.setSelected(DbExplorerSettings.getApplySQLSortInDbExplorer());
        this.showSynDetails.setSelected(GuiSettings.showSynonymTargetInDbExplorer());
        this.showTableHistory.setSelected(DbExplorerSettings.getDbExplorerShowTableHistory());
        this.generateViewColumns.setSelected(DbExplorerSettings.getGenerateColumnListInViews());
        this.showDbExplorer.setSelected(DbExplorerSettings.getShowDbExplorerInMainWindow());
        this.showTriggerPanel.setSelected(DbExplorerSettings.getShowTriggerPanel());
        this.showFocus.setSelected(DbExplorerSettings.showFocusInDbExplorer());
        this.retrieveDbExplorer.setSelected(DbExplorerSettings.getRetrieveDbExplorer());
        this.rememberObjectType.setSelected(DbExplorerSettings.getStoreExplorerObjectType());
        this.applySQLSort.setSelected(DbExplorerSettings.getApplySQLSortInDbExplorer());
        this.allowEditing.setSelected(DbExplorerSettings.allowSourceEditing());
        this.rememberObjectListSort.setSelected(Settings.getInstance().getBoolProperty("workbench.gui.dbexplorer.tablelist.sort"));
    }

    private void initComponents() {
        this.optionsPane = new WbTabbedPane();
        this.generalPanel = new JPanel();
        this.selectSrcPanel = new JCheckBox();
        this.retrieveFKTree = new JCheckBox();
        this.showTableHistory = new JCheckBox();
        this.showFocus = new JCheckBox();
        this.showTriggerPanel = new JCheckBox();
        this.showDbExplorer = new JCheckBox();
        this.autoselectDataPanel = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.tabPlacement = new PlacementChooser();
        this.jLabel1 = new JLabel();
        this.objectList = new JPanel();
        this.retrieveDbExplorer = new JCheckBox();
        this.useQuickFilterRegex = new JCheckBox();
        this.filterRetrieval = new JCheckBox();
        this.partialMatchSearch = new JCheckBox();
        this.allowTableAlter = new JCheckBox();
        this.filterWhileTyping = new JCheckBox();
        this.rememberObjectListSort = new JCheckBox();
        this.rememberObjectType = new JCheckBox();
        this.jPanel7 = new JPanel();
        this.defTableTypeLabel = new JLabel();
        this.defTableType = new JTextField();
        this.sqlSourcePanel = new JPanel();
        this.autogeneratePK = new JCheckBox();
        this.generateTableGrants = new JCheckBox();
        this.generateViewColumns = new JCheckBox();
        this.allowEditing = new JCheckBox();
        this.dropLabel = new JLabel();
        this.dropTypesCombo = new JComboBox();
        this.showSynDetails = new JCheckBox();
        this.dataPanel = new JPanel();
        this.rememberColOrder = new JCheckBox();
        this.rememberSort = new JCheckBox();
        this.applySQLSort = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.generalPanel.setLayout(new GridBagLayout());
        this.selectSrcPanel.setText(ResourceMgr.getString("LblSelectSourcePanel"));
        this.selectSrcPanel.setToolTipText(ResourceMgr.getString("d_LblSelectSourcePanel"));
        this.selectSrcPanel.setBorder(null);
        this.selectSrcPanel.setMargin(new Insets(0, 0, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 40, 0, 10);
        this.generalPanel.add((Component)this.selectSrcPanel, gridBagConstraints);
        this.retrieveFKTree.setText(ResourceMgr.getString("LblRetrieveFkTree"));
        this.retrieveFKTree.setToolTipText(ResourceMgr.getString("d_LblRetrieveFkTree"));
        this.retrieveFKTree.setBorder(null);
        this.retrieveFKTree.setHorizontalAlignment(2);
        this.retrieveFKTree.setHorizontalTextPosition(4);
        this.retrieveFKTree.setIconTextGap(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.generalPanel.add((Component)this.retrieveFKTree, gridBagConstraints);
        this.showTableHistory.setText(ResourceMgr.getString("LblShowTableHist"));
        this.showTableHistory.setToolTipText(ResourceMgr.getString("d_LblShowTableHist"));
        this.showTableHistory.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.showTableHistory.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.generalPanel.add((Component)this.showTableHistory, gridBagConstraints);
        this.showFocus.setText(ResourceMgr.getString("LblShowFocus"));
        this.showFocus.setToolTipText(ResourceMgr.getString("d_LblShowFocus"));
        this.showFocus.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.showFocus.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 40, 0, 10);
        this.generalPanel.add((Component)this.showFocus, gridBagConstraints);
        this.showTriggerPanel.setText(ResourceMgr.getString("LblShowTriggerPanel"));
        this.showTriggerPanel.setToolTipText(ResourceMgr.getString("d_LblShowTriggerPanel"));
        this.showTriggerPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.showTriggerPanel.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.generalPanel.add((Component)this.showTriggerPanel, gridBagConstraints);
        this.showDbExplorer.setText(ResourceMgr.getString("LblDbExplorerCheckBox"));
        this.showDbExplorer.setToolTipText(ResourceMgr.getString("d_LblDbExplorerCheckBox"));
        this.showDbExplorer.setBorder(null);
        this.showDbExplorer.setHorizontalAlignment(2);
        this.showDbExplorer.setHorizontalTextPosition(4);
        this.showDbExplorer.setIconTextGap(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.generalPanel.add((Component)this.showDbExplorer, gridBagConstraints);
        this.autoselectDataPanel.setText(ResourceMgr.getString("LblSelectDataPanel"));
        this.autoselectDataPanel.setToolTipText(ResourceMgr.getString("d_LblSelectDataPanel"));
        this.autoselectDataPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.autoselectDataPanel.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 40, 0, 10);
        this.generalPanel.add((Component)this.autoselectDataPanel, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.tabPlacement.setModel(new DefaultComboBoxModel<String>(new String[]{"Top", "Bottom", "Left", "Right"}));
        this.tabPlacement.setToolTipText(ResourceMgr.getString("d_LblObjTabPos"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 9, 0, 0);
        this.jPanel2.add((Component)this.tabPlacement, gridBagConstraints);
        this.jLabel1.setText(ResourceMgr.getString("LblObjTabPos"));
        this.jLabel1.setToolTipText(ResourceMgr.getString("d_LblObjTabPos"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 20);
        this.generalPanel.add((Component)this.jPanel2, gridBagConstraints);
        this.optionsPane.addTab(ResourceMgr.getString("LblSettingsGeneral"), this.generalPanel);
        this.objectList.setLayout(new GridBagLayout());
        this.retrieveDbExplorer.setText(ResourceMgr.getString("LblRetrieveDbExplorer"));
        this.retrieveDbExplorer.setToolTipText(ResourceMgr.getString("d_LblRetrieveDbExplorer"));
        this.retrieveDbExplorer.setBorder(null);
        this.retrieveDbExplorer.setHorizontalAlignment(2);
        this.retrieveDbExplorer.setHorizontalTextPosition(4);
        this.retrieveDbExplorer.setIconTextGap(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.objectList.add((Component)this.retrieveDbExplorer, gridBagConstraints);
        this.useQuickFilterRegex.setText(ResourceMgr.getString("LblQuickFilterRegex"));
        this.useQuickFilterRegex.setToolTipText(ResourceMgr.getString("d_LblQuickFilterRegex"));
        this.useQuickFilterRegex.setBorder(null);
        this.useQuickFilterRegex.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 0, 10);
        this.objectList.add((Component)this.useQuickFilterRegex, gridBagConstraints);
        this.filterRetrieval.setText(ResourceMgr.getString("LblDbExpUseRetrievalFilter"));
        this.filterRetrieval.setToolTipText(ResourceMgr.getString("d_LblDbExpUseRetrievalFilter"));
        this.filterRetrieval.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 8, 0, 10);
        this.objectList.add((Component)this.filterRetrieval, gridBagConstraints);
        this.partialMatchSearch.setText(ResourceMgr.getString("LblPartialMatch"));
        this.partialMatchSearch.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 8, 0, 10);
        this.objectList.add((Component)this.partialMatchSearch, gridBagConstraints);
        this.allowTableAlter.setText(ResourceMgr.getString("LblAllowTblAlter"));
        this.allowTableAlter.setToolTipText(ResourceMgr.getString("d_LblAllowTblAlter"));
        this.allowTableAlter.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 0, 0, 10);
        this.objectList.add((Component)this.allowTableAlter, gridBagConstraints);
        this.filterWhileTyping.setText(ResourceMgr.getString("LblFilterWhileType"));
        this.filterWhileTyping.setToolTipText(ResourceMgr.getString("d_LblFilterWhileType"));
        this.filterWhileTyping.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 8, 0, 10);
        this.objectList.add((Component)this.filterWhileTyping, gridBagConstraints);
        this.rememberObjectListSort.setText(ResourceMgr.getString("LblRememberDbExpSort"));
        this.rememberObjectListSort.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rememberObjectListSort.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 0, 0, 10);
        this.objectList.add((Component)this.rememberObjectListSort, gridBagConstraints);
        this.rememberObjectType.setText(ResourceMgr.getString("LblRememberObjectType"));
        this.rememberObjectType.setToolTipText(ResourceMgr.getString("d_LblRememberObjectType"));
        this.rememberObjectType.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rememberObjectType.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 0, 0, 10);
        this.objectList.add((Component)this.rememberObjectType, gridBagConstraints);
        this.jPanel7.setLayout(new GridBagLayout());
        this.defTableTypeLabel.setLabelFor(this.autogeneratePK);
        this.defTableTypeLabel.setText(ResourceMgr.getString("LblDefTableType"));
        this.defTableTypeLabel.setToolTipText(ResourceMgr.getString("d_LblDefTableType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel7.add((Component)this.defTableTypeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 9, 0, 0);
        this.jPanel7.add((Component)this.defTableType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(9, 0, 0, 6);
        this.objectList.add((Component)this.jPanel7, gridBagConstraints);
        this.optionsPane.addTab(ResourceMgr.getString("LblDbExpObjListOpts"), this.objectList);
        this.sqlSourcePanel.setLayout(new GridBagLayout());
        this.autogeneratePK.setText(ResourceMgr.getString("LblGeneratePkName"));
        this.autogeneratePK.setToolTipText(ResourceMgr.getString("d_LblGeneratePkName"));
        this.autogeneratePK.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.autogeneratePK.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.sqlSourcePanel.add((Component)this.autogeneratePK, gridBagConstraints);
        this.generateTableGrants.setText(ResourceMgr.getString("LblGenerateTblGrants"));
        this.generateTableGrants.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.generateTableGrants.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 10);
        this.sqlSourcePanel.add((Component)this.generateTableGrants, gridBagConstraints);
        this.generateViewColumns.setText(ResourceMgr.getString("LblGenerateViewCols"));
        this.generateViewColumns.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.generateViewColumns.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 3, 10);
        this.sqlSourcePanel.add((Component)this.generateViewColumns, gridBagConstraints);
        this.allowEditing.setText(ResourceMgr.getString("LblDbExpSrcEdit"));
        this.allowEditing.setToolTipText(ResourceMgr.getString("d_LblDbExpSrcEdit"));
        this.allowEditing.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.allowEditing.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 3, 10);
        this.sqlSourcePanel.add((Component)this.allowEditing, gridBagConstraints);
        this.dropLabel.setText(ResourceMgr.getString("LblGenerateDrop"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.sqlSourcePanel.add((Component)this.dropLabel, gridBagConstraints);
        this.dropTypesCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Nothing", "Simple", "Cascade"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(7, 8, 0, 5);
        this.sqlSourcePanel.add((Component)this.dropTypesCombo, gridBagConstraints);
        this.showSynDetails.setText(ResourceMgr.getString("LblShowSynTarget"));
        this.showSynDetails.setToolTipText(ResourceMgr.getString("d_LblShowSynTarget"));
        this.showSynDetails.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 3, 10);
        this.sqlSourcePanel.add((Component)this.showSynDetails, gridBagConstraints);
        this.optionsPane.addTab(ResourceMgr.getString("LblDbExpGenOpts"), this.sqlSourcePanel);
        this.dataPanel.setLayout(new GridBagLayout());
        this.rememberColOrder.setText(ResourceMgr.getString("LblRememberDbExpColOrder"));
        this.rememberColOrder.setToolTipText(ResourceMgr.getString("d_LblRememberDbExpColOrder"));
        this.rememberColOrder.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.dataPanel.add((Component)this.rememberColOrder, gridBagConstraints);
        this.rememberSort.setText(ResourceMgr.getString("LblRememberDbExpSort"));
        this.rememberSort.setToolTipText(ResourceMgr.getString("d_LblRememberDbExpSort"));
        this.rememberSort.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rememberSort.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 0, 0, 10);
        this.dataPanel.add((Component)this.rememberSort, gridBagConstraints);
        this.applySQLSort.setText(ResourceMgr.getString("LblApplySQLSort"));
        this.applySQLSort.setToolTipText(ResourceMgr.getString("d_LblApplySQLSort"));
        this.applySQLSort.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.applySQLSort.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 3, 10);
        this.dataPanel.add((Component)this.applySQLSort, gridBagConstraints);
        this.optionsPane.addTab(ResourceMgr.getString("LblDbExpDataOpts"), this.dataPanel);
        this.add((Component)this.optionsPane, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.useQuickFilterRegex) {
            this.useQuickFilterRegexActionPerformed(actionEvent);
        }
    }

    private void useQuickFilterRegexActionPerformed(ActionEvent actionEvent) {
        this.partialMatchSearch.setEnabled(!this.useQuickFilterRegex.isSelected());
    }
}

