/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import workbench.interfaces.Restoreable;
import workbench.resource.GeneratedIdentifierCase;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;

public class SqlGenerationOptionsPanel
extends JPanel
implements Restoreable {
    private JLabel copyLiteralLabel;
    private JLabel diffLiteralsLabel;
    private JComboBox diffLiteralsType;
    private JLabel exportLiteralLabel;
    private JComboBox exportLiteralTypes;
    private JCheckBox formatDeletes;
    private JCheckBox formatInserts;
    private JCheckBox formatUpdates;
    private JCheckBox ignoreIdentity;
    private JCheckBox includeEmptyComments;
    private JCheckBox includeOwner;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JComboBox literalTypes;
    private JComboBox tableNameCase;
    private JLabel tableNameCaseLabel;

    public SqlGenerationOptionsPanel() {
        this.initComponents();
        List<String> list = Settings.getInstance().getLiteralTypeList();
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
        this.literalTypes.setModel(defaultComboBoxModel);
        DefaultComboBoxModel<Object> defaultComboBoxModel2 = new DefaultComboBoxModel<Object>(list.toArray());
        this.exportLiteralTypes.setModel(defaultComboBoxModel2);
        DefaultComboBoxModel<Object> defaultComboBoxModel3 = new DefaultComboBoxModel<Object>(list.toArray());
        this.diffLiteralsType.setModel(defaultComboBoxModel3);
        this.tableNameCase.setModel(new DefaultComboBoxModel<GeneratedIdentifierCase>(GeneratedIdentifierCase.values()));
    }

    @Override
    public void restoreSettings() {
        GeneratedIdentifierCase generatedIdentifierCase = Settings.getInstance().getGeneratedSqlTableCase();
        this.tableNameCase.setSelectedItem((Object)generatedIdentifierCase);
        this.literalTypes.setSelectedItem(Settings.getInstance().getDefaultCopyDateLiteralType());
        this.exportLiteralTypes.setSelectedItem(Settings.getInstance().getDefaultExportDateLiteralType());
        this.diffLiteralsType.setSelectedItem(Settings.getInstance().getDefaultDiffDateLiteralType());
        this.includeEmptyComments.setSelected(Settings.getInstance().getIncludeEmptyComments());
        this.ignoreIdentity.setSelected(Settings.getInstance().getGenerateInsertIgnoreIdentity());
    }

    @Override
    public void saveSettings() {
        Settings settings = Settings.getInstance();
        settings.setDoFormatUpdates(this.formatUpdates.isSelected());
        settings.setDoFormatInserts(this.formatInserts.isSelected());
        settings.setDoFormatDeletes(this.formatDeletes.isSelected());
        settings.setIncludeOwnerInSqlExport(this.includeOwner.isSelected());
        settings.setGeneratedSqlTableCase((GeneratedIdentifierCase)((Object)this.tableNameCase.getSelectedItem()));
        settings.setDefaultCopyDateLiteralType((String)this.literalTypes.getSelectedItem());
        settings.setDefaultExportDateLiteralType((String)this.exportLiteralTypes.getSelectedItem());
        settings.setDefaultDiffDateLiteralType((String)this.diffLiteralsType.getSelectedItem());
        settings.setIncludeEmptyComments(this.includeEmptyComments.isSelected());
        settings.setGenerateInsertIgnoreIdentity(this.ignoreIdentity.isSelected());
    }

    private void initComponents() {
        this.formatUpdates = new JCheckBox();
        this.formatInserts = new JCheckBox();
        this.formatDeletes = new JCheckBox();
        this.ignoreIdentity = new JCheckBox();
        this.tableNameCaseLabel = new JLabel();
        this.tableNameCase = new JComboBox();
        this.jPanel1 = new JPanel();
        this.includeEmptyComments = new JCheckBox();
        this.includeOwner = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.copyLiteralLabel = new JLabel();
        this.exportLiteralLabel = new JLabel();
        this.literalTypes = new JComboBox();
        this.exportLiteralTypes = new JComboBox();
        this.diffLiteralsLabel = new JLabel();
        this.diffLiteralsType = new JComboBox();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.formatUpdates.setSelected(Settings.getInstance().getDoFormatUpdates());
        this.formatUpdates.setText(ResourceMgr.getString("LblFmtUpd"));
        this.formatUpdates.setToolTipText(ResourceMgr.getString("d_LblFmtUpd"));
        this.formatUpdates.setBorder(null);
        this.formatUpdates.setHorizontalAlignment(2);
        this.formatUpdates.setHorizontalTextPosition(4);
        this.formatUpdates.setIconTextGap(5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        this.add((Component)this.formatUpdates, gridBagConstraints);
        this.formatInserts.setSelected(Settings.getInstance().getDoFormatInserts());
        this.formatInserts.setText(ResourceMgr.getString("LblFmtIns"));
        this.formatInserts.setToolTipText(ResourceMgr.getString("d_LblFmtIns"));
        this.formatInserts.setBorder(null);
        this.formatInserts.setHorizontalAlignment(2);
        this.formatInserts.setHorizontalTextPosition(4);
        this.formatInserts.setIconTextGap(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 0, 0, 11);
        this.add((Component)this.formatInserts, gridBagConstraints);
        this.formatDeletes.setSelected(Settings.getInstance().getDoFormatDeletes());
        this.formatDeletes.setText(ResourceMgr.getString("LblFmtDel"));
        this.formatDeletes.setToolTipText(ResourceMgr.getString("d_LblFmtDel"));
        this.formatDeletes.setBorder(null);
        this.formatDeletes.setHorizontalAlignment(2);
        this.formatDeletes.setHorizontalTextPosition(4);
        this.formatDeletes.setIconTextGap(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 11);
        this.add((Component)this.formatDeletes, gridBagConstraints);
        this.ignoreIdentity.setText(ResourceMgr.getString("LblInsIgnoreId"));
        this.ignoreIdentity.setToolTipText(ResourceMgr.getString("d_LblInsIgnoreId"));
        this.ignoreIdentity.setBorder(null);
        this.ignoreIdentity.setHorizontalAlignment(2);
        this.ignoreIdentity.setHorizontalTextPosition(4);
        this.ignoreIdentity.setIconTextGap(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 0, 0, 11);
        this.add((Component)this.ignoreIdentity, gridBagConstraints);
        this.tableNameCaseLabel.setLabelFor(this.tableNameCase);
        this.tableNameCaseLabel.setText(ResourceMgr.getString("LblGenTableNameCase"));
        this.tableNameCaseLabel.setToolTipText(ResourceMgr.getString("d_LblGenTableNameCase"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.tableNameCaseLabel, gridBagConstraints);
        this.tableNameCase.setModel(new DefaultComboBoxModel<String>(new String[]{"As is", "Lowercase", "Uppercase"}));
        this.tableNameCase.setToolTipText(ResourceMgr.getDescription("LblGenTableNameCase"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 0, 15);
        this.add((Component)this.tableNameCase, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.includeEmptyComments.setSelected(Settings.getInstance().getIncludeOwnerInSqlExport());
        this.includeEmptyComments.setText(ResourceMgr.getString("LblGenInclEmptyComments"));
        this.includeEmptyComments.setToolTipText(ResourceMgr.getString("d_LblGenInclEmptyComments"));
        this.includeEmptyComments.setBorder(null);
        this.includeEmptyComments.setHorizontalAlignment(2);
        this.includeEmptyComments.setHorizontalTextPosition(4);
        this.includeEmptyComments.setIconTextGap(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel1.add((Component)this.includeEmptyComments, gridBagConstraints);
        this.includeOwner.setSelected(Settings.getInstance().getIncludeOwnerInSqlExport());
        this.includeOwner.setText(ResourceMgr.getString("LblGenInclOwn"));
        this.includeOwner.setToolTipText(ResourceMgr.getString("d_LblGenInclOwn"));
        this.includeOwner.setBorder(null);
        this.includeOwner.setHorizontalAlignment(2);
        this.includeOwner.setHorizontalTextPosition(4);
        this.includeOwner.setIconTextGap(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        this.jPanel1.add((Component)this.includeOwner, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(ResourceMgr.getString("LblDefDateLiterals")));
        this.jPanel2.setLayout(new GridBagLayout());
        this.copyLiteralLabel.setText(ResourceMgr.getString("LblDefCopyLiteralType"));
        this.copyLiteralLabel.setToolTipText(ResourceMgr.getString("d_LblDefCopyLiteralType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanel2.add((Component)this.copyLiteralLabel, gridBagConstraints);
        this.exportLiteralLabel.setLabelFor(this.exportLiteralTypes);
        this.exportLiteralLabel.setText(ResourceMgr.getString("LblDefExportLiteralType"));
        this.exportLiteralLabel.setToolTipText(ResourceMgr.getString("d_LblDefExportLiteralType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(9, 8, 3, 0);
        this.jPanel2.add((Component)this.exportLiteralLabel, gridBagConstraints);
        this.literalTypes.setToolTipText(ResourceMgr.getDescription("LblDefCopyLiteralType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanel2.add((Component)this.literalTypes, gridBagConstraints);
        this.exportLiteralTypes.setToolTipText(ResourceMgr.getDescription("LblDefExportLiteralType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 8, 3, 0);
        this.jPanel2.add((Component)this.exportLiteralTypes, gridBagConstraints);
        this.diffLiteralsLabel.setLabelFor(this.diffLiteralsType);
        this.diffLiteralsLabel.setText(ResourceMgr.getString("LblDefDiffLiteralType"));
        this.diffLiteralsLabel.setToolTipText(ResourceMgr.getString("d_LblDefDiffLiteralType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.jPanel2.add((Component)this.diffLiteralsLabel, gridBagConstraints);
        this.diffLiteralsType.setToolTipText(ResourceMgr.getDescription("LblDefExportLiteralType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanel2.add((Component)this.diffLiteralsType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 3, 14);
        this.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel4, gridBagConstraints);
    }
}

