/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.FlatButton;
import workbench.gui.components.StringPropertyEditor;
import workbench.gui.components.TextComponentMouseListener;
import workbench.gui.components.WbFileChooser;
import workbench.interfaces.SimplePropertyEditor;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.util.ExceptionUtil;
import workbench.util.StringUtil;
import workbench.util.ToolDefinition;

public class ToolDefinitionPanel
extends JPanel
implements ActionListener {
    private ToolDefinition currentTool;
    private PropertyChangeListener changeListener;
    public JLabel lblName;
    public JLabel lblParameters;
    public JLabel lblPath;
    public JTextField parameters;
    public JButton selectLibButton;
    public JTextField tfName;
    public JTextField tfPath;

    public ToolDefinitionPanel() {
        this.initComponents();
        this.tfName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ToolDefinitionPanel.this.nameFieldFocusLost(focusEvent);
            }
        });
    }

    public void setPropertyListener(PropertyChangeListener propertyChangeListener) {
        this.changeListener = propertyChangeListener;
    }

    public void nameFieldFocusLost(FocusEvent focusEvent) {
        if (this.changeListener != null) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.currentTool, "name", null, this.tfName.getText());
            this.changeListener.propertyChange(propertyChangeEvent);
        }
    }

    private void initComponents() {
        this.lblName = new JLabel();
        this.tfName = new StringPropertyEditor();
        this.lblPath = new JLabel();
        this.tfPath = new StringPropertyEditor();
        this.selectLibButton = new FlatButton();
        this.parameters = new StringPropertyEditor();
        this.lblParameters = new JLabel();
        this.setLayout(new GridBagLayout());
        this.lblName.setLabelFor(this.tfName);
        this.lblName.setText(ResourceMgr.getString("LblLnFName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 10, 0, 7);
        this.add((Component)this.lblName, gridBagConstraints);
        this.tfName.setHorizontalAlignment(2);
        this.tfName.setName("name");
        this.tfName.addMouseListener(new TextComponentMouseListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 3, 0, 3);
        this.add((Component)this.tfName, gridBagConstraints);
        this.lblPath.setLabelFor(this.tfPath);
        this.lblPath.setText(ResourceMgr.getString("LblExePath"));
        this.lblPath.setToolTipText(ResourceMgr.getString("d_LblExePath"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 7);
        this.add((Component)this.lblPath, gridBagConstraints);
        this.tfPath.setColumns(10);
        this.tfPath.setHorizontalAlignment(2);
        this.tfPath.setName("executablePath");
        this.tfPath.addMouseListener(new TextComponentMouseListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 3, 0, 3);
        this.add((Component)this.tfPath, gridBagConstraints);
        this.selectLibButton.setText("...");
        this.selectLibButton.setMaximumSize(new Dimension(20, 20));
        this.selectLibButton.setMinimumSize(new Dimension(20, 20));
        this.selectLibButton.setPreferredSize(new Dimension(20, 20));
        this.selectLibButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 0, 3);
        this.add((Component)this.selectLibButton, gridBagConstraints);
        this.parameters.setHorizontalAlignment(2);
        this.parameters.setName("parameters");
        this.tfName.addMouseListener(new TextComponentMouseListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 3, 6, 3);
        this.add((Component)this.parameters, gridBagConstraints);
        this.lblParameters.setLabelFor(this.lblParameters);
        this.lblParameters.setText(ResourceMgr.getString("LblCompletionListParams"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(7, 10, 0, 7);
        this.add((Component)this.lblParameters, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.selectLibButton) {
            this.selectTool(actionEvent);
        }
    }

    private void selectTool(ActionEvent actionEvent) {
        try {
            int n;
            File file;
            File file2 = new File(this.tfPath.getText());
            WbFileChooser wbFileChooser = new WbFileChooser();
            if (file2.isAbsolute() && (file = file2.getParentFile()) != null) {
                wbFileChooser.setCurrentDirectory(file);
            }
            if ((n = wbFileChooser.showOpenDialog(SwingUtilities.getWindowAncestor(this))) == 0) {
                File file3 = wbFileChooser.getSelectedFile();
                this.tfPath.setText(file3.getAbsolutePath());
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error selecting file", throwable);
            WbSwingUtilities.showErrorMessage(ExceptionUtil.getDisplay(throwable));
        }
    }

    private void initPropertyEditors() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof SimplePropertyEditor)) continue;
            SimplePropertyEditor simplePropertyEditor = (SimplePropertyEditor)((Object)component);
            String string = component.getName();
            if (StringUtil.isEmptyString(string)) continue;
            simplePropertyEditor.setSourceObject(this.currentTool, string);
            simplePropertyEditor.setImmediateUpdate(true);
        }
    }

    public void setDefinition(ToolDefinition toolDefinition) {
        this.currentTool = toolDefinition;
        this.initPropertyEditors();
    }

    public ToolDefinition getDefinition() {
        return this.currentTool;
    }
}

