/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import workbench.gui.settings.ExternalFileHandling;
import workbench.interfaces.Restoreable;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;

public class WorkspaceOptions
extends JPanel
implements Restoreable {
    private JCheckBox autoSaveWorkspace;
    private JComboBox fileHandling;
    private JLabel jLabel3;
    private JPanel jPanel1;

    public WorkspaceOptions() {
        this.initComponents();
        String[] stringArray = new String[]{ResourceMgr.getString("LblFileWksplink"), ResourceMgr.getString("LblFileWkspcontent"), ResourceMgr.getString("LblFileWkspnone")};
        this.fileHandling.setModel(new DefaultComboBoxModel<String>(stringArray));
    }

    @Override
    public void restoreSettings() {
        this.autoSaveWorkspace.setSelected(Settings.getInstance().getAutoSaveWorkspace());
        ExternalFileHandling externalFileHandling = Settings.getInstance().getFilesInWorkspaceHandling();
        switch (externalFileHandling) {
            case link: {
                this.fileHandling.setSelectedIndex(0);
                break;
            }
            case content: {
                this.fileHandling.setSelectedIndex(1);
                break;
            }
            case none: {
                this.fileHandling.setSelectedIndex(2);
                break;
            }
            default: {
                this.fileHandling.setSelectedIndex(0);
            }
        }
    }

    @Override
    public void saveSettings() {
        Settings settings = Settings.getInstance();
        settings.setAutoSaveWorkspace(this.autoSaveWorkspace.isSelected());
        int n = this.fileHandling.getSelectedIndex();
        switch (n) {
            case 0: {
                settings.setFilesInWorkspaceHandling(ExternalFileHandling.link);
                break;
            }
            case 1: {
                settings.setFilesInWorkspaceHandling(ExternalFileHandling.content);
                break;
            }
            case 2: {
                settings.setFilesInWorkspaceHandling(ExternalFileHandling.none);
                break;
            }
            default: {
                settings.setFilesInWorkspaceHandling(ExternalFileHandling.link);
            }
        }
    }

    private void initComponents() {
        this.autoSaveWorkspace = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.fileHandling = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.autoSaveWorkspace.setText(ResourceMgr.getString("LblAutoSaveWksp"));
        this.autoSaveWorkspace.setToolTipText(ResourceMgr.getString("d_LblAutoSaveWksp"));
        this.autoSaveWorkspace.setBorder(null);
        this.autoSaveWorkspace.setHorizontalAlignment(2);
        this.autoSaveWorkspace.setHorizontalTextPosition(4);
        this.autoSaveWorkspace.setIconTextGap(5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.add((Component)this.autoSaveWorkspace, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel3.setText(ResourceMgr.getString("LblRememberFileWksp"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 3, 0, 0);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.fileHandling.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanel1.add((Component)this.fileHandling, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }
}

