/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.sql;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.WbTable;
import workbench.resource.GuiSettings;

public class DropDownCellEditor
implements TableCellEditor {
    private JComboBox input;
    private WbTable table;

    public DropDownCellEditor(WbTable wbTable) {
        this.table = wbTable;
        this.input = new JComboBox();
        this.input.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.input.setEditable(GuiSettings.getVariablesDDEditable());
    }

    public void setValues(List<String> list) {
        this.input.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
    }

    public String getText() {
        Object object = this.input.getSelectedItem();
        if (object == null) {
            object = this.input.getEditor().getItem();
        }
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.input.setSelectedItem(object);
        WbSwingUtilities.requestFocus((JComponent)this.input.getEditor().getEditorComponent());
        return this.input;
    }

    @Override
    public Object getCellEditorValue() {
        return this.getText();
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        if (this.table != null) {
            this.table.editingStopped(new ChangeEvent(this));
        }
        return true;
    }

    @Override
    public void cancelCellEditing() {
        if (this.table != null) {
            this.table.editingCanceled(new ChangeEvent(this));
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
    }

    public void addActionListener(ActionListener actionListener) {
        this.input.addActionListener(actionListener);
    }
}

