/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.sql;

import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import workbench.gui.WbSwingUtilities;
import workbench.gui.sql.SqlPanel;
import workbench.interfaces.TextChangeListener;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.IconMgr;
import workbench.resource.Settings;

public class IconHandler
implements PropertyChangeListener,
TextChangeListener {
    public static final String PROP_LOADING_IMAGE = "workbench.gui.busyicon.name";
    public static final String PROP_CANCEL_IMAGE = "workbench.gui.cancelicon.name";
    public static final String DEFAULT_BUSY_IMAGE = "loading-static";
    public static final String DEFAULT_CANCEL_IMAGE = "cancelling-static";
    private SqlPanel client;
    private ImageIcon fileIcon;
    private ImageIcon fileModifiedIcon;
    private ImageIcon cancelIcon;
    private ImageIcon loadingIcon;
    private boolean textModified;

    public IconHandler(SqlPanel sqlPanel) {
        this.client = sqlPanel;
        this.client.getEditor().addTextChangeListener(this);
        Settings.getInstance().addPropertyChangeListener(this, PROP_LOADING_IMAGE, PROP_CANCEL_IMAGE);
    }

    protected void dispose() {
        Settings.getInstance().removePropertyChangeListener(this);
        this.flush();
    }

    protected void flush() {
        if (this.cancelIcon != null) {
            this.cancelIcon.getImage().flush();
        }
        if (this.loadingIcon != null) {
            this.loadingIcon.getImage().flush();
        }
        if (!Settings.getInstance().getCacheIcons()) {
            if (this.fileIcon != null) {
                this.fileIcon.getImage().flush();
            }
            if (this.fileModifiedIcon != null) {
                this.fileModifiedIcon.getImage().flush();
            }
        }
    }

    public void removeIcon() {
        if (this.client.isBusy()) {
            return;
        }
        this.showIconForTab(null);
    }

    public void showFileIcon() {
        if (this.client.isBusy()) {
            return;
        }
        this.showIconForTab(this.getFileIcon());
    }

    public void showCancelIcon() {
        this.showIconForTab(this.getCancelIndicator());
    }

    private ImageIcon getLoadingIndicator() {
        if (this.loadingIcon == null) {
            String string = Settings.getInstance().getProperty(PROP_LOADING_IMAGE, DEFAULT_BUSY_IMAGE);
            this.loadingIcon = IconMgr.getInstance().getLoadingImage(string);
            if (this.loadingIcon == null) {
                this.loadingIcon = IconMgr.getInstance().getLoadingImage(DEFAULT_BUSY_IMAGE);
            }
        }
        return this.loadingIcon;
    }

    protected ImageIcon getCancelIndicator() {
        if (this.cancelIcon == null) {
            String string = Settings.getInstance().getProperty(PROP_CANCEL_IMAGE, DEFAULT_CANCEL_IMAGE);
            this.cancelIcon = IconMgr.getInstance().getLoadingImage(string);
            if (this.cancelIcon == null) {
                this.cancelIcon = IconMgr.getInstance().getLoadingImage(DEFAULT_CANCEL_IMAGE);
            }
        }
        return this.cancelIcon;
    }

    protected ImageIcon getFileIcon() {
        ImageIcon imageIcon = null;
        if (this.textModified) {
            if (this.fileModifiedIcon == null) {
                this.fileModifiedIcon = IconMgr.getInstance().getLabelIcon("file-modified");
            }
            imageIcon = this.fileModifiedIcon;
        } else {
            if (this.fileIcon == null) {
                this.fileIcon = IconMgr.getInstance().getLabelIcon("file-icon");
            }
            imageIcon = this.fileIcon;
        }
        return imageIcon;
    }

    protected void showIconForTab(ImageIcon imageIcon) {
        Container container = this.client.getParent();
        if (container instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)container;
            int n = jTabbedPane.indexOfComponent(this.client);
            if (n < 0) {
                return;
            }
            Icon icon = jTabbedPane.getIconAt(n);
            if (imageIcon == null && icon == null) {
                return;
            }
            if (imageIcon != icon) {
                WbSwingUtilities.invoke(() -> jTabbedPane.setIconAt(n, imageIcon));
            }
        }
    }

    private void hideBusy() {
        this._showBusyIcon(false);
    }

    private void showBusy() {
        this._showBusyIcon(true);
    }

    public void showBusyIcon(boolean bl) {
        if (bl) {
            WbSwingUtilities.invoke(this::showBusy);
        } else {
            WbSwingUtilities.invoke(this::hideBusy);
        }
    }

    private void _showBusyIcon(boolean bl) {
        JTabbedPane jTabbedPane;
        int n;
        Container container = this.client.getParent();
        if (container instanceof JTabbedPane && (n = (jTabbedPane = (JTabbedPane)container).indexOfComponent(this.client)) >= 0 && n < jTabbedPane.getTabCount()) {
            try {
                if (bl) {
                    jTabbedPane.setIconAt(n, this.getLoadingIndicator());
                } else if (this.client.hasFileLoaded()) {
                    jTabbedPane.setIconAt(n, this.getFileIcon());
                } else {
                    jTabbedPane.setIconAt(n, null);
                }
            }
            catch (Throwable throwable) {
                LogMgr.logWarning(new CallerInfo(){}, "Error when setting busy icon!", throwable);
            }
            jTabbedPane.validate();
            jTabbedPane.repaint();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == null) {
            return;
        }
        if (string.equals(PROP_LOADING_IMAGE) && this.loadingIcon != null) {
            this.loadingIcon.getImage().flush();
            this.loadingIcon = null;
        }
        if (string.equals(PROP_CANCEL_IMAGE) && this.cancelIcon != null) {
            this.cancelIcon.getImage().flush();
            this.cancelIcon = null;
        }
    }

    @Override
    public void textStatusChanged(boolean bl) {
        this.textModified = bl;
        if (this.client.hasFileLoaded()) {
            this.showFileIcon();
        }
    }
}

