/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.sql;

import java.awt.EventQueue;
import workbench.gui.MainWindow;
import workbench.gui.sql.PasteType;
import workbench.gui.sql.SqlPanel;
import workbench.interfaces.ResultReceiver;
import workbench.util.WbThread;

public class PanelContentSender {
    public static final int NEW_PANEL = -1;
    private MainWindow target;
    private String newTabName;

    public PanelContentSender(MainWindow mainWindow, String string) {
        this.target = mainWindow;
        this.newTabName = string;
    }

    public void showResult(final String string, final String string2, int n, ResultReceiver.ShowType showType) {
        if (string == null) {
            return;
        }
        final SqlPanel sqlPanel = this.selectPanel(n);
        if (sqlPanel == null) {
            return;
        }
        final ResultReceiver.ShowType showType2 = sqlPanel.hasFileLoaded() && (showType == ResultReceiver.ShowType.appendText || showType == ResultReceiver.ShowType.replaceText) ? ResultReceiver.ShowType.logText : showType;
        WbThread wbThread = new WbThread("ShowFKThread"){

            @Override
            public void run() {
                PanelContentSender.this.target.waitForConnection();
                sqlPanel.showResult(string, string2, showType2);
            }
        };
        wbThread.start();
    }

    public void sendContent(String string, int n, PasteType pasteType) {
        if (string == null) {
            return;
        }
        SqlPanel sqlPanel = this.selectPanel(n);
        if (sqlPanel == null) {
            return;
        }
        EventQueue.invokeLater(() -> {
            if (null != pasteType) {
                switch (pasteType) {
                    case append: {
                        sqlPanel.appendStatementText(string);
                        break;
                    }
                    case overwrite: {
                        sqlPanel.setStatementText(string);
                        break;
                    }
                    case insert: {
                        sqlPanel.addStatement(string);
                        break;
                    }
                }
            }
            this.target.requestFocus();
            sqlPanel.selectEditor();
        });
    }

    private SqlPanel selectPanel(int n) {
        SqlPanel sqlPanel;
        this.target.requestFocus();
        if (n == -1) {
            sqlPanel = (SqlPanel)this.target.addTab();
            sqlPanel.setTabName(this.newTabName);
        } else {
            sqlPanel = this.target.getSqlPanel(n).orElse(null);
            this.target.selectTab(n);
        }
        return sqlPanel;
    }
}

