/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.sql;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import workbench.db.ColumnIdentifier;
import workbench.db.DependencyNode;
import workbench.db.ReferenceTableNavigation;
import workbench.db.TableDependency;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.gui.MainWindow;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.WbMenu;
import workbench.gui.components.WbTable;
import workbench.gui.dbobjects.EditorTabSelectMenu;
import workbench.gui.sql.DwPanel;
import workbench.gui.sql.PanelContentSender;
import workbench.interfaces.ResultReceiver;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.storage.ColumnData;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.StringUtil;
import workbench.util.WbThread;

public class ReferenceTableNavigator
implements ListSelectionListener,
ActionListener,
PopupMenuListener,
MenuListener,
PropertyChangeListener {
    private MainWindow container;
    private WbTable source;
    private WbMenu selectParentTables;
    private WbMenu selectChildTables;
    private boolean parentMenuInitialized;
    private boolean childMenuInitialized;
    private TableIdentifier baseTable;
    private ReferenceTableNavigation parentNavigation;
    private ReferenceTableNavigation childNavigation;
    private final Object parentLock = new Object();
    private final Object childLock = new Object();
    private final Object connectionLock = new Object();

    public ReferenceTableNavigator(DwPanel dwPanel, MainWindow mainWindow) {
        this.setSourceTable(dwPanel.getTable());
        dwPanel.addPropertyChangeListener("updateTable", this);
        this.container = mainWindow;
        this.rebuildMenu();
    }

    private void setSourceTable(WbTable wbTable) {
        if (this.source != null) {
            this.source.getSelectionModel().removeListSelectionListener(this);
        }
        this.source = wbTable;
        this.source.getSelectionModel().addListSelectionListener(this);
        this.selectParentTables = new WbMenu(ResourceMgr.getString("MnuTxtReferencedRows"));
        this.selectParentTables.addMenuListener(this);
        this.selectParentTables.getPopupMenu().addPopupMenuListener(this);
        this.selectParentTables.setEnabled(false);
        this.parentMenuInitialized = false;
        this.selectChildTables = new WbMenu(ResourceMgr.getString("MnuTxtReferencingRows"));
        this.selectChildTables.addMenuListener(this);
        this.selectChildTables.getPopupMenu().addPopupMenuListener(this);
        this.selectChildTables.setEnabled(false);
        this.childMenuInitialized = false;
        this.source.addPopupMenu(this.selectParentTables, true);
        this.source.addPopupMenu(this.selectChildTables, false);
    }

    public void removeFromPopup() {
        if (this.source == null) {
            return;
        }
        this.source.removeSubmenu(this.selectChildTables);
        this.source.removeSubmenu(this.selectParentTables);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        boolean bl = this.source.getSelectedRowCount() > 0;
        this.selectParentTables.setEnabled(bl);
        this.selectChildTables.setEnabled(bl);
    }

    private TableIdentifier getUpdateTable() {
        if (this.baseTable != null) {
            return this.baseTable;
        }
        TableIdentifier tableIdentifier = this.source.getDataStore().getUpdateTable();
        if (tableIdentifier == null && this.source.getDataStore().checkUpdateTable()) {
            tableIdentifier = this.source.getDataStore().getUpdateTable();
        }
        if (tableIdentifier != null) {
            this.baseTable = tableIdentifier.createCopy();
            if (this.baseTable.getSchema() == null) {
                String string = this.getConnection().getMetadata().getSchemaToUse();
                this.baseTable.setSchema(string);
            }
        }
        return this.baseTable;
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
        this.closePopup(menuEvent);
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
        this.selectParentTables.getPopupMenu().setVisible(false);
        this.selectChildTables.getPopupMenu().setVisible(false);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        JPopupMenu jPopupMenu = (JPopupMenu)popupMenuEvent.getSource();
        if (jPopupMenu == this.selectParentTables.getPopupMenu() && !this.parentMenuInitialized) {
            this.buildParentTablesMenu();
        }
        if (jPopupMenu == this.selectChildTables.getPopupMenu() && !this.childMenuInitialized) {
            this.buildChildTablesMenu();
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        this.closePopup(popupMenuEvent);
    }

    private void closePopup(EventObject eventObject) {
        if (eventObject.getSource() == this.selectParentTables.getPopupMenu()) {
            this.selectParentTables.getPopupMenu().setVisible(false);
        }
        if (eventObject.getSource() == this.selectChildTables.getPopupMenu()) {
            this.selectChildTables.getPopupMenu().setVisible(false);
        }
    }

    private WbConnection getConnection() {
        return this.source.getDataStore().getOriginalConnection();
    }

    private JMenuItem createLoadingItem() {
        JMenuItem jMenuItem = new JMenuItem(ResourceMgr.getString("MsgLoadDependency"));
        jMenuItem.setVisible(true);
        jMenuItem.setEnabled(false);
        return jMenuItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildMenu() {
        Object object = this.parentLock;
        synchronized (object) {
            this.selectParentTables.removeAll();
            this.selectParentTables.add(this.createLoadingItem());
            this.parentMenuInitialized = false;
        }
        object = this.childLock;
        synchronized (object) {
            this.selectChildTables.removeAll();
            this.selectChildTables.add(this.createLoadingItem());
            this.childMenuInitialized = false;
        }
    }

    private void buildChildTablesMenu() {
        WbThread wbThread = new WbThread("InitChildren"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ReferenceTableNavigator.this.connectionLock;
                synchronized (object) {
                    ReferenceTableNavigator.this.childNavigation = new ReferenceTableNavigation(ReferenceTableNavigator.this.getUpdateTable(), ReferenceTableNavigator.this.getConnection());
                    ReferenceTableNavigator.this.childNavigation.readTreeForChildren();
                }
                object = ReferenceTableNavigator.this.childLock;
                synchronized (object) {
                    ReferenceTableNavigator.this.buildMenu(ReferenceTableNavigator.this.selectChildTables, ReferenceTableNavigator.this.childNavigation, "select-child");
                    ReferenceTableNavigator.this.childMenuInitialized = true;
                }
            }
        };
        wbThread.start();
    }

    private void buildParentTablesMenu() {
        WbThread wbThread = new WbThread("InitParents"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ReferenceTableNavigator.this.connectionLock;
                synchronized (object) {
                    ReferenceTableNavigator.this.parentNavigation = new ReferenceTableNavigation(ReferenceTableNavigator.this.getUpdateTable(), ReferenceTableNavigator.this.getConnection());
                    ReferenceTableNavigator.this.parentNavigation.readTreeForParents();
                }
                object = ReferenceTableNavigator.this.parentLock;
                synchronized (object) {
                    ReferenceTableNavigator.this.buildMenu(ReferenceTableNavigator.this.selectParentTables, ReferenceTableNavigator.this.parentNavigation, "select-parent");
                    ReferenceTableNavigator.this.parentMenuInitialized = true;
                }
            }
        };
        wbThread.start();
    }

    private void buildMenu(WbMenu wbMenu, ReferenceTableNavigation referenceTableNavigation, String string) {
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        TableIdentifier tableIdentifier = this.getUpdateTable();
        if (tableIdentifier != null) {
            TableDependency tableDependency = referenceTableNavigation.getTree();
            List<DependencyNode> list = tableDependency.getLeafs();
            if (CollectionUtil.isEmpty(list)) {
                JMenuItem jMenuItem3 = new JMenuItem(ResourceMgr.getString("MnuTxtNoTables"));
                jMenuItem3.setEnabled(false);
                jMenuItem3.setVisible(true);
                arrayList.add(jMenuItem3);
            } else {
                for (DependencyNode dependencyNode : list) {
                    Map<String, String> map = dependencyNode.getColumns();
                    Collection<String> collection = dependencyNode.getColumns().values();
                    StringBuilder stringBuilder = new StringBuilder(collection.size() * 10);
                    StringBuilder stringBuilder2 = new StringBuilder(collection.size() * 20);
                    stringBuilder.append(dependencyNode.getTable().getTableName());
                    stringBuilder.append(" (");
                    int n = 0;
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        if (n > 0) {
                            stringBuilder.append(',');
                            stringBuilder2.append(',');
                        }
                        stringBuilder.append(entry.getKey());
                        stringBuilder2.append(this.getUpdateTable().getTableName());
                        stringBuilder2.append('.');
                        stringBuilder2.append(entry.getValue());
                        stringBuilder2.append(" > ");
                        stringBuilder2.append(dependencyNode.getTable().getTableName());
                        stringBuilder2.append('.');
                        stringBuilder2.append(entry.getKey());
                        ++n;
                    }
                    stringBuilder.append(')');
                    EditorTabSelectMenu editorTabSelectMenu = new EditorTabSelectMenu(stringBuilder.toString(), "LblShowDataInNewTab", "MsgRelatedTabHint", this.container);
                    editorTabSelectMenu.setActionListener(this);
                    editorTabSelectMenu.setDependencyNode(dependencyNode);
                    editorTabSelectMenu.setVisible(true);
                    editorTabSelectMenu.setToolTipText(stringBuilder2.toString());
                    boolean bl = this.hasColumns(dependencyNode);
                    editorTabSelectMenu.setEnabled(bl);
                    if (!bl) {
                        editorTabSelectMenu.setToolTipText(ResourceMgr.getString("MsgRelatedNoColumns"));
                    }
                    editorTabSelectMenu.setActionCommand(string);
                    arrayList.add(editorTabSelectMenu);
                }
            }
        } else {
            JMenuItem jMenuItem4 = new JMenuItem(ResourceMgr.getString("MnuTxtNoUpdTbl"));
            jMenuItem4.setEnabled(false);
            arrayList.add(jMenuItem4);
        }
        arrayList.sort((jMenuItem, jMenuItem2) -> jMenuItem.getText().compareTo(jMenuItem2.getText()));
        this.addMenuItems(wbMenu, arrayList);
    }

    private boolean hasColumns(DependencyNode dependencyNode) {
        Map<String, String> map = dependencyNode.getColumns();
        DataStore dataStore = this.source.getDataStore();
        for (String string : map.values()) {
            if (dataStore.getColumnIndex(string) != -1) continue;
            return false;
        }
        return true;
    }

    private void addMenuItems(WbMenu wbMenu, List<JMenuItem> list) {
        WbSwingUtilities.invoke(() -> {
            WbMenu wbMenu2 = wbMenu;
            synchronized (wbMenu2) {
                wbMenu.removeAll();
                for (JMenuItem jMenuItem : list) {
                    wbMenu.add(jMenuItem);
                }
                JPopupMenu jPopupMenu = wbMenu.getPopupMenu();
                if (jPopupMenu.isVisible()) {
                    jPopupMenu.invalidate();
                    jPopupMenu.setVisible(false);
                    jPopupMenu.setVisible(true);
                }
            }
        });
    }

    private List<List<ColumnData>> getColumnData(DependencyNode dependencyNode) {
        ArrayList<List<ColumnData>> arrayList = new ArrayList<List<ColumnData>>();
        int[] nArray = this.source.getSelectedRows();
        int n = nArray.length;
        Map<String, String> map = dependencyNode.getColumns();
        DataStore dataStore = this.source.getDataStore();
        ColumnIdentifier[] columnIdentifierArray = dataStore.getColumns();
        for (int i = 0; i < n; ++i) {
            ArrayList<ColumnData> arrayList2 = new ArrayList<ColumnData>();
            for (String string : map.values()) {
                int n2 = dataStore.getColumnIndex(string);
                if (n2 <= -1) continue;
                Object object = dataStore.getValue(nArray[i], n2);
                ColumnData columnData = new ColumnData(object, columnIdentifierArray[n2]);
                arrayList2.add(columnData);
            }
            if (arrayList2.size() <= 0) continue;
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Serializable serializable;
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        String string = jMenuItem.getActionCommand();
        int n = -42;
        ResultReceiver.ShowType showType = GuiSettings.getDefaultShowType();
        if (string.startsWith("panel_")) {
            n = StringUtil.getIntValue(string.substring("panel_".length()), -1);
            serializable = (JPopupMenu)jMenuItem.getParent();
            jMenuItem = (JMenuItem)((JPopupMenu)serializable).getInvoker();
            string = jMenuItem.getActionCommand();
        }
        if (n == -1) {
            showType = GuiSettings.getDefaultShowTypeNewTab();
        }
        serializable = null;
        String string2 = null;
        String string3 = null;
        if (!(jMenuItem instanceof EditorTabSelectMenu)) {
            WbSwingUtilities.showErrorMessage(this.container, "Menu was incorrectly initialized!");
            return;
        }
        Object object2 = ((EditorTabSelectMenu)jMenuItem).getDependencyNode();
        serializable = ((DependencyNode)object2).getTable();
        string2 = ((DependencyNode)object2).getFkName();
        object2 = null;
        List<List<ColumnData>> list = null;
        try {
            if ("select-child".equals(string)) {
                object = this.childNavigation.getNodeForTable((TableIdentifier)serializable, string2);
                if (object == null) {
                    string3 = "Could not find child table from menu item!";
                    LogMgr.logError(new CallerInfo(){}, string3, null);
                } else {
                    list = this.getColumnData((DependencyNode)object);
                    object2 = this.childNavigation.getSelectForChild((TableIdentifier)serializable, string2, list);
                }
            } else if ("select-parent".equals(string)) {
                object = this.parentNavigation.getNodeForTable((TableIdentifier)serializable, string2);
                if (object == null) {
                    string3 = "Could not find parent table from menu item!";
                    LogMgr.logError(new CallerInfo(){}, string3, null);
                } else {
                    list = this.getColumnData((DependencyNode)object);
                    object2 = this.parentNavigation.getSelectForParent((TableIdentifier)serializable, string2, list);
                }
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when creating SQL", exception);
            string3 = ExceptionUtil.getDisplay(exception);
        }
        if (object2 == null || string3 != null) {
            WbSwingUtilities.showErrorMessage(this.container, string3);
            return;
        }
        object = ResourceMgr.getFormattedString("MsgLoadRelatedComment", ((TableIdentifier)serializable).getTableName(), this.getUpdateTable().getTableName(), string2);
        if (this.container != null) {
            PanelContentSender panelContentSender = new PanelContentSender(this.container, null);
            panelContentSender.showResult((String)object2, (String)object, n, showType);
        }
    }

    public void reset() {
        this.baseTable = null;
        this.rebuildMenu();
    }

    public void dispose() {
        this.selectParentTables.dispose();
        this.parentMenuInitialized = false;
        this.selectChildTables.dispose();
        this.childMenuInitialized = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("updateTable")) {
            this.reset();
        }
    }
}

