/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.sql;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;
import workbench.gui.actions.AutomaticReloadAction;
import workbench.gui.actions.CancelAutoReloadAction;
import workbench.gui.actions.CloseAllResultsAction;
import workbench.gui.actions.CloseEmptyResultsAction;
import workbench.gui.actions.CloseOtherResultsAction;
import workbench.gui.actions.CloseResultTabAction;
import workbench.gui.actions.DetachResultTabAction;
import workbench.gui.actions.LockResultTabAction;
import workbench.gui.actions.RenameTabAction;
import workbench.gui.actions.ShowSourceQueryAction;
import workbench.gui.actions.SqlPanelReloadAction;
import workbench.gui.sql.RenameableTab;
import workbench.gui.sql.SqlPanel;
import workbench.resource.ResourceMgr;
import workbench.util.StringUtil;

public class ResultTabHandler
implements MouseListener,
RenameableTab {
    private JTabbedPane resultTab;
    private SqlPanel client;

    public ResultTabHandler(JTabbedPane jTabbedPane, SqlPanel sqlPanel) {
        this.resultTab = jTabbedPane;
        this.resultTab.addMouseListener(this);
        this.client = sqlPanel;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        boolean bl;
        if (mouseEvent.getSource() != this.resultTab) {
            return;
        }
        int n = this.resultTab.getSelectedIndex();
        boolean bl2 = bl = n != this.resultTab.getTabCount() - 1;
        if (!bl) {
            return;
        }
        if (mouseEvent.getButton() == 3) {
            JPopupMenu jPopupMenu = this.createPopup();
            jPopupMenu.show(this.resultTab, mouseEvent.getX(), mouseEvent.getY());
        } else if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
            ShowSourceQueryAction showSourceQueryAction = new ShowSourceQueryAction(this.client);
            showSourceQueryAction.showQuery();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private JPopupMenu createPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new RenameTabAction(this));
        jPopupMenu.add(new ShowSourceQueryAction(this.client));
        jPopupMenu.add(new SqlPanelReloadAction(this.client));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new CloseResultTabAction(this.client));
        jPopupMenu.add(new CloseOtherResultsAction(this.client));
        jPopupMenu.add(new CloseEmptyResultsAction(this.client));
        jPopupMenu.add(new CloseAllResultsAction(this.client));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new AutomaticReloadAction(this.client));
        jPopupMenu.add(new CancelAutoReloadAction(this.client));
        jPopupMenu.addSeparator();
        LockResultTabAction lockResultTabAction = new LockResultTabAction(this.client);
        jPopupMenu.add(lockResultTabAction.getMenuItem());
        jPopupMenu.add(new DetachResultTabAction(this.client));
        return jPopupMenu;
    }

    @Override
    public Component getComponent() {
        return this.resultTab;
    }

    @Override
    public void setCurrentTabTitle(String string) {
        int n = this.resultTab.getSelectedIndex();
        if (StringUtil.isBlank(string)) {
            string = ResourceMgr.getString("LblTabResult");
        }
        this.resultTab.setTitleAt(n, string);
    }

    @Override
    public String getCurrentTabTitle() {
        int n = this.resultTab.getSelectedIndex();
        return this.resultTab.getTitleAt(n);
    }

    @Override
    public boolean canRenameTab() {
        return true;
    }

    @Override
    public void addTabChangeListener(ChangeListener changeListener) {
        this.resultTab.addChangeListener(changeListener);
    }
}

