/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import workbench.db.ColumnIdentifier;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.WbScrollPane;
import workbench.gui.tools.ColumnMapRow;
import workbench.gui.tools.MapDataModel;
import workbench.gui.tools.SkipColumnIndicator;
import workbench.resource.Settings;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class ColumnMapper
extends JPanel {
    private JTable columnDisplay;
    private List<ColumnIdentifier> sourceColumns;
    private List<ColumnIdentifier> targetColumns;
    private ColumnMapRow[] mapping;
    protected JComboBox sourceDropDown;
    private final MapDataModel EMPTY_DATA_MODEL = new MapDataModel(new ColumnMapRow[0]);
    private MapDataModel data;
    private boolean allowTargetEditing = false;
    protected boolean allowSourceEditing = false;
    static final SkipColumnIndicator SKIP_COLUMN = new SkipColumnIndicator();

    public ColumnMapper() {
        this.setLayout(new BorderLayout());
        this.columnDisplay = this.createMappingTable();
        this.columnDisplay.setAutoResizeMode(4);
        this.columnDisplay.setRowSelectionAllowed(false);
        WbScrollPane wbScrollPane = new WbScrollPane(this.columnDisplay);
        this.add((Component)wbScrollPane, "Center");
        this.columnDisplay.setModel(this.EMPTY_DATA_MODEL);
        this.adjustKeyColumn();
    }

    private void adjustKeyColumn() {
        TableColumnModel tableColumnModel = this.columnDisplay.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(2);
        Font font = this.columnDisplay.getTableHeader().getFont();
        FontMetrics fontMetrics = this.columnDisplay.getTableHeader().getFontMetrics(font);
        String string = tableColumnModel.getColumn(2).getHeaderValue().toString();
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.stringWidth("WWWW");
        tableColumn.setMinWidth(n + n2);
        tableColumn.setMaxWidth(n + n2);
    }

    public void resetData() {
        if (this.columnDisplay.getModel() != this.EMPTY_DATA_MODEL) {
            this.columnDisplay.setModel(this.EMPTY_DATA_MODEL);
        }
    }

    private JTable createMappingTable() {
        JTable jTable = new JTable(){

            @Override
            public TableCellEditor getCellEditor(int n, int n2) {
                TableCellEditor tableCellEditor = super.getCellEditor(n, n2);
                if (ColumnMapper.this.allowSourceEditing && n2 == 0) {
                    Object object = this.getValueAt(n, n2);
                    if (object == null || object instanceof SkipColumnIndicator) {
                        ColumnMapper.this.sourceDropDown.setEditable(false);
                    } else {
                        ColumnMapper.this.sourceDropDown.setEditable(ColumnMapper.this.allowSourceEditing);
                    }
                }
                return tableCellEditor;
            }
        };
        return jTable;
    }

    public void defineColumns(List<ColumnIdentifier> list, List<ColumnIdentifier> list2, boolean bl, boolean bl2) {
        Serializable serializable;
        Serializable serializable2;
        Object object;
        if (list == null || list2 == null) {
            throw new IllegalArgumentException("Both column lists have to be specified");
        }
        this.sourceColumns = list;
        this.targetColumns = list2;
        int n = this.targetColumns.size();
        this.mapping = new ColumnMapRow[n];
        for (int i = 0; i < n; ++i) {
            object = new ColumnMapRow();
            serializable2 = this.targetColumns.get(i);
            ((ColumnMapRow)object).setTarget((ColumnIdentifier)serializable2);
            serializable = this.findSourceColumnByName(SqlUtil.removeObjectQuotes(serializable2.getDisplayName()));
            if (bl && serializable != null) {
                ((ColumnIdentifier)serializable).setDataType(serializable2.getDataType());
                ((ColumnIdentifier)serializable).setColumnTypeName(serializable2.getColumnTypeName());
                ((ColumnIdentifier)serializable).setDbmsType(serializable2.getDbmsType());
                ((ColumnIdentifier)serializable).setDecimalDigits(serializable2.getDecimalDigits());
            }
            ((ColumnMapRow)object).setSource((ColumnIdentifier)serializable);
            this.mapping[i] = object;
        }
        this.data = new MapDataModel(this.mapping);
        if (bl2) {
            this.data.sortBySourcePosition();
        }
        this.data.setAllowTargetEditing(this.allowTargetEditing);
        this.columnDisplay.setModel(this.data);
        TableColumnModel tableColumnModel = this.columnDisplay.getColumnModel();
        object = tableColumnModel.getColumn(0);
        this.sourceDropDown = this.createDropDown(this.sourceColumns, true);
        serializable2 = this.sourceDropDown.getEditor().getEditorComponent();
        if (serializable2 instanceof JComponent) {
            serializable = (JComponent)serializable2;
            ((JComponent)serializable).setBorder(WbSwingUtilities.EMPTY_BORDER);
        }
        serializable = new DefaultCellEditor(this.sourceDropDown);
        ((TableColumn)object).setCellEditor((TableCellEditor)((Object)serializable));
        JTextField jTextField = new JTextField();
        Font font = Settings.getInstance().getDataFont();
        if (font != null) {
            jTextField.setFont(font);
        }
        jTextField.setBorder(WbSwingUtilities.EMPTY_BORDER);
        serializable = new DefaultCellEditor(jTextField);
        object = tableColumnModel.getColumn(1);
        ((TableColumn)object).setCellEditor((TableCellEditor)((Object)serializable));
        this.adjustKeyColumn();
        this.columnDisplay.setRowHeight(20);
    }

    public ColumnIdentifier findSourceColumnByName(String string) {
        for (ColumnIdentifier columnIdentifier : this.sourceColumns) {
            if (!SqlUtil.removeObjectQuotes(columnIdentifier.getDisplayName()).equalsIgnoreCase(string)) continue;
            return columnIdentifier;
        }
        return null;
    }

    public void setAllowSourceEditing(boolean bl) {
        this.allowSourceEditing = bl;
        this.sourceDropDown.setEditable(bl);
    }

    public void setAllowTargetEditing(boolean bl) {
        this.allowTargetEditing = true;
        if (this.data != null) {
            this.data.setAllowTargetEditing(bl);
        }
    }

    private JComboBox createDropDown(List list, boolean bl) {
        JComboBox<SkipColumnIndicator> jComboBox = new JComboBox<SkipColumnIndicator>();
        Font font = Settings.getInstance().getDataFont();
        if (font != null) {
            jComboBox.setFont(font);
        }
        jComboBox.setEditable(bl);
        int n = list.size();
        if (bl) {
            jComboBox.addItem(SKIP_COLUMN);
        }
        for (int i = 0; i < n; ++i) {
            jComboBox.addItem((SkipColumnIndicator)list.get(i));
        }
        return jComboBox;
    }

    private ColumnIdentifier getTargetColumn(ColumnIdentifier columnIdentifier) {
        for (ColumnMapRow columnMapRow : this.mapping) {
            ColumnIdentifier columnIdentifier2 = columnMapRow.getSource();
            if (columnIdentifier2 == null || !columnIdentifier2.getDisplayName().equals(columnIdentifier.getDisplayName())) continue;
            return columnMapRow.getTarget();
        }
        return null;
    }

    public List<ColumnIdentifier> getMappingForImport() {
        int n = this.sourceColumns.size();
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>(n);
        ColumnIdentifier columnIdentifier = new ColumnIdentifier("$wb_skip$");
        for (int i = 0; i < n; ++i) {
            ColumnIdentifier columnIdentifier2 = this.sourceColumns.get(i);
            ColumnIdentifier columnIdentifier3 = this.getTargetColumn(columnIdentifier2);
            if (columnIdentifier3 == null) {
                arrayList.add(columnIdentifier);
                continue;
            }
            arrayList.add(columnIdentifier3);
        }
        return arrayList;
    }

    MappingDefinition getMapping() {
        int n = this.mapping.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ColumnMapRow columnMapRow = this.mapping[i];
            String string = null;
            if (columnMapRow.getSource() == null || StringUtil.isBlank(string = columnMapRow.getSource().getDisplayName())) continue;
            ++n2;
        }
        MappingDefinition mappingDefinition = new MappingDefinition();
        mappingDefinition.sourceColumns = new ColumnIdentifier[n2];
        mappingDefinition.targetColumns = new ColumnIdentifier[n2];
        mappingDefinition.hasSkippedColumns = n2 != n;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            ColumnMapRow columnMapRow = this.mapping[i];
            String string = null;
            if (columnMapRow.getSource() == null || StringUtil.isBlank(string = columnMapRow.getSource().getDisplayName())) continue;
            mappingDefinition.sourceColumns[n3] = columnMapRow.getSource();
            mappingDefinition.targetColumns[n3] = columnMapRow.getTarget();
            ++n3;
        }
        return mappingDefinition;
    }

    static class MappingDefinition {
        public ColumnIdentifier[] sourceColumns;
        public ColumnIdentifier[] targetColumns;
        public boolean hasSkippedColumns;

        MappingDefinition() {
        }
    }
}

