/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import workbench.WbManager;
import workbench.db.ConnectionMgr;
import workbench.db.ConnectionProfile;
import workbench.db.DbObject;
import workbench.db.WbConnection;
import workbench.db.search.ObjectSourceSearcher;
import workbench.gui.MainWindow;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.DividerBorder;
import workbench.gui.components.EditWindow;
import workbench.gui.components.FlatButton;
import workbench.gui.components.TextComponentMouseListener;
import workbench.gui.components.WbScrollPane;
import workbench.gui.components.WbSplitPane;
import workbench.gui.components.WbStatusLabel;
import workbench.gui.components.WbTable;
import workbench.gui.dbobjects.DbObjectSourcePanel;
import workbench.gui.profiles.ProfileSelectionDialog;
import workbench.interfaces.ToolWindow;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.wbcommands.CommandTester;
import workbench.sql.wbcommands.ObjectResultListDataStore;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.StringUtil;
import workbench.util.WbThread;

public class ObjectSourceSearchPanel
extends JPanel
implements ListSelectionListener,
WindowListener,
ToolWindow {
    private boolean standalone;
    private WbConnection connection;
    private ObjectSourceSearcher searcher;
    private JFrame window;
    private WbTable results;
    private DbObjectSourcePanel objectSource;
    private WbThread searchThread;
    private int instanceId = ++instanceCount;
    private static int instanceCount;
    private JPanel buttonPanel;
    private JComboBox<String> catalogDD;
    private JLabel catalogLabel;
    private JButton closeButton;
    private JPanel footerPanel;
    private JCheckBox ignoreCase;
    private JPanel jPanel1;
    private JCheckBox matchAll;
    private JLabel nameLabel;
    private JTextField objectNames;
    private JTextField objectTypes;
    private JCheckBox regex;
    private JPanel resultContainer;
    private JLabel schemaLabel;
    private JTextField schemaNames;
    private JTextField searchValues;
    private JButton selectConnection;
    private JButton selectSchemasButton;
    private JButton selectTypesButton;
    private JButton showScriptButton;
    private JSplitPane splitPane;
    private JButton startButton;
    private JLabel statusbar;
    private JPanel topPanel;
    private JLabel typeLabel;
    private JLabel valueLabel;

    public ObjectSourceSearchPanel() {
        this.initComponents();
        WbSwingUtilities.makeEqualWidth(this.closeButton, this.showScriptButton, this.startButton);
        this.checkButtons();
        this.results = new WbTable(true, false, false);
        WbScrollPane wbScrollPane = new WbScrollPane(this.results);
        this.results.getSelectionModel().setSelectionMode(0);
        this.results.getSelectionModel().addListSelectionListener(this);
        ((WbSplitPane)this.splitPane).setDividerBorder(WbSwingUtilities.EMPTY_BORDER);
        this.objectSource = new DbObjectSourcePanel(null, null);
        this.objectSource.setEditable(false);
        this.splitPane.setRightComponent(this.objectSource);
        this.splitPane.setLeftComponent(wbScrollPane);
        CompoundBorder compoundBorder = new CompoundBorder(new DividerBorder(8), new EmptyBorder(5, 5, 5, 5));
        this.topPanel.setBorder(compoundBorder);
        this.clearSearch();
        TextComponentMouseListener.addListener(this.objectNames, this.searchValues, this.objectTypes, this.schemaNames);
    }

    private void checkCatalogDD() {
        boolean bl = false;
        if (this.connection != null) {
            bl = this.connection.getDbSettings().supportsCatalogs() && this.connection.getDbSettings().supportsSchemas();
            String string = StringUtil.capitalize(this.connection.getMetadata().getCatalogTerm());
            this.catalogLabel.setText(string);
            List<String> list = this.connection.getMetadata().getCatalogs();
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
            this.catalogDD.setModel(defaultComboBoxModel);
            String string2 = this.connection.getCurrentCatalog();
            if (string2 != null) {
                this.catalogDD.setSelectedItem(string2);
            }
        }
        this.catalogLabel.setVisible(bl);
        this.catalogDD.setVisible(bl);
    }

    private String getSelectedCatalog() {
        if (this.catalogDD.isVisible()) {
            return (String)this.catalogDD.getSelectedItem();
        }
        return null;
    }

    protected void clearSearch() {
        this.objectSource.reset();
        this.setModel(new ObjectResultListDataStore());
    }

    protected void startSearch() {
        this.clearSearch();
        this.searcher = new ObjectSourceSearcher(this.connection);
        this.searcher.setRowMonitor(((WbStatusLabel)this.statusbar).getMonitor());
        this.startButton.setText(ResourceMgr.getString("LblCancelPlain"));
        List<String> list = StringUtil.stringToList(this.schemaNames.getText(), ",", true, true, false);
        List<String> list2 = StringUtil.stringToList(this.objectNames.getText(), ",", true, true, false);
        List<String> list3 = StringUtil.stringToList(this.objectTypes.getText(), ",", true, true, false);
        this.searcher.setSchemasToSearch(list);
        this.searcher.setNamesToSearch(list2);
        this.searcher.setTypesToSearch(list3);
        this.searcher.setCatalog(this.getSelectedCatalog());
        final List<String> list4 = StringUtil.stringToList(this.searchValues.getText(), ",", true, true, false);
        this.window.setTitle("\u00bb " + ResourceMgr.getString("TxtWindowTitleObjectSearcher"));
        this.searchThread = new WbThread("SourceSearch"){

            @Override
            public void run() {
                try {
                    List<DbObject> list = ObjectSourceSearchPanel.this.searcher.searchObjects(list4, ObjectSourceSearchPanel.this.matchAll.isSelected(), ObjectSourceSearchPanel.this.ignoreCase.isSelected(), ObjectSourceSearchPanel.this.regex.isSelected());
                    ObjectSourceSearchPanel.this.showResult(list);
                }
                catch (Exception exception) {
                    LogMgr.logError(new CallerInfo(){}, "Error while searching", exception);
                }
                finally {
                    ObjectSourceSearchPanel.this.searchEnded();
                }
            }
        };
        this.selectConnection.setEnabled(false);
        this.searchThread.start();
    }

    protected void searchEnded() {
        this.searchThread = null;
        WbSwingUtilities.invoke(() -> {
            this.window.setTitle(ResourceMgr.getString("TxtWindowTitleObjectSearcher"));
            String string = ResourceMgr.getFormattedString("MsgGrepSourceFinished", this.searcher.getNumberOfObjectsSearched(), this.results.getRowCount());
            this.statusbar.setText(string);
            this.checkButtons();
        });
    }

    protected void checkButtons() {
        if (this.searcher != null && this.searcher.isRunning()) {
            this.startButton.setText(ResourceMgr.getString("LblCancelPlain"));
            this.selectConnection.setEnabled(false);
        } else {
            this.startButton.setText(ResourceMgr.getString("LblStartSearch"));
            this.startButton.setEnabled(this.connection != null);
            this.selectConnection.setEnabled(true);
        }
        this.selectTypesButton.setEnabled(this.connection != null);
        this.selectSchemasButton.setEnabled(this.connection != null);
    }

    protected void showResult(List<DbObject> list) throws SQLException {
        try {
            ObjectResultListDataStore objectResultListDataStore = new ObjectResultListDataStore();
            objectResultListDataStore.setResultList(this.connection, list, this.searcher.getSearchSchemaCount() > 1);
            this.setModel(objectResultListDataStore);
        }
        finally {
            this.checkButtons();
        }
    }

    protected void removeSourceColumn() {
        TableColumnModel tableColumnModel = this.results.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(2);
        tableColumnModel.removeColumn(tableColumn);
    }

    protected void setModel(DataStore dataStore) {
        EventQueue.invokeLater(() -> {
            DataStoreTableModel dataStoreTableModel = new DataStoreTableModel(dataStore);
            this.results.setModel(dataStoreTableModel, true);
            this.results.adjustRowsAndColumns();
            this.removeSourceColumn();
        });
    }

    protected void cancelSearch() {
        if (this.searcher != null) {
            this.searcher.cancelSearch();
        }
    }

    protected void selectConnection() {
        String string = "workbench.objectsearcher.lastprofile";
        ConnectionProfile connectionProfile = null;
        try {
            WbSwingUtilities.showWaitCursor(this.window);
            ProfileSelectionDialog profileSelectionDialog = new ProfileSelectionDialog((Frame)this.window, true, string);
            WbSwingUtilities.center(profileSelectionDialog, this.window);
            WbSwingUtilities.showDefaultCursor(this.window);
            profileSelectionDialog.setVisible(true);
            boolean bl = profileSelectionDialog.isCancelled();
            if (!bl) {
                connectionProfile = profileSelectionDialog.getSelectedProfile();
                if (connectionProfile != null) {
                    Settings.getInstance().setProperty(string, connectionProfile.getName());
                } else {
                    LogMgr.logError(new CallerInfo(){}, "NULL Profile selected!", null);
                }
            }
            profileSelectionDialog.setVisible(false);
            profileSelectionDialog.dispose();
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error during connect", throwable);
            connectionProfile = null;
        }
        if (connectionProfile != null) {
            this.disconnect();
            this.connect(connectionProfile);
        }
    }

    protected void connect(final ConnectionProfile connectionProfile) {
        this.clearSearch();
        this.statusbar.setText(ResourceMgr.getString("MsgConnecting"));
        this.selectConnection.setEnabled(false);
        WbSwingUtilities.showWaitCursor(this.window);
        WbThread wbThread = new WbThread("Connection"){

            @Override
            public void run() {
                try {
                    ObjectSourceSearchPanel.this.connection = ConnectionMgr.getInstance().getConnection(connectionProfile, "ObjectSearcher-" + ObjectSourceSearchPanel.this.instanceId);
                }
                catch (Exception exception) {
                    LogMgr.logError(new CallerInfo(){}, "Error during connect", exception);
                    String string = ExceptionUtil.getDisplay(exception);
                    WbSwingUtilities.showFriendlyErrorMessage(ObjectSourceSearchPanel.this, ResourceMgr.getString("ErrConnectFailed"), string);
                    ObjectSourceSearchPanel.this.connection = null;
                }
                finally {
                    ObjectSourceSearchPanel.this.connectEnded();
                }
            }
        };
        wbThread.start();
    }

    public void connectEnded() {
        WbSwingUtilities.showDefaultCursor(this.window);
        this.objectSource.setDatabaseConnection(this.connection);
        EventQueue.invokeLater(() -> {
            this.statusbar.setText("");
            this.checkButtons();
            this.checkCatalogDD();
            this.updateWindowTitle();
        });
    }

    protected void updateWindowTitle() {
        String string = ResourceMgr.getString("TxtWindowTitleObjectSearcher");
        if (this.connection != null && this.connection.getProfile() != null) {
            String string2 = this.connection.getProfile().getName();
            string = string + " [" + string2 + "]";
        }
        if (this.searcher != null && this.searcher.isRunning()) {
            string = "\u00bb " + string;
        }
        this.window.setTitle(string);
    }

    public void saveSettings() {
        Settings settings = Settings.getInstance();
        settings.setProperty("workbench.objectsearcher.ignorecase", this.ignoreCase.isSelected());
        settings.setProperty("workbench.objectsearcher.matchall", this.matchAll.isSelected());
        settings.setProperty("workbench.objectsearcher.regex", this.regex.isSelected());
        settings.storeWindowSize(this.window, "workbench.objectsearcher.window");
        settings.setProperty("workbench.objectsearcher.searchvalues", this.searchValues.getText());
        settings.setProperty("workbench.objectsearcher.schemas", this.schemaNames.getText());
        settings.setProperty("workbench.objectsearcher.objectnames", this.objectNames.getText());
        settings.setProperty("workbench.objectsearcher.objecttypes", this.objectTypes.getText());
        int n = this.splitPane.getDividerLocation();
        settings.setProperty("workbench.objectsearcher.divider", n);
    }

    public void restoreSettings() {
        Settings settings = Settings.getInstance();
        this.ignoreCase.setSelected(settings.getBoolProperty("workbench.objectsearcher.ignorecase", true));
        this.matchAll.setSelected(settings.getBoolProperty("workbench.objectsearcher.matchall", false));
        this.regex.setSelected(settings.getBoolProperty("workbench.objectsearcher.regex", false));
        if (!settings.restoreWindowSize(this.window, "workbench.objectsearcher.window")) {
            this.window.setSize(800, 600);
        }
        this.searchValues.setText(settings.getProperty("workbench.objectsearcher.searchvalues", ""));
        this.schemaNames.setText(settings.getProperty("workbench.objectsearcher.schemas", ""));
        this.objectNames.setText(settings.getProperty("workbench.objectsearcher.objectnames", ""));
        this.objectTypes.setText(settings.getProperty("workbench.objectsearcher.objecttypes", ""));
        int n = settings.getIntProperty("workbench.objectsearcher.divider", 200);
        this.splitPane.setDividerLocation(n);
    }

    protected void unregister() {
        WbManager.getInstance().unregisterToolWindow(this);
    }

    protected void done() {
        this.cancelSearch();
        this.saveSettings();
        if (this.standalone) {
            this.unregister();
        } else {
            WbThread wbThread = new WbThread("DataPumper disconnect thread"){

                @Override
                public void run() {
                    ObjectSourceSearchPanel.this.disconnect();
                    ObjectSourceSearchPanel.this.unregister();
                }
            };
            wbThread.start();
        }
    }

    @Override
    public void closeWindow() {
        this.done();
        if (this.window != null) {
            this.window.removeWindowListener(this);
            this.window.dispose();
        }
    }

    @Override
    public void disconnect() {
        if (this.connection != null) {
            this.connection.disconnect();
            this.connection = null;
        }
    }

    @Override
    public void activate() {
    }

    @Override
    public WbConnection getConnection() {
        return this.connection;
    }

    @Override
    public JFrame getWindow() {
        return this.window;
    }

    public void showWindow() {
        this.standalone = true;
        this.showWindow(null);
    }

    public void showWindow(MainWindow mainWindow) {
        EventQueue.invokeLater(() -> this._showWindow(mainWindow));
    }

    public void _showWindow(MainWindow mainWindow) {
        this.window = new JFrame(ResourceMgr.getString("TxtWindowTitleObjectSearcher")){

            @Override
            public void setVisible(boolean bl) {
                if (!bl) {
                    ObjectSourceSearchPanel.this.saveSettings();
                }
                super.setVisible(bl);
            }
        };
        ConnectionProfile connectionProfile = mainWindow == null ? null : mainWindow.getCurrentProfile();
        boolean bl = this.standalone || connectionProfile == null || Settings.getInstance().getBoolProperty("workbench.gui.objectsearcher.allowconnect", false);
        this.selectConnection.setVisible(bl);
        this.selectConnection.setEnabled(bl);
        this.window.setDefaultCloseOperation(0);
        ResourceMgr.setWindowIcons((Window)this.window, "searchsource");
        this.window.getContentPane().add(this);
        this.restoreSettings();
        this.window.addWindowListener(this);
        WbManager.getInstance().registerToolWindow(this);
        if (!Settings.getInstance().restoreWindowPosition(this.window, "workbench.objectsearcher.window")) {
            WbSwingUtilities.center(this.window, mainWindow);
        }
        JRootPane jRootPane = this.window.getRootPane();
        jRootPane.setDefaultButton(this.startButton);
        this.window.setVisible(true);
        if (Settings.getInstance().getAutoConnectObjectSearcher() && connectionProfile != null) {
            EventQueue.invokeLater(() -> this.connect(connectionProfile));
        }
    }

    private void selectSchemas() {
        List<String> list;
        if (this.connection == null) {
            return;
        }
        List<String> list2 = this.connection.getMetadata().getSchemas(null, this.getSelectedCatalog());
        String string = this.selectFromList(list2, list = StringUtil.stringToList(this.schemaNames.getText(), ","));
        if (string != null) {
            this.schemaNames.setText(string);
        }
    }

    private void selectObjectTypes() {
        if (this.connection == null) {
            return;
        }
        Collection<String> collection = this.connection.getMetadata().getObjectTypes();
        collection.add("FUNCTION");
        collection.add("PROCEDURE");
        collection.add("TRIGGER");
        List<String> list = StringUtil.stringToList(this.objectTypes.getText(), ",", true, true, false, false);
        String string = this.selectFromList(collection, list);
        if (string != null) {
            this.objectTypes.setText(string);
        }
    }

    private String selectFromList(Collection<String> collection, List<String> list) {
        int n;
        Object[] objectArray;
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (String string : collection) {
            defaultListModel.addElement(string);
        }
        JList jList = new JList(defaultListModel);
        if (CollectionUtil.isNonEmpty(list)) {
            int n2;
            int n3 = -1;
            objectArray = new int[list.size()];
            for (n2 = 0; n2 < list.size(); ++n2) {
                n = defaultListModel.indexOf(list.get(n2));
                if (n <= -1) continue;
                objectArray[n2] = n;
                if (n3 != -1) continue;
                n3 = n;
            }
            n2 = n3;
            EventQueue.invokeLater(() -> ObjectSourceSearchPanel.lambda$selectFromList$5(jList, (int[])objectArray, n2));
        }
        jList.setVisibleRowCount(14);
        JScrollPane jScrollPane = new JScrollPane(jList);
        if (WbSwingUtilities.getOKCancel("Select type", this, jScrollPane) && (objectArray = (Object[])jList.getSelectedValues()) != null) {
            StringBuilder stringBuilder = new StringBuilder(objectArray.length * 5);
            for (n = 0; n < objectArray.length; ++n) {
                if (n > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(objectArray[n].toString());
            }
            return stringBuilder.toString();
        }
        return null;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.results.getSelectedRow();
        if (n < 0) {
            return;
        }
        TableModel tableModel = this.results.getModel();
        if (tableModel.getRowCount() == 0) {
            return;
        }
        CharSequence charSequence = (CharSequence)tableModel.getValueAt(n, 2);
        String string = (String)tableModel.getValueAt(n, 0);
        String string2 = (String)tableModel.getValueAt(n, 1);
        EventQueue.invokeLater(() -> {
            this.objectSource.setText(charSequence == null ? "" : charSequence.toString(), string, string2);
            this.objectSource.setCaretPosition(0, false);
            List<String> list = StringUtil.stringToList(this.searchValues.getText(), ",", true, true, false);
            if (list.size() == 1) {
                String string3 = list.get(0);
                int n = this.objectSource.getEditor().findFirst(string3, this.ignoreCase.isSelected(), false, this.regex.isSelected());
                if (n > -1) {
                    this.objectSource.requestFocus();
                }
            }
        });
    }

    public void showWbCommand() {
        CommandTester commandTester = new CommandTester();
        StringBuilder stringBuilder = new StringBuilder(150);
        String string = "\n             ";
        stringBuilder.append(commandTester.formatVerb("WbGrepSource") + " -" + "searchValues" + "=");
        stringBuilder.append(StringUtil.quoteIfNeeded(this.searchValues.getText()));
        stringBuilder.append(string);
        stringBuilder.append("-ignoreCase=" + Boolean.toString(this.ignoreCase.isSelected()));
        stringBuilder.append(string);
        stringBuilder.append("-matchAll=" + Boolean.toString(this.matchAll.isSelected()));
        stringBuilder.append(string);
        stringBuilder.append("-useRegex=" + Boolean.toString(this.regex.isSelected()));
        if (StringUtil.isNonBlank(this.objectTypes.getText())) {
            stringBuilder.append(string);
            stringBuilder.append("-types=" + StringUtil.quoteIfNeeded(this.objectTypes.getText()));
        }
        if (StringUtil.isNonBlank(this.objectNames.getText())) {
            stringBuilder.append(string);
            stringBuilder.append("-objects=" + StringUtil.quoteIfNeeded(this.objectNames.getText()));
        }
        if (StringUtil.isNonBlank(this.schemaNames.getText())) {
            stringBuilder.append(string);
            stringBuilder.append("-schemas=" + StringUtil.quoteIfNeeded(this.schemaNames.getText()));
        }
        stringBuilder.append("\n;");
        EditWindow editWindow = new EditWindow((Frame)this.window, ResourceMgr.getString("TxtWindowTitleGrepScript"), stringBuilder.toString(), "workbench.objectsearcher.scriptwindow", true);
        editWindow.setVisible(true);
        editWindow.dispose();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.closeWindow();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    private void initComponents() {
        this.topPanel = new JPanel();
        this.catalogLabel = new JLabel();
        this.catalogDD = new JComboBox();
        this.schemaLabel = new JLabel();
        this.schemaNames = new JTextField();
        this.nameLabel = new JLabel();
        this.objectNames = new JTextField();
        this.valueLabel = new JLabel();
        this.searchValues = new JTextField();
        this.jPanel1 = new JPanel();
        this.matchAll = new JCheckBox();
        this.ignoreCase = new JCheckBox();
        this.regex = new JCheckBox();
        this.typeLabel = new JLabel();
        this.objectTypes = new JTextField();
        this.selectSchemasButton = new FlatButton();
        this.selectTypesButton = new FlatButton();
        this.selectConnection = new JButton();
        this.resultContainer = new JPanel();
        this.splitPane = new WbSplitPane();
        this.footerPanel = new JPanel();
        this.statusbar = new WbStatusLabel();
        this.buttonPanel = new JPanel();
        this.startButton = new JButton();
        this.showScriptButton = new JButton();
        this.closeButton = new JButton();
        this.setLayout(new BorderLayout());
        this.topPanel.setLayout(new GridBagLayout());
        this.catalogLabel.setText("Catalog");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 7, 0);
        this.topPanel.add((Component)this.catalogLabel, gridBagConstraints);
        this.catalogDD.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 4, 7, 0);
        this.topPanel.add(this.catalogDD, gridBagConstraints);
        this.schemaLabel.setText(ResourceMgr.getString("LblSchemas"));
        this.schemaLabel.setToolTipText(ResourceMgr.getString("d_LblSchemas"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.topPanel.add((Component)this.schemaLabel, gridBagConstraints);
        this.schemaNames.setToolTipText(ResourceMgr.getString("d_LblSchemas"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.topPanel.add((Component)this.schemaNames, gridBagConstraints);
        this.nameLabel.setText(ResourceMgr.getString("LblObjectNames"));
        this.nameLabel.setToolTipText(ResourceMgr.getString("d_LblObjectNames"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 13, 0, 0);
        this.topPanel.add((Component)this.nameLabel, gridBagConstraints);
        this.objectNames.setToolTipText(ResourceMgr.getString("d_LblObjectNames"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.topPanel.add((Component)this.objectNames, gridBagConstraints);
        this.valueLabel.setText(ResourceMgr.getString("LblSearchCriteria"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.topPanel.add((Component)this.valueLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.topPanel.add((Component)this.searchValues, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.matchAll.setText(ResourceMgr.getString("LblSearchMatchAll"));
        this.matchAll.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.matchAll, gridBagConstraints);
        this.ignoreCase.setText(ResourceMgr.getString("LblSearchIgnoreCase"));
        this.ignoreCase.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.ignoreCase, gridBagConstraints);
        this.regex.setText(ResourceMgr.getString("LblSearchRegEx"));
        this.regex.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.regex, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 8, 5, 0);
        this.topPanel.add((Component)this.jPanel1, gridBagConstraints);
        this.typeLabel.setText(ResourceMgr.getString("LblTypes"));
        this.typeLabel.setToolTipText(ResourceMgr.getString("d_LblTypes"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.topPanel.add((Component)this.typeLabel, gridBagConstraints);
        this.objectTypes.setToolTipText(ResourceMgr.getString("d_LblTypes"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.topPanel.add((Component)this.objectTypes, gridBagConstraints);
        this.selectSchemasButton.setText("...");
        this.selectSchemasButton.setToolTipText(ResourceMgr.getString("d_LblSchemaSelect"));
        this.selectSchemasButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ObjectSourceSearchPanel.this.selectSchemasButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.topPanel.add((Component)this.selectSchemasButton, gridBagConstraints);
        this.selectTypesButton.setText("...");
        this.selectTypesButton.setToolTipText(ResourceMgr.getString("d_LblTypeSelect"));
        this.selectTypesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ObjectSourceSearchPanel.this.selectTypesButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 5);
        this.topPanel.add((Component)this.selectTypesButton, gridBagConstraints);
        this.selectConnection.setText(ResourceMgr.getString("LblSelectConnection"));
        this.selectConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ObjectSourceSearchPanel.this.selectConnectionActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 9, 0, 5);
        this.topPanel.add((Component)this.selectConnection, gridBagConstraints);
        this.add((Component)this.topPanel, "North");
        this.resultContainer.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        this.resultContainer.setLayout(new BorderLayout(5, 5));
        this.splitPane.setDividerLocation(200);
        this.resultContainer.add((Component)this.splitPane, "Center");
        this.add((Component)this.resultContainer, "Center");
        this.footerPanel.setLayout(new GridBagLayout());
        this.statusbar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
        this.statusbar.setMaximumSize(new Dimension(73, 32));
        this.statusbar.setPreferredSize(new Dimension(100, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.footerPanel.add((Component)this.statusbar, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.startButton.setText(ResourceMgr.getString("LblStartSearch"));
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ObjectSourceSearchPanel.this.startButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.buttonPanel.add((Component)this.startButton, gridBagConstraints);
        this.showScriptButton.setText(ResourceMgr.getString("LblShowScript"));
        this.showScriptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ObjectSourceSearchPanel.this.showScriptButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.buttonPanel.add((Component)this.showScriptButton, gridBagConstraints);
        this.closeButton.setText(ResourceMgr.getString("LblClose"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ObjectSourceSearchPanel.this.closeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.buttonPanel.add((Component)this.closeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 5, 3, 5);
        this.footerPanel.add((Component)this.buttonPanel, gridBagConstraints);
        this.add((Component)this.footerPanel, "South");
    }

    private void selectConnectionActionPerformed(ActionEvent actionEvent) {
        this.selectConnection();
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.closeWindow();
    }

    private void startButtonActionPerformed(ActionEvent actionEvent) {
        if (this.searcher == null || !this.searcher.isRunning()) {
            this.startSearch();
        } else {
            this.cancelSearch();
        }
    }

    private void selectTypesButtonActionPerformed(ActionEvent actionEvent) {
        this.selectObjectTypes();
    }

    private void selectSchemasButtonActionPerformed(ActionEvent actionEvent) {
        this.selectSchemas();
    }

    private void showScriptButtonActionPerformed(ActionEvent actionEvent) {
        this.showWbCommand();
    }

    private static /* synthetic */ void lambda$selectFromList$5(JList jList, int[] nArray, int n) {
        jList.setSelectedIndices(nArray);
        jList.ensureIndexIsVisible(n);
    }
}

