/*
 * Decompiled with CFR 0.152.
 */
package workbench.print;

import java.awt.print.PageFormat;
import javax.print.attribute.DocAttribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;

public class PrintUtil {
    public static PrintRequestAttributeSet getPrintAttributes(PageFormat pageFormat) {
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        DocAttribute docAttribute = null;
        int n = pageFormat.getOrientation();
        switch (n) {
            case 0: {
                docAttribute = OrientationRequested.LANDSCAPE;
                break;
            }
            case 1: {
                docAttribute = OrientationRequested.PORTRAIT;
                break;
            }
            case 2: {
                docAttribute = OrientationRequested.REVERSE_LANDSCAPE;
            }
        }
        hashPrintRequestAttributeSet.add(docAttribute);
        docAttribute = new MediaPrintableArea((float)pageFormat.getImageableX(), (float)pageFormat.getImageableY(), (float)pageFormat.getImageableWidth(), (float)pageFormat.getImageableHeight(), 25400);
        hashPrintRequestAttributeSet.add(docAttribute);
        return hashPrintRequestAttributeSet;
    }

    public static boolean pageFormatEquals(PageFormat pageFormat, PageFormat pageFormat2) {
        if (pageFormat == null || pageFormat2 == null) {
            return false;
        }
        if (pageFormat.getOrientation() != pageFormat2.getOrientation()) {
            return false;
        }
        if (pageFormat.getHeight() != pageFormat2.getHeight()) {
            return false;
        }
        if (pageFormat.getWidth() != pageFormat2.getWidth()) {
            return false;
        }
        if (pageFormat.getImageableX() != pageFormat2.getImageableX()) {
            return false;
        }
        if (pageFormat.getImageableY() != pageFormat2.getImageableY()) {
            return false;
        }
        if (pageFormat.getImageableWidth() != pageFormat2.getImageableWidth()) {
            return false;
        }
        return pageFormat.getImageableHeight() == pageFormat2.getImageableHeight();
    }

    public static double millimeterToPoints(double d) {
        double d2 = PrintUtil.millimeterToInch(d);
        return d2 * 72.0;
    }

    public static double pointsToMillimeter(double d) {
        double d2 = d / 72.0;
        return PrintUtil.inchToMillimeter(d2);
    }

    public static double millimeterToInch(double d) {
        return d / 25.4;
    }

    public static double inchToMillimeter(double d) {
        return d * 25.4;
    }

    public static void printPageFormat(String string, PageFormat pageFormat) {
        double d = pageFormat.getPaper().getWidth();
        double d2 = pageFormat.getPaper().getHeight();
        double d3 = pageFormat.getImageableX();
        double d4 = d - d3 - pageFormat.getImageableWidth();
        double d5 = (int)pageFormat.getImageableY();
        double d6 = d2 - d5 - pageFormat.getImageableHeight();
        System.out.println(string + ": paper size=[" + d + "," + d2 + "]");
        System.out.println(string + ": imageable size=[" + pageFormat.getImageableWidth() + "," + pageFormat.getImageableHeight() + "]");
        System.out.println(string + ": margins (l,r,t,b)=" + d3 + "," + d4 + "," + d5 + "," + d6);
    }
}

