/*
 * Decompiled with CFR 0.152.
 */
package workbench.print;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import workbench.gui.components.WbTable;
import workbench.gui.renderer.WbRenderer;
import workbench.resource.GuiSettings;
import workbench.resource.Settings;

public class TablePrintPage {
    private final WbTable table;
    private final int startRow;
    private final int endRow;
    private final int startCol;
    private final int endCol;
    private final int[] colWidth;
    private Font printFont;
    private int pageNumDown = -1;
    private int pageNumAcross = -1;
    private int pageIndex;
    private int lineSpacing;
    private int colSpacing;
    private String[] colHeaders;
    private Color alternateBackground = GuiSettings.getAlternateRowColor();
    private boolean useAlternatingColors = false;

    public TablePrintPage(WbTable wbTable, int n, int n2, int n3, int n4, int[] nArray) {
        this.table = wbTable;
        this.startRow = n;
        this.endRow = n2;
        this.startCol = n3;
        this.endCol = n4;
        this.colWidth = nArray;
        this.useAlternatingColors = Settings.getInstance().getBoolProperty("workbench.print.alternate.colors", false);
    }

    public void setUseAlternateColor(boolean bl) {
        this.useAlternatingColors = bl;
    }

    public void setFont(Font font) {
        this.printFont = font;
    }

    public Font getFont() {
        return this.printFont;
    }

    public void setPageNumberAcross(int n) {
        this.pageNumAcross = n;
    }

    public int getPageNumberAcross() {
        return this.pageNumAcross;
    }

    public void setPageNumberDown(int n) {
        this.pageNumDown = n;
    }

    public int getPageNumberDown() {
        return this.pageNumDown;
    }

    public void setPageIndex(int n) {
        this.pageIndex = n;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setColumnHeaders(String[] stringArray) {
        this.colHeaders = stringArray;
    }

    public void setSpacing(int n, int n2) {
        this.lineSpacing = n;
        this.colSpacing = n2;
    }

    public void print(Graphics2D graphics2D) {
        Font font = this.printFont;
        if (font == null) {
            font = this.table.getFont();
        }
        Font font2 = font.deriveFont(1);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font2);
        int n = fontMetrics.getHeight();
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.setFont(font2);
        graphics2D.setColor(Color.BLACK);
        int n2 = 0;
        int n3 = 0;
        graphics2D.translate(0, n);
        int n4 = 0;
        for (int i = this.startCol; i <= this.endCol; ++i) {
            if (this.colHeaders[i] != null) {
                graphics2D.drawString(this.colHeaders[i], n2, 0);
            }
            n2 += this.colWidth[i] + this.colSpacing;
            n4 += this.colWidth[i] + this.colSpacing;
        }
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(0.3f));
        graphics2D.drawLine(0, 1, n2, 1);
        if (stroke != null) {
            graphics2D.setStroke(stroke);
        }
        fontMetrics = graphics2D.getFontMetrics(font);
        n = fontMetrics.getHeight();
        graphics2D.setTransform(affineTransform);
        graphics2D.translate(0, n3 += n + this.lineSpacing);
        graphics2D.setFont(font);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        for (int i = this.startRow; i <= this.endRow; ++i) {
            int n5;
            if (this.useAlternatingColors && this.alternateBackground != null) {
                int n6 = n5 = i % 2 == 1 ? 1 : 0;
                if (n5 != 0) {
                    graphics2D.setColor(this.alternateBackground);
                } else {
                    graphics2D.setColor(Color.WHITE);
                }
                graphics2D.fillRect(0, this.lineSpacing * 2, n4, n + this.lineSpacing);
                graphics2D.setColor(Color.BLACK);
            }
            n5 = 0;
            for (int j = this.startCol; j <= this.endCol; ++j) {
                Object object = this.table.getValueAt(i, j);
                if (object == null) continue;
                TableCellRenderer tableCellRenderer = this.table.getCellRenderer(i, j);
                Component component = tableCellRenderer.getTableCellRendererComponent(this.table, object, false, false, i, j);
                if (tableCellRenderer instanceof WbRenderer) {
                    WbRenderer wbRenderer = (WbRenderer)((Object)tableCellRenderer);
                    String string = wbRenderer.getDisplayValue();
                    rectangle3.x = 0;
                    rectangle3.y = 0;
                    rectangle3.width = this.colWidth[j];
                    rectangle3.height = n;
                    rectangle.height = 0;
                    rectangle.width = 0;
                    rectangle.y = 0;
                    rectangle.x = 0;
                    rectangle2.height = 0;
                    rectangle2.width = 0;
                    rectangle2.y = 0;
                    rectangle2.x = 0;
                    String string2 = SwingUtilities.layoutCompoundLabel(fontMetrics, string, null, 1, wbRenderer.getHorizontalAlignment(), 1, 4, rectangle3, rectangle, rectangle2, 0);
                    graphics2D.drawString(string2, n5 + rectangle2.x, n);
                    n5 += this.colWidth[j] + this.colSpacing;
                    continue;
                }
                component.setSize(this.colWidth[j], n);
                component.print(graphics2D);
                graphics2D.translate(this.colWidth[j] + this.colSpacing, 0);
            }
            graphics2D.setTransform(affineTransform);
            graphics2D.translate(0, n3 += n + this.lineSpacing);
        }
    }

    public String toString() {
        return "V-page:" + this.pageNumDown + ", H-page:" + this.pageNumAcross + ", from row: " + this.startRow + " to row: " + this.endRow + ", from column: " + this.startCol + " to column: " + this.endCol;
    }
}

