/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class DelimiterDefinition
implements Serializable {
    public static final DelimiterDefinition STANDARD_DELIMITER = new DelimiterDefinition(";", true);
    public static final DelimiterDefinition DEFAULT_ORA_DELIMITER = new DelimiterDefinition("/", true);
    public static final DelimiterDefinition DEFAULT_MS_DELIMITER = new DelimiterDefinition("GO", true);
    public static final String ORA_ABBREVIATION = "oracle";
    public static final String SQLSERVER_ABBREVIATION = "mssql";
    public static final List<String> ABBREVIATIONS = Collections.unmodifiableList(CollectionUtil.arrayList("oracle", "mssql"));
    private String delimiter;
    private boolean singleLineDelimiter;
    private boolean changed;
    private Pattern slePattern;
    private boolean isImmutable;
    private boolean isStandard;

    public DelimiterDefinition() {
        this.delimiter = "";
        this.changed = false;
        this.slePattern = null;
    }

    private DelimiterDefinition(String string, boolean bl) {
        this.setDelimiter(string);
        this.changed = false;
        this.initPattern();
        this.isImmutable = bl;
    }

    public DelimiterDefinition(String string) {
        this.setDelimiter(string);
        this.changed = false;
        this.initPattern();
    }

    public DelimiterDefinition createCopy() {
        if (this.isImmutable) {
            return this;
        }
        DelimiterDefinition delimiterDefinition = new DelimiterDefinition(this.delimiter);
        delimiterDefinition.changed = false;
        return delimiterDefinition;
    }

    public boolean isEmpty() {
        return this.delimiter == null || this.delimiter.length() == 0;
    }

    public boolean isStandard() {
        return this.isStandard;
    }

    public boolean isNonStandard() {
        return !this.isStandard();
    }

    public void resetChanged() {
        this.changed = false;
    }

    public static DelimiterDefinition parseCmdLineArgument(String string) {
        if (StringUtil.isEmptyString(string)) {
            return null;
        }
        if ("ORA".equalsIgnoreCase(string = string.trim()) || ORA_ABBREVIATION.equalsIgnoreCase(string) || "SQLPLUS".equalsIgnoreCase(string)) {
            return DEFAULT_ORA_DELIMITER;
        }
        if (SQLSERVER_ABBREVIATION.equalsIgnoreCase(string) || "sqlserver".equalsIgnoreCase(string)) {
            return DEFAULT_MS_DELIMITER;
        }
        if (string.equals(";")) {
            return STANDARD_DELIMITER;
        }
        String string2 = string;
        int n = string.indexOf(58);
        if (n == -1) {
            n = string.indexOf(59, 1);
        }
        if (n > -1) {
            string2 = string2.substring(0, n);
        }
        return new DelimiterDefinition(string2);
    }

    public String toString() {
        return this.delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public final void setDelimiter(String string) {
        if (this.isImmutable) {
            return;
        }
        if (string == null) {
            return;
        }
        if (StringUtil.stringsAreNotEqual(this.delimiter, string)) {
            this.delimiter = string.trim();
            this.singleLineDelimiter = !this.delimiter.equals(";");
            this.changed = true;
            this.isStandard = this.delimiter.equals(";");
            this.initPattern();
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean isSingleLine() {
        return this.singleLineDelimiter;
    }

    public void setSingleLine(boolean bl) {
        if (this.isImmutable) {
            return;
        }
        if (bl != this.singleLineDelimiter) {
            this.singleLineDelimiter = bl;
            this.changed = true;
            this.initPattern();
        }
    }

    public boolean terminatesScript(String string, boolean bl, char c) {
        if (StringUtil.isEmptyString(string)) {
            return false;
        }
        string = SqlUtil.makeCleanSql(string, true, false, bl, false, c);
        if (this.isSingleLine()) {
            return this.slePattern.matcher(string).find();
        }
        return string.endsWith(this.delimiter);
    }

    public boolean equals(String string) {
        return StringUtil.equalStringIgnoreCase(this.delimiter, string);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof DelimiterDefinition) {
            DelimiterDefinition delimiterDefinition = (DelimiterDefinition)object;
            if (this.singleLineDelimiter == delimiterDefinition.singleLineDelimiter) {
                return StringUtil.equalStringIgnoreCase(this.delimiter, delimiterDefinition.delimiter);
            }
            return false;
        }
        if (object instanceof String) {
            return StringUtil.equalStringIgnoreCase(this.delimiter, (String)object);
        }
        return false;
    }

    public int hashCode() {
        return (this.delimiter + Boolean.toString(this.singleLineDelimiter)).hashCode();
    }

    private void initPattern() {
        this.slePattern = this.singleLineDelimiter && this.delimiter != null ? Pattern.compile("(?i)[\\r\\n|\\n]+[ \t]*" + StringUtil.quoteRegexMeta(this.delimiter) + "[ \t]*[\\r\\n|\\n]*$") : null;
    }

    public String removeFromEnd(String string) {
        if (StringUtil.isEmptyString(string)) {
            return string;
        }
        int n = -1;
        if (this.isSingleLine()) {
            Matcher matcher = this.slePattern.matcher(string);
            boolean bl = matcher.find();
            if (bl) {
                n = matcher.start();
            }
        } else {
            n = string.lastIndexOf(this.delimiter);
        }
        if (n > -1) {
            return string.substring(0, n).trim();
        }
        return string;
    }

    public String getScriptText() {
        if (this.isNonStandard()) {
            return "\n" + this.delimiter + "\n";
        }
        return this.delimiter;
    }
}

