/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class ResultProcessor {
    private final Statement currentStatement;
    private ResultSet currentResult;
    private final WbConnection originalConnection;
    private boolean supportsGetMoreResults = true;

    public ResultProcessor(Statement statement, ResultSet resultSet, WbConnection wbConnection) {
        this.originalConnection = wbConnection;
        this.currentStatement = statement;
        this.currentResult = resultSet;
    }

    public ResultSet getResult() {
        if (this.currentResult != null) {
            ResultSet resultSet = this.currentResult;
            this.currentResult = null;
            return resultSet;
        }
        try {
            return this.currentStatement.getResultSet();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean hasMoreResults() throws SQLException {
        try {
            return this.supportsGetMoreResults && this.checkForMoreResults();
        }
        catch (AbstractMethodError | SQLFeatureNotSupportedException throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Error when calling getMoreResults()", throwable);
            this.supportsGetMoreResults = false;
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Error when calling getMoreResults()", sQLException);
            if (!this.originalConnection.getDbSettings().ignoreSQLErrorsForGetMoreResults()) {
                throw sQLException;
            }
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Error when calling getMoreResults()", throwable);
        }
        return false;
    }

    private boolean checkForMoreResults() throws SQLException {
        return this.currentStatement.getMoreResults();
    }
}

